/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples.terasort;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeraOutputFormat
extends FileOutputFormat<Text, Text> {
    static final String FINAL_SYNC_ATTRIBUTE = "mapreduce.terasort.final.sync";
    private OutputCommitter committer = null;

    static void setFinalSync(JobContext job, boolean newValue) {
        job.getConfiguration().setBoolean(FINAL_SYNC_ATTRIBUTE, newValue);
    }

    public static boolean getFinalSync(JobContext job) {
        return job.getConfiguration().getBoolean(FINAL_SYNC_ATTRIBUTE, false);
    }

    public void checkOutputSpecs(JobContext job) throws InvalidJobConfException, IOException {
        Path outDir = TeraOutputFormat.getOutputPath((JobContext)job);
        if (outDir == null) {
            throw new InvalidJobConfException("Output directory not set in JobConf.");
        }
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])new Path[]{outDir}, (Configuration)job.getConfiguration());
    }

    public RecordWriter<Text, Text> getRecordWriter(TaskAttemptContext job) throws IOException {
        Path file = this.getDefaultWorkFile(job, "");
        FileSystem fs = file.getFileSystem(job.getConfiguration());
        FSDataOutputStream fileOut = fs.create(file);
        return new TeraRecordWriter(fileOut, (JobContext)job);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        if (this.committer == null) {
            Path output = TeraOutputFormat.getOutputPath((JobContext)context);
            this.committer = new FileOutputCommitter(output, context);
        }
        return this.committer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TeraRecordWriter
    extends RecordWriter<Text, Text> {
        private boolean finalSync = false;
        private FSDataOutputStream out;

        public TeraRecordWriter(FSDataOutputStream out, JobContext job) {
            this.finalSync = TeraOutputFormat.getFinalSync(job);
            this.out = out;
        }

        public synchronized void write(Text key, Text value) throws IOException {
            this.out.write(key.getBytes(), 0, key.getLength());
            this.out.write(value.getBytes(), 0, value.getLength());
        }

        public void close(TaskAttemptContext context) throws IOException {
            if (this.finalSync) {
                this.out.hsync();
            }
            this.out.close();
        }
    }
}

