/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.PreWarmVertex;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.examples.OrderedWordCount;
import org.apache.tez.examples.TezExampleBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSessionExample
extends TezExampleBase {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSessionExample.class);
    private static final String enablePrewarmConfig = "simplesessionexample.prewarm";

    @Override
    protected void printUsage() {
        System.err.println("Usage:  simplesessionexample <in1,in2> <out1, out2> [numPartitions]");
    }

    @Override
    protected int validateArgs(String[] otherArgs) {
        if (otherArgs.length < 2 || otherArgs.length > 3) {
            return 2;
        }
        return 0;
    }

    @Override
    protected int runJob(String[] args, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        int numPartitions;
        System.out.println("Running SimpleSessionExample");
        String[] inputPaths = args[0].split(",");
        String[] outputPaths = args[1].split(",");
        if (inputPaths.length != outputPaths.length) {
            System.err.println("Inputs and outputs must be equal in number");
            return 3;
        }
        int n = numPartitions = args.length == 3 ? Integer.parseInt(args[2]) : 1;
        if (tezConf.getBoolean(enablePrewarmConfig, false)) {
            tezConf.setInt("tez.am.session.min.held-containers", numPartitions);
            tezClient.preWarm(PreWarmVertex.createConfigBuilder((Configuration)tezConf).build());
        }
        for (int i = 0; i < inputPaths.length; ++i) {
            DAG dag = OrderedWordCount.createDAG(tezConf, inputPaths[i], outputPaths[i], numPartitions, this.isDisableSplitGrouping(), "DAG-Iteration-" + i);
            LOG.info("Running dag number " + i);
            if (this.runDag(dag, false, LOG) == 0) continue;
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        TezConfiguration tezConf = new TezConfiguration();
        tezConf.setBoolean("tez.am.mode.session", true);
        int res = ToolRunner.run((Configuration)tezConf, (Tool)new SimpleSessionExample(), (String[])args);
        System.exit(res);
    }
}

