/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;

@InterfaceAudience.Private
public abstract class TezExampleBase
extends Configured
implements Tool {
    private TezClient tezClientInternal;

    public final int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        return this._execute(otherArgs, null, null);
    }

    public int run(TezConfiguration conf, String[] args, @Nullable TezClient tezClient) throws Exception {
        this.setConf((Configuration)conf);
        String[] otherArgs = new GenericOptionsParser((Configuration)conf, args).getRemainingArgs();
        return this._execute(otherArgs, conf, tezClient);
    }

    public int runDag(DAG dag, boolean printCounters, Log logger) throws TezException, InterruptedException, IOException {
        DAGStatus dagStatus;
        this.tezClientInternal.waitTillReady();
        DAGClient dagClient = this.tezClientInternal.submitDAG(dag);
        HashSet getOpts = Sets.newHashSet();
        if (printCounters) {
            getOpts.add(StatusGetOpts.GET_COUNTERS);
        }
        if ((dagStatus = dagClient.waitForCompletionWithStatusUpdates((Set)getOpts)).getState() != DAGStatus.State.SUCCEEDED) {
            logger.info((Object)("DAG diagnostics: " + dagStatus.getDiagnostics()));
            return -1;
        }
        return 0;
    }

    private int _validateArgs(String[] args) {
        int res = this.validateArgs(args);
        if (res != 0) {
            this.printUsage();
            return res;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _execute(String[] otherArgs, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        int result = this._validateArgs(otherArgs);
        if (result != 0) {
            return result;
        }
        if (tezConf == null) {
            tezConf = new TezConfiguration(this.getConf());
        }
        UserGroupInformation.setConfiguration((Configuration)tezConf);
        boolean ownTezClient = false;
        if (tezClient == null) {
            ownTezClient = true;
            this.tezClientInternal = this.createTezClient(tezConf);
        } else {
            this.tezClientInternal = tezClient;
        }
        try {
            int n = this.runJob(otherArgs, tezConf, this.tezClientInternal);
            return n;
        }
        finally {
            if (ownTezClient && this.tezClientInternal != null) {
                this.tezClientInternal.stop();
            }
        }
    }

    private TezClient createTezClient(TezConfiguration tezConf) throws IOException, TezException {
        TezClient tezClient = TezClient.create((String)((Object)((Object)this)).getClass().getSimpleName(), (TezConfiguration)tezConf);
        tezClient.start();
        return tezClient;
    }

    protected abstract void printUsage();

    protected abstract int validateArgs(String[] var1);

    protected abstract int runJob(String[] var1, TezConfiguration var2, TezClient var3) throws Exception;
}

