/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.Records;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.oldrecords.TaskAttemptReport;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.RecoveryParser;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventCounterUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventDiagnosticsUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.DiagnosableEvent;
import org.apache.tez.dag.app.dag.event.RecoveryEvent;
import org.apache.tez.dag.app.dag.event.SpeculatorEventTaskAttemptStatusUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventAttemptFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventAttemptKilled;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminated;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminatedBySystem;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventOutputFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSchedule;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStatusUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSubmitted;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventTerminationCauseEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventTezEventUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventTAFailed;
import org.apache.tez.dag.app.dag.event.TaskEventTAKilled;
import org.apache.tez.dag.app.dag.event.TaskEventTALaunched;
import org.apache.tez.dag.app.dag.event.TaskEventTASucceeded;
import org.apache.tez.dag.app.dag.event.VertexEventRouteEvent;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImplHelpers;
import org.apache.tez.dag.app.rm.AMSchedulerEventTAEnded;
import org.apache.tez.dag.app.rm.AMSchedulerEventTALaunchRequest;
import org.apache.tez.dag.app.rm.AMSchedulerEventTAStateUpdated;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.InputFailedEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TaskStatistics;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.serviceplugins.api.TaskScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAttemptImpl
implements TaskAttempt,
EventHandler<TaskAttemptEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskAttemptImpl.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final TezCounters EMPTY_COUNTERS = new TezCounters();
    protected final Configuration conf;
    protected EventHandler eventHandler;
    private final TezTaskAttemptID attemptId;
    private final Clock clock;
    private TaskAttemptTerminationCause terminationCause = TaskAttemptTerminationCause.UNKNOWN_ERROR;
    private final List<String> diagnostics = new ArrayList<String>();
    private final Lock readLock;
    private final Lock writeLock;
    protected final AppContext appContext;
    private final TaskHeartbeatHandler taskHeartbeatHandler;
    private RecoveryParser.TaskAttemptRecoveryData recoveryData;
    private long launchTime = 0L;
    private long finishTime = 0L;
    private String trackerName;
    private int httpPort;
    private Container container;
    private long allocationTime;
    private ContainerId containerId;
    private NodeId containerNodeId;
    private String nodeHttpAddress;
    private String nodeRackName;
    private final Vertex vertex;
    private final TaskLocationHint locationHint;
    private final TaskSpec taskSpec;
    @VisibleForTesting
    boolean appendNextDataEvent = true;
    ArrayList<DataEventDependencyInfo> lastDataEvents = Lists.newArrayList();
    @VisibleForTesting
    TaskAttempt.TaskAttemptStatus reportedStatus;
    private DAGCounter localityCounter;
    TaskStatistics statistics;
    long lastNotifyProgressTimestamp = 0L;
    private final long hungIntervalMax;
    private List<TezEvent> taGeneratedEvents = Lists.newArrayList();
    Set<String> taskHosts = new HashSet<String>();
    Set<String> taskRacks = new HashSet<String>();
    private Map<TezTaskAttemptID, Long> uniquefailedOutputReports = Maps.newHashMap();
    private static double MAX_ALLOWED_OUTPUT_FAILURES_FRACTION;
    private static int MAX_ALLOWED_OUTPUT_FAILURES;
    private static int MAX_ALLOWED_TIME_FOR_TASK_READ_ERROR_SEC;
    protected final boolean isRescheduled;
    private final Resource taskResource;
    private final ContainerContext containerContext;
    private final boolean leafVertex;
    private TezTaskAttemptID creationCausalTA;
    private long creationTime;
    private long scheduledTime;
    protected static final FailedTransitionHelper FAILED_HELPER;
    protected static final KilledTransitionHelper KILLED_HELPER;
    private static SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> TERMINATED_AFTER_SUCCESS_HELPER;
    private static SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> STATUS_UPDATER;
    private final StateMachine<TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachine;
    private static StateMachineFactory<TaskAttemptImpl, TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachineFactory;

    public TaskAttemptImpl(TezTaskAttemptID attemptId, EventHandler eventHandler, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, Configuration conf, Clock clock, TaskHeartbeatHandler taskHeartbeatHandler, AppContext appContext, boolean isRescheduled, Resource resource, ContainerContext containerContext, boolean leafVertex, Vertex vertex, TaskLocationHint locationHint, TaskSpec taskSpec) {
        this(attemptId, eventHandler, taskCommunicatorManagerInterface, conf, clock, taskHeartbeatHandler, appContext, isRescheduled, resource, containerContext, leafVertex, vertex, locationHint, taskSpec, null);
    }

    public TaskAttemptImpl(TezTaskAttemptID attemptId, EventHandler eventHandler, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, Configuration conf, Clock clock, TaskHeartbeatHandler taskHeartbeatHandler, AppContext appContext, boolean isRescheduled, Resource resource, ContainerContext containerContext, boolean leafVertex, Vertex vertex, TaskLocationHint locationHint, TaskSpec taskSpec, TezTaskAttemptID schedulingCausalTA) {
        MAX_ALLOWED_OUTPUT_FAILURES = conf.getInt("tez.task.max.allowed.output.failures", 10);
        MAX_ALLOWED_OUTPUT_FAILURES_FRACTION = conf.getDouble("tez.task.max.allowed.output.failures.fraction", 0.1);
        MAX_ALLOWED_TIME_FOR_TASK_READ_ERROR_SEC = conf.getInt("tez.am.max.allowed.time-sec.for-read-error", 300);
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
        this.attemptId = attemptId;
        this.eventHandler = eventHandler;
        this.conf = conf;
        this.clock = clock;
        this.taskHeartbeatHandler = taskHeartbeatHandler;
        this.appContext = appContext;
        this.vertex = vertex;
        this.locationHint = locationHint;
        this.taskSpec = taskSpec;
        this.creationCausalTA = schedulingCausalTA;
        this.creationTime = clock.getTime();
        this.lastNotifyProgressTimestamp = clock.getTime();
        this.reportedStatus = new TaskAttempt.TaskAttemptStatus(this.attemptId);
        this.initTaskAttemptStatus(this.reportedStatus);
        RackResolver.init((Configuration)conf);
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.isRescheduled = isRescheduled;
        this.taskResource = resource;
        this.containerContext = containerContext;
        this.leafVertex = leafVertex;
        this.hungIntervalMax = conf.getLong("tez.task.progress.stuck.interval-ms", -1L);
        this.recoveryData = appContext.getDAGRecoveryData() == null ? null : appContext.getDAGRecoveryData().getTaskAttemptRecoveryData(attemptId);
    }

    @Override
    public TezTaskAttemptID getID() {
        return this.attemptId;
    }

    @Override
    public TezTaskID getTaskID() {
        return this.attemptId.getTaskID();
    }

    @Override
    public TezVertexID getVertexID() {
        return this.attemptId.getTaskID().getVertexID();
    }

    @Override
    public TezDAGID getDAGID() {
        return this.getVertexID().getDAGId();
    }

    public TezTaskAttemptID getSchedulingCausalTA() {
        return this.creationCausalTA;
    }

    @Override
    public TaskAttemptReport getReport() {
        TaskAttemptReport result = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        this.readLock.lock();
        try {
            result.setTaskAttemptId(this.attemptId);
            result.setTaskAttemptState(this.getState());
            result.setProgress(this.reportedStatus.progress);
            result.setStartTime(this.launchTime);
            result.setFinishTime(this.finishTime);
            result.setDiagnosticInfo(StringUtils.join(this.getDiagnostics(), (String)LINE_SEPARATOR));
            result.setCounters(this.getCounters());
            result.setContainerId(this.getAssignedContainerID());
            result.setNodeManagerHost(this.trackerName);
            result.setNodeManagerHttpPort(this.httpPort);
            if (this.containerNodeId != null) {
                result.setNodeManagerPort(this.containerNodeId.getPort());
            }
            TaskAttemptReport taskAttemptReport = result;
            return taskAttemptReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<String> getDiagnostics() {
        ArrayList<String> result = new ArrayList<String>();
        this.readLock.lock();
        try {
            result.addAll(this.diagnostics);
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskAttemptTerminationCause getTerminationCause() {
        return this.terminationCause;
    }

    @Override
    public TezCounters getCounters() {
        this.readLock.lock();
        try {
            this.reportedStatus.setLocalityCounter(this.localityCounter);
            TezCounters counters = this.reportedStatus.counters;
            if (counters == null) {
                counters = EMPTY_COUNTERS;
            }
            TezCounters tezCounters = counters;
            return tezCounters;
        }
        finally {
            this.readLock.unlock();
        }
    }

    TaskStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.reportedStatus.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskAttemptState getState() {
        this.readLock.lock();
        try {
            TaskAttemptState taskAttemptState = this.getStateNoLock();
            return taskAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskAttemptState getStateNoLock() {
        return TaskAttemptImpl.getExternalState((TaskAttemptStateInternal)this.stateMachine.getCurrentState());
    }

    @Override
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = EnumSet.of(TaskAttemptStateInternal.SUCCEEDED, TaskAttemptStateInternal.FAILED, TaskAttemptStateInternal.FAIL_IN_PROGRESS, TaskAttemptStateInternal.KILLED, TaskAttemptStateInternal.KILL_IN_PROGRESS).contains((Object)this.getInternalState());
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerId getAssignedContainerID() {
        this.readLock.lock();
        try {
            ContainerId containerId = this.containerId;
            return containerId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Container getAssignedContainer() {
        this.readLock.lock();
        try {
            Container container = this.container;
            return container;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getAssignedContainerMgrAddress() {
        this.readLock.lock();
        try {
            String string = this.containerNodeId.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public NodeId getNodeId() {
        this.readLock.lock();
        try {
            NodeId nodeId = this.containerNodeId;
            return nodeId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getNodeHttpAddress() {
        this.readLock.lock();
        try {
            String string = this.nodeHttpAddress;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getNodeRackName() {
        this.readLock.lock();
        try {
            String string = this.nodeRackName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getLaunchTime() {
        this.readLock.lock();
        try {
            long l = this.launchTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getCreationTime() {
        this.readLock.lock();
        try {
            long l = this.creationTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public TezTaskAttemptID getCreationCausalAttempt() {
        this.readLock.lock();
        try {
            TezTaskAttemptID tezTaskAttemptID = this.creationCausalTA;
            return tezTaskAttemptID;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getAllocationTime() {
        this.readLock.lock();
        try {
            long l = this.allocationTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getScheduleTime() {
        this.readLock.lock();
        try {
            long l = this.scheduledTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    Vertex getVertex() {
        return this.vertex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskAttemptEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing TaskAttemptEvent " + event.getTaskAttemptID() + " of type " + event.getType() + " while in state " + (Object)((Object)this.getInternalState()) + ". Event: " + (Object)((Object)event));
        }
        this.writeLock.lock();
        try {
            TaskAttemptStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error("Can't handle this event at current state for " + this.attemptId, (Throwable)e);
                this.eventHandler.handle((Event)new DAGEventDiagnosticsUpdate(this.attemptId.getTaskID().getVertexID().getDAGId(), "Invalid event " + event.getType() + " on TaskAttempt " + this.attemptId));
                this.eventHandler.handle((Event)new DAGEvent(this.attemptId.getTaskID().getVertexID().getDAGId(), DAGEventType.INTERNAL_ERROR));
            }
            catch (RuntimeException e) {
                LOG.error("Uncaught exception when handling event " + event.getType() + " at current state " + (Object)((Object)oldState) + " for " + this.attemptId, (Throwable)e);
                this.eventHandler.handle((Event)new DAGEventDiagnosticsUpdate(this.attemptId.getTaskID().getVertexID().getDAGId(), "Uncaught exception when handling event " + event.getType() + " on TaskAttempt " + this.attemptId + " at state " + (Object)((Object)oldState) + ", error=" + e.getMessage()));
                this.eventHandler.handle((Event)new DAGEvent(this.attemptId.getTaskID().getVertexID().getDAGId(), DAGEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getInternalState() && LOG.isDebugEnabled()) {
                LOG.debug(this.attemptId + " TaskAttempt Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState()) + " due to event " + event.getType());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    public TaskAttemptStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskAttemptStateInternal taskAttemptStateInternal = (TaskAttemptStateInternal)this.stateMachine.getCurrentState();
            return taskAttemptStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static TaskAttemptState getExternalState(TaskAttemptStateInternal smState) {
        switch (smState) {
            case NEW: 
            case START_WAIT: 
            case SUBMITTED: {
                return TaskAttemptState.STARTING;
            }
            case RUNNING: {
                return TaskAttemptState.RUNNING;
            }
            case FAILED: 
            case FAIL_IN_PROGRESS: {
                return TaskAttemptState.FAILED;
            }
            case KILLED: 
            case KILL_IN_PROGRESS: {
                return TaskAttemptState.KILLED;
            }
            case SUCCEEDED: {
                return TaskAttemptState.SUCCEEDED;
            }
        }
        throw new TezUncheckedException("Attempt to convert invalid stateMachineTaskAttemptState to externalTaskAttemptState: " + (Object)((Object)smState));
    }

    private void sendEvent(Event<?> event) {
        this.eventHandler.handle(event);
    }

    private void setFinishTime() {
        if (this.launchTime != 0L && this.finishTime == 0L) {
            this.finishTime = this.clock.getTime();
        }
    }

    private static DAGEventCounterUpdate createDAGCounterUpdateEventTALaunched(TaskAttemptImpl ta) {
        DAGEventCounterUpdate dagCounterEvent = new DAGEventCounterUpdate(ta.getDAGID());
        dagCounterEvent.addCounterUpdate((Enum<?>)DAGCounter.TOTAL_LAUNCHED_TASKS, 1L);
        return dagCounterEvent;
    }

    private static DAGEventCounterUpdate createDAGCounterUpdateEventTAFinished(TaskAttemptImpl taskAttempt, TaskAttemptState taState) {
        DAGEventCounterUpdate jce = new DAGEventCounterUpdate(taskAttempt.getDAGID());
        if (taState == TaskAttemptState.FAILED) {
            jce.addCounterUpdate((Enum<?>)DAGCounter.NUM_FAILED_TASKS, 1L);
        } else if (taState == TaskAttemptState.KILLED) {
            jce.addCounterUpdate((Enum<?>)DAGCounter.NUM_KILLED_TASKS, 1L);
        } else if (taState == TaskAttemptState.SUCCEEDED) {
            jce.addCounterUpdate((Enum<?>)DAGCounter.NUM_SUCCEEDED_TASKS, 1L);
        }
        return jce;
    }

    private void updateProgressSplits() {
    }

    private void sendTaskAttemptCleanupEvent() {
    }

    private TaskLocationHint getTaskLocationHint() {
        return this.locationHint;
    }

    protected String[] resolveHosts(String[] src) {
        return TaskAttemptImplHelpers.resolveHosts(src);
    }

    protected void logJobHistoryAttemptStarted() {
        Preconditions.checkArgument((this.recoveryData == null ? 1 : 0) != 0);
        String inProgressLogsUrl = this.getInProgressLogsUrl();
        String completedLogsUrl = this.getCompletedLogsUrl();
        TaskAttemptStartedEvent startEvt = new TaskAttemptStartedEvent(this.attemptId, this.getVertex().getName(), this.launchTime, this.containerId, this.containerNodeId, inProgressLogsUrl, completedLogsUrl, this.nodeHttpAddress);
        this.appContext.getHistoryHandler().handle(new DAGHistoryEvent(this.getDAGID(), startEvt));
    }

    protected void logJobHistoryAttemptFinishedEvent(TaskAttemptStateInternal state) {
        Preconditions.checkArgument((this.recoveryData == null || this.recoveryData.getTaskAttemptFinishedEvent() == null ? 1 : 0) != 0, (Object)"log TaskAttemptFinishedEvent again in recovery when there's already another TaskAtttemptFinishedEvent");
        if (this.getLaunchTime() == 0L) {
            return;
        }
        TaskAttemptFinishedEvent finishEvt = new TaskAttemptFinishedEvent(this.attemptId, this.getVertex().getName(), this.getLaunchTime(), this.getFinishTime(), TaskAttemptState.SUCCEEDED, null, null, "", this.getCounters(), this.lastDataEvents, this.taGeneratedEvents, this.creationTime, this.creationCausalTA, this.allocationTime, null, null, null, null, null);
        this.appContext.getHistoryHandler().handle(new DAGHistoryEvent(this.getDAGID(), finishEvt));
    }

    protected void logJobHistoryAttemptUnsuccesfulCompletion(TaskAttemptState state, TaskFailureType taskFailureType) {
        Preconditions.checkArgument((this.recoveryData == null || this.recoveryData.getTaskAttemptFinishedEvent() == null ? 1 : 0) != 0, (Object)"log TaskAttemptFinishedEvent again in recovery when there's already another TaskAtttemptFinishedEvent");
        if (state == TaskAttemptState.FAILED && taskFailureType == null) {
            throw new IllegalStateException("FAILED state must be accompanied by a FailureType");
        }
        long finishTime = this.getFinishTime();
        ContainerId unsuccessfulContainerId = null;
        NodeId unsuccessfulContainerNodeId = null;
        String inProgressLogsUrl = null;
        String completedLogsUrl = null;
        if (finishTime <= 0L) {
            finishTime = this.clock.getTime();
            unsuccessfulContainerId = this.containerId;
            unsuccessfulContainerNodeId = this.containerNodeId;
            inProgressLogsUrl = this.getInProgressLogsUrl();
            completedLogsUrl = this.getCompletedLogsUrl();
        }
        TaskAttemptFinishedEvent finishEvt = new TaskAttemptFinishedEvent(this.attemptId, this.getVertex().getName(), this.getLaunchTime(), finishTime, state, taskFailureType, this.terminationCause, StringUtils.join(this.getDiagnostics(), (String)LINE_SEPARATOR), this.getCounters(), this.lastDataEvents, this.taGeneratedEvents, this.creationTime, this.creationCausalTA, this.allocationTime, unsuccessfulContainerId, unsuccessfulContainerNodeId, inProgressLogsUrl, completedLogsUrl, this.nodeHttpAddress);
        this.appContext.getHistoryHandler().handle(new DAGHistoryEvent(this.getDAGID(), finishEvt));
    }

    private String getInProgressLogsUrl() {
        String inProgressLogsUrl = null;
        if (this.getVertex().getServicePluginInfo().getContainerLauncherName().equals(TezConstants.getTezYarnServicePluginName()) || this.getVertex().getServicePluginInfo().getContainerLauncherName().equals(TezConstants.getTezUberServicePluginName())) {
            if (this.containerId != null && this.nodeHttpAddress != null) {
                String containerIdStr = this.containerId.toString();
                inProgressLogsUrl = this.nodeHttpAddress + "/" + "node/containerlogs" + "/" + containerIdStr + "/" + this.appContext.getUser();
            }
        } else {
            inProgressLogsUrl = this.appContext.getTaskCommunicatorManager().getInProgressLogsUrl(this.getVertex().getTaskCommunicatorIdentifier(), this.attemptId, this.containerNodeId);
        }
        return inProgressLogsUrl;
    }

    private String getCompletedLogsUrl() {
        String completedLogsUrl = null;
        if (this.getVertex().getServicePluginInfo().getContainerLauncherName().equals(TezConstants.getTezYarnServicePluginName()) || this.getVertex().getServicePluginInfo().getContainerLauncherName().equals(TezConstants.getTezUberServicePluginName())) {
            if (this.containerId != null && this.containerNodeId != null && this.nodeHttpAddress != null) {
                String containerIdStr = this.containerId.toString();
                if (this.conf.getBoolean("yarn.log-aggregation-enable", false) && this.conf.get("yarn.log.server.url") != null) {
                    String contextStr = "v_" + this.getVertex().getName() + "_" + this.attemptId.toString();
                    completedLogsUrl = this.conf.get("yarn.log.server.url") + "/" + this.containerNodeId.toString() + "/" + containerIdStr + "/" + contextStr + "/" + this.appContext.getUser();
                }
            }
        } else {
            completedLogsUrl = this.appContext.getTaskCommunicatorManager().getCompletedLogsUrl(this.getVertex().getTaskCommunicatorIdentifier(), this.attemptId, this.containerNodeId);
        }
        return completedLogsUrl;
    }

    private boolean isSpeculationEnabled() {
        return this.conf.getBoolean("tez.am.speculation.enabled", false);
    }

    @VisibleForTesting
    protected void sendInputFailedToConsumers() {
        Vertex vertex = this.getVertex();
        Map<Vertex, Edge> edges = vertex.getOutputVertices();
        if (edges != null && !edges.isEmpty()) {
            ArrayList tezIfEvents = Lists.newArrayListWithCapacity((int)edges.size());
            for (Vertex edgeVertex : edges.keySet()) {
                tezIfEvents.add(new TezEvent((org.apache.tez.runtime.api.Event)new InputFailedEvent(), new EventMetaData(EventMetaData.EventProducerConsumerType.SYSTEM, vertex.getName(), edgeVertex.getName(), this.getID()), this.appContext.getClock().getTime()));
            }
            this.sendEvent((Event<?>)new VertexEventRouteEvent(vertex.getVertexId(), tezIfEvents));
        }
    }

    private void trySetTerminationCause(TaskAttemptTerminationCause err) {
        if (this.terminationCause == TaskAttemptTerminationCause.UNKNOWN_ERROR) {
            this.terminationCause = err;
        }
    }

    private void initTaskAttemptStatus(TaskAttempt.TaskAttemptStatus result) {
        result.progress = 0.0f;
        result.state = TaskAttemptState.NEW;
    }

    private void addDiagnosticInfo(String diag) {
        if (diag != null && !diag.equals("")) {
            this.diagnostics.add(diag);
        }
    }

    public String toString() {
        return this.getID().toString();
    }

    @Override
    public void setLastEventSent(TezEvent lastEventSent) {
        this.writeLock.lock();
        try {
            if (!EnumSet.of(TaskAttemptStateInternal.FAIL_IN_PROGRESS, TaskAttemptStateInternal.KILL_IN_PROGRESS, TaskAttemptStateInternal.FAILED, TaskAttemptStateInternal.KILLED, TaskAttemptStateInternal.SUCCEEDED).contains((Object)this.getInternalState())) {
                DataEventDependencyInfo info = new DataEventDependencyInfo(lastEventSent.getEventReceivedTime(), lastEventSent.getSourceInfo().getTaskAttemptID());
                if (this.appendNextDataEvent) {
                    this.appendNextDataEvent = false;
                    this.lastDataEvents.add(info);
                } else {
                    this.lastDataEvents.set(this.lastDataEvents.size() - 1, info);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    static {
        FAILED_HELPER = new FailedTransitionHelper();
        KILLED_HELPER = new KilledTransitionHelper();
        TERMINATED_AFTER_SUCCESS_HELPER = new TerminatedAfterSuccessHelper(KILLED_HELPER);
        STATUS_UPDATER = new StatusUpdaterTransition();
        stateMachineFactory = new StateMachineFactory((Enum)TaskAttemptStateInternal.NEW).addTransition((Enum)TaskAttemptStateInternal.NEW, EnumSet.of(TaskAttemptStateInternal.NEW, TaskAttemptStateInternal.START_WAIT, TaskAttemptStateInternal.FAILED), (Enum)TaskAttemptEventType.TA_SCHEDULE, (MultipleArcTransition)new ScheduleTaskattemptTransition()).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_FAILED, (SingleArcTransition)new TerminateTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILL_REQUEST, (SingleArcTransition)new TerminateTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILLED, (SingleArcTransition)new TerminateTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)new SucceededTransition()).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptEventType.TA_SUBMITTED, (SingleArcTransition)new SubmittedTransition()).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_KILL_REQUEST, (SingleArcTransition)new TerminatedBeforeRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILLED, (SingleArcTransition)new TerminatedBeforeRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_NODE_FAILED, (SingleArcTransition)new NodeFailedBeforeRunningTransition()).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATING, (SingleArcTransition)new ContainerTerminatingBeforeRunningTransition()).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED, (SingleArcTransition)new ContainerCompletedBeforeRunningTransition()).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM, (SingleArcTransition)new ContainerCompletedBeforeRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_STARTED_REMOTELY, (SingleArcTransition)new StartedTransition()).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptEventType.TA_STATUS_UPDATE, STATUS_UPDATER).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)new SucceededTransition()).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_FAILED, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_KILL_REQUEST, (SingleArcTransition)new TerminatedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILLED, (SingleArcTransition)new TerminatedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_NODE_FAILED, (SingleArcTransition)new TerminatedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATING, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED, (SingleArcTransition)new ContainerCompletedWhileRunningTransition()).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM, (SingleArcTransition)new ContainerCompletedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, EnumSet.of(TaskAttemptStateInternal.FAIL_IN_PROGRESS, TaskAttemptStateInternal.SUBMITTED), (Enum)TaskAttemptEventType.TA_OUTPUT_FAILED, (MultipleArcTransition)new OutputReportedFailedTransition()).addTransition((Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptStateInternal.SUBMITTED, (Enum)TaskAttemptEventType.TA_TEZ_EVENT_UPDATE, (SingleArcTransition)new TezEventUpdaterTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_STATUS_UPDATE, STATUS_UPDATER).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)new SucceededTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_FAILED, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_KILL_REQUEST, (SingleArcTransition)new TerminatedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILLED, (SingleArcTransition)new TerminatedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_NODE_FAILED, (SingleArcTransition)new TerminatedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATING, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED, (SingleArcTransition)new ContainerCompletedWhileRunningTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM, (SingleArcTransition)new ContainerCompletedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, EnumSet.of(TaskAttemptStateInternal.FAIL_IN_PROGRESS, TaskAttemptStateInternal.RUNNING), (Enum)TaskAttemptEventType.TA_OUTPUT_FAILED, (MultipleArcTransition)new OutputReportedFailedTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_TEZ_EVENT_UPDATE, (SingleArcTransition)new TezEventUpdaterTransition()).addTransition((Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED, (SingleArcTransition)new ContainerCompletedWhileTerminating()).addTransition((Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, EnumSet.of(TaskAttemptEventType.TA_STARTED_REMOTELY, new TaskAttemptEventType[]{TaskAttemptEventType.TA_SCHEDULE, TaskAttemptEventType.TA_SUBMITTED, TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM, TaskAttemptEventType.TA_TEZ_EVENT_UPDATE, TaskAttemptEventType.TA_STATUS_UPDATE, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILED, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_KILL_REQUEST, TaskAttemptEventType.TA_KILLED, TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_OUTPUT_FAILED})).addTransition((Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED, (SingleArcTransition)new ContainerCompletedWhileTerminating()).addTransition((Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, EnumSet.of(TaskAttemptEventType.TA_STARTED_REMOTELY, new TaskAttemptEventType[]{TaskAttemptEventType.TA_SCHEDULE, TaskAttemptEventType.TA_SUBMITTED, TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM, TaskAttemptEventType.TA_TEZ_EVENT_UPDATE, TaskAttemptEventType.TA_STATUS_UPDATE, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILED, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_KILL_REQUEST, TaskAttemptEventType.TA_KILLED, TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_OUTPUT_FAILED})).addTransition((Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptStateInternal.KILLED, EnumSet.of(TaskAttemptEventType.TA_STARTED_REMOTELY, new TaskAttemptEventType[]{TaskAttemptEventType.TA_SCHEDULE, TaskAttemptEventType.TA_SUBMITTED, TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM, TaskAttemptEventType.TA_TEZ_EVENT_UPDATE, TaskAttemptEventType.TA_STATUS_UPDATE, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILED, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_KILL_REQUEST, TaskAttemptEventType.TA_KILLED, TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATED, TaskAttemptEventType.TA_OUTPUT_FAILED})).addTransition((Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptStateInternal.FAILED, EnumSet.of(TaskAttemptEventType.TA_STARTED_REMOTELY, new TaskAttemptEventType[]{TaskAttemptEventType.TA_SCHEDULE, TaskAttemptEventType.TA_SUBMITTED, TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM, TaskAttemptEventType.TA_STATUS_UPDATE, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILED, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_KILL_REQUEST, TaskAttemptEventType.TA_KILLED, TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATED, TaskAttemptEventType.TA_OUTPUT_FAILED})).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptStateInternal.KILLED, TaskAttemptStateInternal.SUCCEEDED), (Enum)TaskAttemptEventType.TA_KILL_REQUEST, (MultipleArcTransition)new TerminatedAfterSuccessTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptStateInternal.KILLED, TaskAttemptStateInternal.SUCCEEDED), (Enum)TaskAttemptEventType.TA_KILLED, (MultipleArcTransition)new TerminatedAfterSuccessTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptStateInternal.KILLED, TaskAttemptStateInternal.SUCCEEDED), (Enum)TaskAttemptEventType.TA_NODE_FAILED, (MultipleArcTransition)new TerminatedAfterSuccessTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptStateInternal.FAILED, TaskAttemptStateInternal.SUCCEEDED), (Enum)TaskAttemptEventType.TA_OUTPUT_FAILED, (MultipleArcTransition)new OutputReportedFailedTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATED, TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM)).installTopology();
    }

    protected static class KilledTransitionHelper
    implements TerminatedTransitionHelper {
        protected KilledTransitionHelper() {
        }

        @Override
        public TaskAttemptStateInternal getTaskAttemptStateInternal() {
            return TaskAttemptStateInternal.KILLED;
        }

        @Override
        public TaskAttemptState getTaskAttemptState() {
            return TaskAttemptState.KILLED;
        }

        @Override
        public TaskEvent getTaskEvent(TezTaskAttemptID taskAttemptId, TaskAttemptEvent event) {
            return new TaskEventTAKilled(taskAttemptId, event);
        }

        @Override
        public TaskFailureType getFailureType(TaskAttemptEvent event) {
            return null;
        }
    }

    protected static class FailedTransitionHelper
    implements TerminatedTransitionHelper {
        protected FailedTransitionHelper() {
        }

        @Override
        public TaskAttemptStateInternal getTaskAttemptStateInternal() {
            return TaskAttemptStateInternal.FAILED;
        }

        @Override
        public TaskAttemptState getTaskAttemptState() {
            return TaskAttemptState.FAILED;
        }

        @Override
        public TaskEvent getTaskEvent(TezTaskAttemptID taskAttemptId, TaskAttemptEvent event) {
            return new TaskEventTAFailed(taskAttemptId, this.getFailureType(event), event);
        }

        @Override
        public TaskFailureType getFailureType(TaskAttemptEvent event) {
            if (event instanceof TaskAttemptEventAttemptFailed) {
                return ((TaskAttemptEventAttemptFailed)event).getTaskFailureType();
            }
            return TaskFailureType.NON_FATAL;
        }
    }

    protected static interface TerminatedTransitionHelper {
        public TaskAttemptStateInternal getTaskAttemptStateInternal();

        public TaskAttemptState getTaskAttemptState();

        public TaskEvent getTaskEvent(TezTaskAttemptID var1, TaskAttemptEvent var2);

        public TaskFailureType getFailureType(TaskAttemptEvent var1);
    }

    protected static class OutputReportedFailedTransition
    implements MultipleArcTransition<TaskAttemptImpl, TaskAttemptEvent, TaskAttemptStateInternal> {
        protected OutputReportedFailedTransition() {
        }

        public TaskAttemptStateInternal transition(TaskAttemptImpl attempt, TaskAttemptEvent event) {
            boolean withinOutputFailureLimits;
            int readErrorTimespanSec;
            TaskAttemptEventOutputFailed outputFailedEvent = (TaskAttemptEventOutputFailed)event;
            TezEvent tezEvent = outputFailedEvent.getInputFailedEvent();
            TezTaskAttemptID failedDestTaId = tezEvent.getSourceInfo().getTaskAttemptID();
            InputReadErrorEvent readErrorEvent = (InputReadErrorEvent)tezEvent.getEvent();
            int failedInputIndexOnDestTa = readErrorEvent.getIndex();
            if (readErrorEvent.getVersion() != attempt.getID().getId()) {
                throw new TezUncheckedException(attempt.getID() + " incorrectly blamed for read error from " + failedDestTaId + " at inputIndex " + failedInputIndexOnDestTa + " version" + readErrorEvent.getVersion());
            }
            LOG.info(attempt.getID() + " blamed for read error from " + failedDestTaId + " at inputIndex " + failedInputIndexOnDestTa);
            long time = attempt.clock.getTime();
            Long firstErrReportTime = (Long)attempt.uniquefailedOutputReports.get(failedDestTaId);
            if (firstErrReportTime == null) {
                attempt.uniquefailedOutputReports.put(failedDestTaId, time);
                firstErrReportTime = time;
            }
            boolean crossTimeDeadline = (readErrorTimespanSec = (int)((time - firstErrReportTime) / 1000L)) >= MAX_ALLOWED_TIME_FOR_TASK_READ_ERROR_SEC;
            float failureFraction = (float)attempt.uniquefailedOutputReports.size() / (float)outputFailedEvent.getConsumerTaskNumber();
            boolean withinFailureFractionLimits = (double)failureFraction <= MAX_ALLOWED_OUTPUT_FAILURES_FRACTION;
            boolean bl = withinOutputFailureLimits = attempt.uniquefailedOutputReports.size() < MAX_ALLOWED_OUTPUT_FAILURES;
            if (!crossTimeDeadline && withinFailureFractionLimits && withinOutputFailureLimits) {
                return attempt.getInternalState();
            }
            String message = attempt.getID() + " being failed for too many output errors. " + "failureFraction=" + failureFraction + ", MAX_ALLOWED_OUTPUT_FAILURES_FRACTION=" + MAX_ALLOWED_OUTPUT_FAILURES_FRACTION + ", uniquefailedOutputReports=" + attempt.uniquefailedOutputReports.size() + ", MAX_ALLOWED_OUTPUT_FAILURES=" + MAX_ALLOWED_OUTPUT_FAILURES + ", MAX_ALLOWED_TIME_FOR_TASK_READ_ERROR_SEC=" + MAX_ALLOWED_TIME_FOR_TASK_READ_ERROR_SEC + ", readErrorTimespan=" + readErrorTimespanSec;
            LOG.info(message);
            attempt.addDiagnosticInfo(message);
            attempt.sendInputFailedToConsumers();
            if (attempt.getInternalState() == TaskAttemptStateInternal.SUCCEEDED) {
                new TerminatedAfterSuccessHelper(FAILED_HELPER).transition(attempt, event);
                return TaskAttemptStateInternal.FAILED;
            }
            new TerminatedWhileRunningTransition(FAILED_HELPER).transition(attempt, event);
            return TaskAttemptStateInternal.FAIL_IN_PROGRESS;
        }
    }

    protected static class TerminatedAfterSuccessTransition
    implements MultipleArcTransition<TaskAttemptImpl, TaskAttemptEvent, TaskAttemptStateInternal> {
        protected TerminatedAfterSuccessTransition() {
        }

        public TaskAttemptStateInternal transition(TaskAttemptImpl attempt, TaskAttemptEvent event) {
            boolean fromRecovery = event instanceof RecoveryEvent && ((RecoveryEvent)((Object)event)).isFromRecovery();
            attempt.recoveryData = null;
            if (!fromRecovery && attempt.leafVertex) {
                return TaskAttemptStateInternal.SUCCEEDED;
            }
            attempt.sendInputFailedToConsumers();
            TERMINATED_AFTER_SUCCESS_HELPER.transition((Object)attempt, (Object)event);
            return TaskAttemptStateInternal.KILLED;
        }
    }

    protected static class TerminatedAfterSuccessHelper
    extends TerminatedBeforeRunningTransition {
        @Override
        protected boolean sendSchedulerEvent() {
            return false;
        }

        public TerminatedAfterSuccessHelper(TerminatedTransitionHelper helper) {
            super(helper);
        }

        @Override
        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
            ta.sendTaskAttemptCleanupEvent();
        }
    }

    protected static class ContainerCompletedWhileTerminating
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected ContainerCompletedWhileTerminating() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            ta.sendTaskAttemptCleanupEvent();
            TaskAttemptEventContainerTerminated tEvent = (TaskAttemptEventContainerTerminated)event;
            ta.addDiagnosticInfo(tEvent.getDiagnosticInfo());
        }
    }

    protected static class ContainerCompletedWhileRunningTransition
    extends TerminatedWhileRunningTransition {
        public ContainerCompletedWhileRunningTransition() {
            super(FAILED_HELPER);
        }

        public ContainerCompletedWhileRunningTransition(TerminatedTransitionHelper helper) {
            super(helper);
        }

        @Override
        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
            ta.sendTaskAttemptCleanupEvent();
        }
    }

    protected static class TerminatedWhileRunningTransition
    extends TerminatedBeforeRunningTransition {
        public TerminatedWhileRunningTransition(TerminatedTransitionHelper helper) {
            super(helper);
        }

        @Override
        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
            ta.taskHeartbeatHandler.unregister(ta.attemptId);
            ta.reportedStatus.state = this.helper.getTaskAttemptState();
            if (ta.isSpeculationEnabled()) {
                ta.sendEvent((Event)new SpeculatorEventTaskAttemptStatusUpdate(ta.attemptId, this.helper.getTaskAttemptState(), ta.clock.getTime()));
            }
        }
    }

    protected static class SucceededTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected SucceededTransition() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            if (ta.recoveryData != null && ta.recoveryData.isTaskAttemptSucceeded()) {
                TaskAttemptFinishedEvent taFinishedEvent = ta.recoveryData.getTaskAttemptFinishedEvent();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("TaskAttempt is recovered to SUCCEEDED, attemptId=" + ta.attemptId);
                }
                ta.reportedStatus.counters = taFinishedEvent.getCounters();
                List<TezEvent> tezEvents = taFinishedEvent.getTAGeneratedEvents();
                if (tezEvents != null && !tezEvents.isEmpty()) {
                    ta.sendEvent((Event)new VertexEventRouteEvent(ta.getVertexID(), tezEvents));
                }
                ta.finishTime = taFinishedEvent.getFinishTime();
            } else {
                ta.setFinishTime();
                ta.logJobHistoryAttemptFinishedEvent(TaskAttemptStateInternal.SUCCEEDED);
            }
            ta.sendEvent((Event)TaskAttemptImpl.createDAGCounterUpdateEventTAFinished(ta, TaskAttemptState.SUCCEEDED));
            ta.sendEvent((Event)new AMSchedulerEventTAEnded(ta, ta.containerId, TaskAttemptState.SUCCEEDED, null, null, ta.getVertex().getTaskSchedulerIdentifier()));
            ta.sendEvent((Event)new TaskEventTASucceeded(ta.attemptId));
            ta.taskHeartbeatHandler.unregister(ta.attemptId);
            ta.reportedStatus.state = TaskAttemptState.SUCCEEDED;
            ta.reportedStatus.progress = 1.0f;
            if (ta.isSpeculationEnabled()) {
                ta.sendEvent((Event)new SpeculatorEventTaskAttemptStatusUpdate(ta.attemptId, TaskAttemptState.SUCCEEDED, ta.clock.getTime()));
            }
        }
    }

    protected static class TezEventUpdaterTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected TezEventUpdaterTransition() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            TaskAttemptEventTezEventUpdate tezEventUpdate = (TaskAttemptEventTezEventUpdate)event;
            ta.taGeneratedEvents.addAll(tezEventUpdate.getTezEvents());
        }
    }

    protected static class StatusUpdaterTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected StatusUpdaterTransition() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            TaskAttemptEventStatusUpdate sEvent = (TaskAttemptEventStatusUpdate)event;
            TaskStatusUpdateEvent statusEvent = sEvent.getStatusEvent();
            ta.reportedStatus.state = ta.getState();
            ta.reportedStatus.progress = statusEvent.getProgress();
            ta.reportedStatus.counters = statusEvent.getCounters();
            ta.statistics = statusEvent.getStatistics();
            if (statusEvent.getProgressNotified()) {
                ta.lastNotifyProgressTimestamp = ta.clock.getTime();
            } else {
                long currTime = ta.clock.getTime();
                if (ta.hungIntervalMax > 0L && currTime - ta.lastNotifyProgressTimestamp > ta.hungIntervalMax) {
                    String diagnostics = "Attempt failed because it appears to make no progress for " + ta.hungIntervalMax + "ms";
                    LOG.info(diagnostics + " " + ta.getID());
                    ta.sendEvent((Event)new TaskAttemptEventAttemptFailed(ta.getID(), TaskAttemptEventType.TA_FAILED, TaskFailureType.NON_FATAL, diagnostics, TaskAttemptTerminationCause.NO_PROGRESS));
                }
            }
            if (sEvent.getReadErrorReported()) {
                ta.appendNextDataEvent = true;
            }
            ta.updateProgressSplits();
            if (ta.isSpeculationEnabled()) {
                ta.sendEvent((Event)new SpeculatorEventTaskAttemptStatusUpdate(ta.attemptId, ta.getState(), ta.clock.getTime()));
            }
        }
    }

    protected static class ContainerCompletedBeforeRunningTransition
    extends TerminatedBeforeRunningTransition {
        public ContainerCompletedBeforeRunningTransition() {
            super(FAILED_HELPER);
        }

        public ContainerCompletedBeforeRunningTransition(TerminatedTransitionHelper helper) {
            super(helper);
        }

        @Override
        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
            ta.sendTaskAttemptCleanupEvent();
        }
    }

    protected static class ContainerTerminatingBeforeRunningTransition
    extends TerminatedBeforeRunningTransition {
        public ContainerTerminatingBeforeRunningTransition() {
            super(FAILED_HELPER);
        }

        @Override
        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
        }
    }

    protected static class NodeFailedBeforeRunningTransition
    extends TerminatedBeforeRunningTransition {
        public NodeFailedBeforeRunningTransition() {
            super(KILLED_HELPER);
        }

        @Override
        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
        }
    }

    protected static class TerminatedBeforeRunningTransition
    extends TerminateTransition {
        public TerminatedBeforeRunningTransition(TerminatedTransitionHelper helper) {
            super(helper);
        }

        protected boolean sendSchedulerEvent() {
            return true;
        }

        @Override
        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
            if (this.sendSchedulerEvent()) {
                ta.sendEvent((Event)new AMSchedulerEventTAEnded(ta, ta.containerId, this.helper.getTaskAttemptState(), TezUtilsInternal.toTaskAttemptEndReason((TaskAttemptTerminationCause)ta.terminationCause), ta instanceof DiagnosableEvent ? ((DiagnosableEvent)((Object)ta)).getDiagnosticInfo() : null, ta.getVertex().getTaskSchedulerIdentifier()));
            }
        }
    }

    protected static class StartedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected StartedTransition() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent taskAttemptEvent) {
            ta.sendEvent((Event)new AMSchedulerEventTAStateUpdated(ta, TaskScheduler.SchedulerTaskState.STARTED, ta.getVertex().getTaskSchedulerIdentifier()));
        }
    }

    protected static class SubmittedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected SubmittedTransition() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent origEvent) {
            TaskAttemptEventSubmitted event = (TaskAttemptEventSubmitted)origEvent;
            AMContainer amContainer = ta.appContext.getAllContainers().get(event.getContainerId());
            Container container = amContainer.getContainer();
            ta.allocationTime = amContainer.getCurrentTaskAttemptAllocationTime();
            ta.container = container;
            ta.containerId = event.getContainerId();
            ta.containerNodeId = container.getNodeId();
            ta.nodeHttpAddress = StringInterner.weakIntern((String)container.getNodeHttpAddress());
            ta.nodeRackName = StringInterner.weakIntern((String)RackResolver.resolve((String)ta.containerNodeId.getHost()).getNetworkLocation());
            ta.launchTime = ta.clock.getTime();
            InetSocketAddress nodeHttpInetAddr = NetUtils.createSocketAddr((String)ta.nodeHttpAddress);
            ta.trackerName = StringInterner.weakIntern((String)nodeHttpInetAddr.getHostName());
            ta.httpPort = nodeHttpInetAddr.getPort();
            ta.sendEvent((Event)TaskAttemptImpl.createDAGCounterUpdateEventTALaunched(ta));
            LOG.info("TaskAttempt: [" + ta.attemptId + "] submitted." + " Is using containerId: [" + ta.containerId + "]" + " on NM: [" + ta.containerNodeId + "]");
            ta.logJobHistoryAttemptStarted();
            if (ta.taskHosts.contains(ta.containerNodeId.getHost())) {
                ta.localityCounter = DAGCounter.DATA_LOCAL_TASKS;
            } else if (ta.taskRacks.contains(ta.nodeRackName)) {
                ta.localityCounter = DAGCounter.RACK_LOCAL_TASKS;
            } else if (ta.getTaskLocationHint() != null) {
                ta.localityCounter = DAGCounter.OTHER_LOCAL_TASKS;
            }
            ta.sendEvent((Event)new TaskEventTALaunched(ta.attemptId));
            if (ta.isSpeculationEnabled()) {
                ta.sendEvent((Event)new SpeculatorEventTaskAttemptStatusUpdate(ta.attemptId, TaskAttemptState.RUNNING, ta.launchTime, true));
            }
            ta.sendEvent((Event)new AMSchedulerEventTAStateUpdated(ta, TaskScheduler.SchedulerTaskState.SUBMITTED, ta.getVertex().getTaskSchedulerIdentifier()));
            ta.taskHeartbeatHandler.register(ta.attemptId);
        }
    }

    protected static class TerminateTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        TerminatedTransitionHelper helper;

        public TerminateTransition(TerminatedTransitionHelper helper) {
            this.helper = helper;
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            RecoveryEvent rEvent;
            Container container;
            AMContainer amContainer;
            TaskAttemptEvent tEvent;
            if (event instanceof DiagnosableEvent) {
                ta.addDiagnosticInfo(((DiagnosableEvent)((Object)event)).getDiagnosticInfo());
            }
            if (!(event instanceof TaskAttemptEventTerminationCauseEvent)) {
                throw new TezUncheckedException("Invalid event received in TerminateTransition, requiredClass=TaskAttemptEventTerminationCauseEvent, eventClass=" + ((Object)((Object)event)).getClass().getName());
            }
            ta.trySetTerminationCause(((TaskAttemptEventTerminationCauseEvent)((Object)event)).getTerminationCause());
            if (event instanceof TaskAttemptEventContainerTerminated) {
                tEvent = (TaskAttemptEventContainerTerminated)event;
                amContainer = ta.appContext.getAllContainers().get(((TaskAttemptEventContainerTerminated)tEvent).getContainerId());
                container = amContainer.getContainer();
                ta.allocationTime = amContainer.getCurrentTaskAttemptAllocationTime();
                ta.container = container;
                ta.containerId = ((TaskAttemptEventContainerTerminated)tEvent).getContainerId();
                ta.containerNodeId = container.getNodeId();
                ta.nodeHttpAddress = StringInterner.weakIntern((String)container.getNodeHttpAddress());
            }
            if (event instanceof TaskAttemptEventContainerTerminatedBySystem) {
                tEvent = (TaskAttemptEventContainerTerminatedBySystem)event;
                amContainer = ta.appContext.getAllContainers().get(((TaskAttemptEventContainerTerminatedBySystem)tEvent).getContainerId());
                container = amContainer.getContainer();
                ta.allocationTime = amContainer.getCurrentTaskAttemptAllocationTime();
                ta.container = container;
                ta.containerId = ((TaskAttemptEventContainerTerminatedBySystem)tEvent).getContainerId();
                ta.containerNodeId = container.getNodeId();
                ta.nodeHttpAddress = StringInterner.weakIntern((String)container.getNodeHttpAddress());
            }
            if (ta.recoveryData == null || ta.recoveryData.getTaskAttemptFinishedEvent() == null) {
                ta.setFinishTime();
                ta.logJobHistoryAttemptUnsuccesfulCompletion(this.helper.getTaskAttemptState(), this.helper.getFailureType(event));
            } else {
                ta.finishTime = ta.recoveryData.getTaskAttemptFinishedEvent().getFinishTime();
            }
            if (event instanceof RecoveryEvent && (rEvent = (RecoveryEvent)((Object)event)).isFromRecovery() && LOG.isDebugEnabled()) {
                LOG.debug("Faked TerminateEvent from recovery, taskAttemptId=" + ta.getID());
            }
            ta.sendEvent((Event)TaskAttemptImpl.createDAGCounterUpdateEventTAFinished(ta, this.helper.getTaskAttemptState()));
            ta.sendEvent((Event)this.helper.getTaskEvent(ta.attemptId, event));
        }
    }

    protected static class ScheduleTaskattemptTransition
    implements MultipleArcTransition<TaskAttemptImpl, TaskAttemptEvent, TaskAttemptStateInternal> {
        protected ScheduleTaskattemptTransition() {
        }

        public TaskAttemptStateInternal transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            if (ta.recoveryData != null) {
                TaskAttemptFinishedEvent taFinishedEvent;
                TaskAttemptStartedEvent taStartedEvent = ta.recoveryData.getTaskAttemptStartedEvent();
                if (taStartedEvent != null) {
                    ta.launchTime = taStartedEvent.getStartTime();
                    taFinishedEvent = ta.recoveryData.getTaskAttemptFinishedEvent();
                    if (taFinishedEvent == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Only TaskAttemptStartedEvent but no TaskAttemptFinishedEvent, send out TaskAttemptEventAttemptKilled to move it to KILLED");
                        }
                        ta.sendEvent((Event)new TaskAttemptEventAttemptKilled(ta.getID(), "Task Attempt killed in recovery due to can't recover the running task attempt", TaskAttemptTerminationCause.TERMINATED_AT_RECOVERY, true));
                        return TaskAttemptStateInternal.NEW;
                    }
                }
                Preconditions.checkArgument(((taFinishedEvent = ta.recoveryData.getTaskAttemptFinishedEvent()) != null ? 1 : 0) != 0, (Object)("Both of TaskAttemptStartedEvent and TaskFinishedEvent is null,taskAttemptId=" + ta.getID()));
                switch (taFinishedEvent.getState()) {
                    case FAILED: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("TaskAttemptFinishedEvent is seen with state of FAILED, send TA_FAILED to itself, attemptId=" + ta.attemptId);
                        }
                        ta.sendEvent((Event)new TaskAttemptEventAttemptFailed(ta.getID(), TaskAttemptEventType.TA_FAILED, taFinishedEvent.getTaskFailureType(), taFinishedEvent.getDiagnostics(), taFinishedEvent.getTaskAttemptError(), true));
                        break;
                    }
                    case KILLED: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("TaskAttemptFinishedEvent is seen with state of KILLED, send TA_KILLED to itself, attemptId=" + ta.attemptId);
                        }
                        ta.sendEvent((Event)new TaskAttemptEventAttemptKilled(ta.getID(), taFinishedEvent.getDiagnostics(), taFinishedEvent.getTaskAttemptError(), true));
                        break;
                    }
                    case SUCCEEDED: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("TaskAttemptFinishedEvent is seen with state of SUCCEEDED, send TA_DONE to itself, attemptId=" + ta.attemptId);
                        }
                        ta.sendEvent((Event)new TaskAttemptEvent(ta.getID(), TaskAttemptEventType.TA_DONE));
                        break;
                    }
                    default: {
                        throw new TezUncheckedException("Invalid state in TaskAttemptFinishedEvent, state=" + (Object)((Object)taFinishedEvent.getState()) + ", taId=" + ta.getID());
                    }
                }
                return TaskAttemptStateInternal.NEW;
            }
            TaskAttemptEventSchedule scheduleEvent = (TaskAttemptEventSchedule)event;
            ta.scheduledTime = ta.clock.getTime();
            String[] requestHosts = new String[]{};
            HashSet<String> racks = new HashSet<String>();
            TaskLocationHint locationHint = ta.getTaskLocationHint();
            if (locationHint != null) {
                if (locationHint.getRacks() != null) {
                    racks.addAll(locationHint.getRacks());
                }
                if (locationHint.getHosts() != null) {
                    for (String host : locationHint.getHosts()) {
                        racks.add(RackResolver.resolve((String)host).getNetworkLocation());
                    }
                    requestHosts = ta.resolveHosts(locationHint.getHosts().toArray(new String[locationHint.getHosts().size()]));
                }
            }
            ta.taskHosts.addAll(Arrays.asList(requestHosts));
            ta.taskRacks = racks;
            if (ta.isRescheduled && ta.getVertex().getVertexConfig().getTaskRescheduleHigherPriority()) {
                locationHint = null;
            }
            LOG.debug("Asking for container launch with taskAttemptContext: {}", (Object)ta.taskSpec);
            int priority = ta.isRescheduled && ta.getVertex().getVertexConfig().getTaskRescheduleHigherPriority() ? scheduleEvent.getPriorityHighLimit() : (scheduleEvent.getPriorityHighLimit() + scheduleEvent.getPriorityLowLimit()) / 2;
            Vertex vertex = ta.getVertex();
            AMSchedulerEventTALaunchRequest launchRequestEvent = new AMSchedulerEventTALaunchRequest(ta.attemptId, ta.taskResource, ta.taskSpec, ta, locationHint, priority, ta.containerContext, vertex.getTaskSchedulerIdentifier(), vertex.getContainerLauncherIdentifier(), vertex.getTaskCommunicatorIdentifier());
            ta.sendEvent((Event)launchRequestEvent);
            return TaskAttemptStateInternal.START_WAIT;
        }
    }

    public static class DataEventDependencyInfo {
        long timestamp;
        TezTaskAttemptID taId;

        public DataEventDependencyInfo(long time, TezTaskAttemptID id) {
            this.timestamp = time;
            this.taId = id;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public TezTaskAttemptID getTaskAttemptId() {
            return this.taId;
        }

        public static RecoveryProtos.DataEventDependencyInfoProto toProto(DataEventDependencyInfo info) {
            RecoveryProtos.DataEventDependencyInfoProto.Builder builder = RecoveryProtos.DataEventDependencyInfoProto.newBuilder();
            builder.setTimestamp(info.timestamp);
            if (info.taId != null) {
                builder.setTaskAttemptId(info.taId.toString());
            }
            return builder.build();
        }

        public static DataEventDependencyInfo fromProto(RecoveryProtos.DataEventDependencyInfoProto proto) {
            TezTaskAttemptID taId = null;
            if (proto.hasTaskAttemptId()) {
                taId = TezTaskAttemptID.fromString((String)proto.getTaskAttemptId());
            }
            return new DataEventDependencyInfo(proto.getTimestamp(), taId);
        }
    }
}

