/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerHelpers;
import org.apache.tez.dag.app.rm.container.AMContainerImpl;
import org.apache.tez.dag.app.rm.container.AMContainerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMContainerMap
extends AbstractService
implements EventHandler<AMContainerEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(AMContainerMap.class);
    private final ContainerHeartbeatHandler chh;
    private final TaskCommunicatorManagerInterface tal;
    private final AppContext context;
    private final ContainerSignatureMatcher containerSignatureMatcher;
    @VisibleForTesting
    final ConcurrentHashMap<ContainerId, AMContainer> containerMap;

    public AMContainerMap(ContainerHeartbeatHandler chh, TaskCommunicatorManagerInterface tal, ContainerSignatureMatcher containerSignatureMatcher, AppContext context) {
        super("AMContainerMaps");
        this.chh = chh;
        this.tal = tal;
        this.context = context;
        this.containerSignatureMatcher = containerSignatureMatcher;
        this.containerMap = new ConcurrentHashMap();
    }

    public void handle(AMContainerEvent event) {
        AMContainer container = this.containerMap.get(event.getContainerId());
        if (container != null) {
            container.handle((Event)event);
        } else {
            LOG.info("Event for unknown container: " + event.getContainerId());
        }
    }

    public boolean addContainerIfNew(Container container, int schedulerId, int launcherId, int taskCommId) {
        AMContainer amc = this.createAmContainer(container, this.chh, this.tal, this.containerSignatureMatcher, this.context, schedulerId, launcherId, taskCommId);
        return this.containerMap.putIfAbsent(container.getId(), amc) == null;
    }

    AMContainer createAmContainer(Container container, ContainerHeartbeatHandler chh, TaskCommunicatorManagerInterface tal, ContainerSignatureMatcher signatureMatcher, AppContext appContext, int schedulerId, int launcherId, int taskCommId) {
        AMContainerImpl amc = new AMContainerImpl(container, chh, tal, signatureMatcher, appContext, schedulerId, launcherId, taskCommId);
        return amc;
    }

    public AMContainer get(ContainerId containerId) {
        return this.containerMap.get(containerId);
    }

    public Collection<AMContainer> values() {
        return this.containerMap.values();
    }

    public void dagComplete(DAG dag) {
        AMContainerHelpers.dagComplete(dag.getID());
        this.cleanupCompletedContainers();
    }

    private void cleanupCompletedContainers() {
        Iterator<Map.Entry<ContainerId, AMContainer>> iterator = this.containerMap.entrySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            Map.Entry<ContainerId, AMContainer> entry = iterator.next();
            AMContainer amContainer = entry.getValue();
            if (!AMContainerState.COMPLETED.equals((Object)amContainer.getState()) && !amContainer.isInErrorState()) continue;
            iterator.remove();
            ++count;
        }
        LOG.info("Cleaned up completed containers on dagComplete. Removed={}, Remaining={}", (Object)count, (Object)this.containerMap.size());
    }
}

