/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.impl;

import java.util.Map;
import java.util.TreeMap;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.AppLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerStoppedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexConfigurationDoneEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezVertexID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class HistoryEventJsonConversion {
    public static JSONObject convertToJson(HistoryEvent historyEvent) throws JSONException {
        if (!historyEvent.isHistoryEvent()) {
            throw new UnsupportedOperationException("Invalid Event, does not support history, eventType=" + (Object)((Object)historyEvent.getEventType()));
        }
        JSONObject jsonObject = null;
        switch (historyEvent.getEventType()) {
            case APP_LAUNCHED: {
                jsonObject = HistoryEventJsonConversion.convertAppLaunchedEvent((AppLaunchedEvent)historyEvent);
                break;
            }
            case AM_LAUNCHED: {
                jsonObject = HistoryEventJsonConversion.convertAMLaunchedEvent((AMLaunchedEvent)historyEvent);
                break;
            }
            case AM_STARTED: {
                jsonObject = HistoryEventJsonConversion.convertAMStartedEvent((AMStartedEvent)historyEvent);
                break;
            }
            case CONTAINER_LAUNCHED: {
                jsonObject = HistoryEventJsonConversion.convertContainerLaunchedEvent((ContainerLaunchedEvent)historyEvent);
                break;
            }
            case CONTAINER_STOPPED: {
                jsonObject = HistoryEventJsonConversion.convertContainerStoppedEvent((ContainerStoppedEvent)historyEvent);
                break;
            }
            case DAG_SUBMITTED: {
                jsonObject = HistoryEventJsonConversion.convertDAGSubmittedEvent((DAGSubmittedEvent)historyEvent);
                break;
            }
            case DAG_INITIALIZED: {
                jsonObject = HistoryEventJsonConversion.convertDAGInitializedEvent((DAGInitializedEvent)historyEvent);
                break;
            }
            case DAG_STARTED: {
                jsonObject = HistoryEventJsonConversion.convertDAGStartedEvent((DAGStartedEvent)historyEvent);
                break;
            }
            case DAG_FINISHED: {
                jsonObject = HistoryEventJsonConversion.convertDAGFinishedEvent((DAGFinishedEvent)historyEvent);
                break;
            }
            case VERTEX_INITIALIZED: {
                jsonObject = HistoryEventJsonConversion.convertVertexInitializedEvent((VertexInitializedEvent)historyEvent);
                break;
            }
            case VERTEX_STARTED: {
                jsonObject = HistoryEventJsonConversion.convertVertexStartedEvent((VertexStartedEvent)historyEvent);
                break;
            }
            case VERTEX_FINISHED: {
                jsonObject = HistoryEventJsonConversion.convertVertexFinishedEvent((VertexFinishedEvent)historyEvent);
                break;
            }
            case TASK_STARTED: {
                jsonObject = HistoryEventJsonConversion.convertTaskStartedEvent((TaskStartedEvent)historyEvent);
                break;
            }
            case TASK_FINISHED: {
                jsonObject = HistoryEventJsonConversion.convertTaskFinishedEvent((TaskFinishedEvent)historyEvent);
                break;
            }
            case TASK_ATTEMPT_STARTED: {
                jsonObject = HistoryEventJsonConversion.convertTaskAttemptStartedEvent((TaskAttemptStartedEvent)historyEvent);
                break;
            }
            case TASK_ATTEMPT_FINISHED: {
                jsonObject = HistoryEventJsonConversion.convertTaskAttemptFinishedEvent((TaskAttemptFinishedEvent)historyEvent);
                break;
            }
            case VERTEX_CONFIGURE_DONE: {
                jsonObject = HistoryEventJsonConversion.convertVertexReconfigureDoneEvent((VertexConfigurationDoneEvent)historyEvent);
                break;
            }
            case DAG_RECOVERED: {
                jsonObject = HistoryEventJsonConversion.convertDAGRecoveredEvent((DAGRecoveredEvent)historyEvent);
                break;
            }
            case VERTEX_COMMIT_STARTED: 
            case VERTEX_GROUP_COMMIT_STARTED: 
            case VERTEX_GROUP_COMMIT_FINISHED: 
            case DAG_COMMIT_STARTED: {
                throw new UnsupportedOperationException("Invalid Event, does not support history, eventType=" + (Object)((Object)historyEvent.getEventType()));
            }
            default: {
                throw new UnsupportedOperationException("Unhandled Event, eventType=" + (Object)((Object)historyEvent.getEventType()));
            }
        }
        return jsonObject;
    }

    private static JSONObject convertDAGRecoveredEvent(DAGRecoveredEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getDagID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray events = new JSONArray();
        JSONObject recoverEvent = new JSONObject();
        recoverEvent.put("ts", event.getRecoveredTime());
        recoverEvent.put("eventtype", (Object)HistoryEventType.DAG_RECOVERED.name());
        JSONObject recoverEventInfo = new JSONObject();
        recoverEventInfo.put("applicationAttemptId", (Object)event.getApplicationAttemptId().toString());
        if (event.getRecoveredDagState() != null) {
            recoverEventInfo.put("dagState", (Object)event.getRecoveredDagState().name());
        }
        if (event.getRecoveryFailureReason() != null) {
            recoverEventInfo.put("recoveryFailureReason", (Object)event.getRecoveryFailureReason());
        }
        recoverEvent.put("eventinfo", (Object)recoverEventInfo);
        events.put((Object)recoverEvent);
        jsonObject.put("events", (Object)events);
        return jsonObject;
    }

    private static JSONObject convertAppLaunchedEvent(AppLaunchedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + event.getApplicationId().toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION.name());
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("user", (Object)event.getUser());
        otherInfo.put("config", (Object)new JSONObject(DAGUtils.convertConfigurationToATSMap(event.getConf())));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertAMLaunchedEvent(AMLaunchedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + event.getApplicationAttemptId().toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appEntity = new JSONObject();
        appEntity.put("entity", (Object)event.getApplicationAttemptId().getApplicationId().toString());
        appEntity.put("entitytype", (Object)"applicationId");
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)event.getApplicationAttemptId().toString());
        appAttemptEntity.put("entitytype", (Object)"applicationAttemptId");
        relatedEntities.put((Object)appEntity);
        relatedEntities.put((Object)appAttemptEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject initEvent = new JSONObject();
        initEvent.put("ts", event.getLaunchTime());
        initEvent.put("eventtype", (Object)HistoryEventType.AM_LAUNCHED.name());
        events.put((Object)initEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("appSubmitTime", event.getAppSubmitTime());
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertAMStartedEvent(AMStartedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + event.getApplicationAttemptId().toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appEntity = new JSONObject();
        appEntity.put("entity", (Object)event.getApplicationAttemptId().getApplicationId().toString());
        appEntity.put("entitytype", (Object)"applicationId");
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)event.getApplicationAttemptId().toString());
        appAttemptEntity.put("entitytype", (Object)"applicationAttemptId");
        relatedEntities.put((Object)appEntity);
        relatedEntities.put((Object)appAttemptEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", event.getStartTime());
        startEvent.put("eventtype", (Object)HistoryEventType.AM_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        return jsonObject;
    }

    private static JSONObject convertContainerLaunchedEvent(ContainerLaunchedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + event.getContainerId().toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_CONTAINER_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)event.getApplicationAttemptId().toString());
        appAttemptEntity.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONObject containerEntity = new JSONObject();
        containerEntity.put("entity", (Object)event.getContainerId().toString());
        containerEntity.put("entitytype", (Object)"containerId");
        relatedEntities.put((Object)appAttemptEntity);
        relatedEntities.put((Object)containerEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject launchEvent = new JSONObject();
        launchEvent.put("ts", event.getLaunchTime());
        launchEvent.put("eventtype", (Object)HistoryEventType.CONTAINER_LAUNCHED.name());
        events.put((Object)launchEvent);
        jsonObject.put("events", (Object)events);
        return jsonObject;
    }

    private static JSONObject convertContainerStoppedEvent(ContainerStoppedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + event.getContainerId().toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_CONTAINER_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)event.getApplicationAttemptId().toString());
        appAttemptEntity.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONObject containerEntity = new JSONObject();
        containerEntity.put("entity", (Object)event.getContainerId().toString());
        containerEntity.put("entitytype", (Object)"containerId");
        relatedEntities.put((Object)appAttemptEntity);
        relatedEntities.put((Object)containerEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject stopEvent = new JSONObject();
        stopEvent.put("ts", event.getStoppedTime());
        stopEvent.put("eventtype", (Object)HistoryEventType.CONTAINER_STOPPED.name());
        events.put((Object)stopEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("exitStatus", event.getExitStatus());
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertDAGFinishedEvent(DAGFinishedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getDagID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", event.getFinishTime());
        finishEvent.put("eventtype", (Object)HistoryEventType.DAG_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startTime", event.getStartTime());
        otherInfo.put("endTime", event.getFinishTime());
        otherInfo.put("timeTaken", event.getFinishTime() - event.getStartTime());
        otherInfo.put("status", (Object)event.getState().name());
        otherInfo.put("diagnostics", (Object)event.getDiagnostics());
        otherInfo.put("counters", (Object)DAGUtils.convertCountersToJSON(event.getTezCounters()));
        otherInfo.put("completionApplicationAttemptId", (Object)event.getApplicationAttemptId().toString());
        Map<String, Integer> dagTaskStats = event.getDagTaskStats();
        if (dagTaskStats != null) {
            for (Map.Entry<String, Integer> entry : dagTaskStats.entrySet()) {
                otherInfo.put(entry.getKey(), entry.getValue().intValue());
            }
        }
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertDAGInitializedEvent(DAGInitializedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getDagID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray events = new JSONArray();
        JSONObject initEvent = new JSONObject();
        initEvent.put("ts", event.getInitTime());
        initEvent.put("eventtype", (Object)HistoryEventType.DAG_INITIALIZED.name());
        events.put((Object)initEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        if (event.getVertexNameIDMap() != null) {
            TreeMap<String, String> nameIdStrMap = new TreeMap<String, String>();
            for (Map.Entry<String, TezVertexID> entry : event.getVertexNameIDMap().entrySet()) {
                nameIdStrMap.put(entry.getKey(), entry.getValue().toString());
            }
            otherInfo.put("vertexNameIdMapping", nameIdStrMap);
        }
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertDAGStartedEvent(DAGStartedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getDagID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", event.getStartTime());
        startEvent.put("eventtype", (Object)HistoryEventType.DAG_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        return jsonObject;
    }

    private static JSONObject convertDAGSubmittedEvent(DAGSubmittedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getDagID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject tezAppEntity = new JSONObject();
        tezAppEntity.put("entity", (Object)("tez_" + event.getApplicationAttemptId().getApplicationId().toString()));
        tezAppEntity.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION.name());
        JSONObject tezAppAttemptEntity = new JSONObject();
        tezAppAttemptEntity.put("entity", (Object)("tez_" + event.getApplicationAttemptId().toString()));
        tezAppAttemptEntity.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONObject appEntity = new JSONObject();
        appEntity.put("entity", (Object)event.getApplicationAttemptId().getApplicationId().toString());
        appEntity.put("entitytype", (Object)"applicationId");
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)event.getApplicationAttemptId().toString());
        appAttemptEntity.put("entitytype", (Object)"applicationAttemptId");
        JSONObject userEntity = new JSONObject();
        userEntity.put("entity", (Object)event.getUser());
        userEntity.put("entitytype", (Object)"user");
        relatedEntities.put((Object)tezAppEntity);
        relatedEntities.put((Object)tezAppAttemptEntity);
        relatedEntities.put((Object)appEntity);
        relatedEntities.put((Object)appAttemptEntity);
        relatedEntities.put((Object)userEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONObject primaryFilters = new JSONObject();
        primaryFilters.put("dagName", (Object)event.getDAGName());
        if (event.getDAGPlan().hasCallerContext() && event.getDAGPlan().getCallerContext().hasCallerId() && event.getDAGPlan().getCallerContext().hasCallerType()) {
            primaryFilters.put("callerId", (Object)event.getDAGPlan().getCallerContext().getCallerId());
            primaryFilters.put("callerType", (Object)event.getDAGPlan().getCallerContext().getCallerType());
        }
        jsonObject.put("primaryfilters", (Object)primaryFilters);
        JSONArray events = new JSONArray();
        JSONObject submitEvent = new JSONObject();
        submitEvent.put("ts", event.getSubmitTime());
        submitEvent.put("eventtype", (Object)HistoryEventType.DAG_SUBMITTED.name());
        events.put((Object)submitEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("dagPlan", (Object)DAGUtils.generateSimpleJSONPlan(event.getDAGPlan()));
        if (event.getDAGPlan().hasCallerContext() && event.getDAGPlan().getCallerContext().hasCallerId() && event.getDAGPlan().getCallerContext().hasCallerType()) {
            otherInfo.put("callerId", (Object)event.getDAGPlan().getCallerContext().getCallerId());
            otherInfo.put("callerType", (Object)event.getDAGPlan().getCallerContext().getCallerType());
        }
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertTaskAttemptFinishedEvent(TaskAttemptFinishedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getTaskAttemptID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ATTEMPT_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", event.getFinishTime());
        finishEvent.put("eventtype", (Object)HistoryEventType.TASK_ATTEMPT_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("creationTime", event.getCreationTime());
        otherInfo.put("allocationTime", event.getAllocationTime());
        otherInfo.put("startTime", event.getStartTime());
        otherInfo.put("endTime", event.getFinishTime());
        otherInfo.put("timeTaken", event.getFinishTime() - event.getStartTime());
        if (event.getCreationCausalTA() != null) {
            otherInfo.put("creationCausalAttempt", (Object)event.getCreationCausalTA().toString());
        }
        otherInfo.put("status", (Object)event.getState().name());
        if (event.getTaskAttemptError() != null) {
            otherInfo.put("taskAttemptErrorEnum", (Object)event.getTaskAttemptError().name());
        }
        if (event.getTaskFailureType() != null) {
            otherInfo.put("taskFailureType", (Object)event.getTaskFailureType().name());
        }
        otherInfo.put("diagnostics", (Object)event.getDiagnostics());
        otherInfo.put("counters", (Object)DAGUtils.convertCountersToJSON(event.getCounters()));
        if (event.getDataEvents() != null && !event.getDataEvents().isEmpty()) {
            otherInfo.put("lastDataEvents", (Object)DAGUtils.convertDataEventDependencyInfoToJSON(event.getDataEvents()));
        }
        if (event.getNodeId() != null) {
            otherInfo.put("nodeId", (Object)event.getNodeId().toString());
        }
        if (event.getContainerId() != null) {
            otherInfo.put("containerId", (Object)event.getContainerId().toString());
        }
        if (event.getInProgressLogsUrl() != null) {
            otherInfo.put("inProgressLogsURL", (Object)event.getInProgressLogsUrl());
        }
        if (event.getCompletedLogsUrl() != null) {
            otherInfo.put("completedLogsURL", (Object)event.getCompletedLogsUrl());
        }
        if (event.getNodeHttpAddress() != null) {
            otherInfo.put("nodeHttpAddress", (Object)event.getNodeHttpAddress());
        }
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertTaskAttemptStartedEvent(TaskAttemptStartedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getTaskAttemptID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ATTEMPT_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject nodeEntity = new JSONObject();
        nodeEntity.put("entity", (Object)event.getNodeId().toString());
        nodeEntity.put("entitytype", (Object)"nodeId");
        JSONObject containerEntity = new JSONObject();
        containerEntity.put("entity", (Object)event.getContainerId().toString());
        containerEntity.put("entitytype", (Object)"containerId");
        JSONObject taskEntity = new JSONObject();
        taskEntity.put("entity", (Object)event.getTaskAttemptID().getTaskID().toString());
        taskEntity.put("entitytype", (Object)EntityTypes.TEZ_TASK_ID.name());
        relatedEntities.put((Object)nodeEntity);
        relatedEntities.put((Object)containerEntity);
        relatedEntities.put((Object)taskEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", event.getStartTime());
        startEvent.put("eventtype", (Object)HistoryEventType.TASK_ATTEMPT_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("inProgressLogsURL", (Object)event.getInProgressLogsUrl());
        otherInfo.put("completedLogsURL", (Object)event.getCompletedLogsUrl());
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertTaskFinishedEvent(TaskFinishedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getTaskID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", event.getFinishTime());
        finishEvent.put("eventtype", (Object)HistoryEventType.TASK_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startTime", event.getStartTime());
        otherInfo.put("endTime", event.getFinishTime());
        otherInfo.put("timeTaken", event.getFinishTime() - event.getStartTime());
        otherInfo.put("status", (Object)event.getState().name());
        otherInfo.put("diagnostics", (Object)event.getDiagnostics());
        otherInfo.put("counters", (Object)DAGUtils.convertCountersToJSON(event.getTezCounters()));
        if (event.getSuccessfulAttemptID() != null) {
            otherInfo.put("successfulAttemptId", (Object)event.getSuccessfulAttemptID().toString());
        }
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertTaskStartedEvent(TaskStartedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getTaskID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject vertexEntity = new JSONObject();
        vertexEntity.put("entity", (Object)event.getTaskID().getVertexID().toString());
        vertexEntity.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        relatedEntities.put((Object)vertexEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", event.getStartTime());
        startEvent.put("eventtype", (Object)HistoryEventType.TASK_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startTime", event.getStartTime());
        otherInfo.put("scheduledTime", event.getScheduledTime());
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertVertexFinishedEvent(VertexFinishedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getVertexID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", event.getFinishTime());
        finishEvent.put("eventtype", (Object)HistoryEventType.VERTEX_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("endTime", event.getFinishTime());
        otherInfo.put("timeTaken", event.getFinishTime() - event.getStartTime());
        otherInfo.put("status", (Object)event.getState().name());
        otherInfo.put("diagnostics", (Object)event.getDiagnostics());
        otherInfo.put("counters", (Object)DAGUtils.convertCountersToJSON(event.getTezCounters()));
        otherInfo.put("stats", (Object)DAGUtils.convertVertexStatsToJSON(event.getVertexStats()));
        Map<String, Integer> vertexTaskStats = event.getVertexTaskStats();
        if (vertexTaskStats != null) {
            for (Map.Entry<String, Integer> entry : vertexTaskStats.entrySet()) {
                otherInfo.put(entry.getKey(), entry.getValue().intValue());
            }
        }
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertVertexReconfigureDoneEvent(VertexConfigurationDoneEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getVertexID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray events = new JSONArray();
        JSONObject updateEvent = new JSONObject();
        updateEvent.put("ts", event.getReconfigureDoneTime());
        updateEvent.put("eventtype", (Object)HistoryEventType.VERTEX_CONFIGURE_DONE.name());
        JSONObject eventInfo = new JSONObject();
        eventInfo.put("numTasks", event.getNumTasks());
        if (event.getSourceEdgeProperties() != null && !event.getSourceEdgeProperties().isEmpty()) {
            JSONObject updatedEdgeManagers = new JSONObject();
            for (Map.Entry<String, EdgeProperty> entry : event.getSourceEdgeProperties().entrySet()) {
                updatedEdgeManagers.put(entry.getKey(), (Object)new JSONObject(DAGUtils.convertEdgeProperty(entry.getValue())));
            }
            eventInfo.put("updatedEdgeManagers", (Object)updatedEdgeManagers);
        }
        updateEvent.put("eventinfo", (Object)eventInfo);
        events.put((Object)updateEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertVertexInitializedEvent(VertexInitializedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getVertexID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject vertexEntity = new JSONObject();
        vertexEntity.put("entity", (Object)event.getVertexID().getDAGId().toString());
        vertexEntity.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        relatedEntities.put((Object)vertexEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject initEvent = new JSONObject();
        initEvent.put("ts", event.getInitedTime());
        initEvent.put("eventtype", (Object)HistoryEventType.VERTEX_INITIALIZED.name());
        events.put((Object)initEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("vertexName", (Object)event.getVertexName());
        otherInfo.put("initRequestedTime", event.getInitRequestedTime());
        otherInfo.put("initTime", event.getInitedTime());
        otherInfo.put("numTasks", event.getNumTasks());
        otherInfo.put("processorClassName", (Object)event.getProcessorName());
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertVertexStartedEvent(VertexStartedEvent event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getVertexID().toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject vertexEntity = new JSONObject();
        vertexEntity.put("entity", (Object)event.getVertexID().getDAGId().toString());
        vertexEntity.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        relatedEntities.put((Object)vertexEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", event.getStartTime());
        startEvent.put("eventtype", (Object)HistoryEventType.VERTEX_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startRequestedTime", event.getStartRequestedTime());
        otherInfo.put("startTime", event.getStartTime());
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }
}

