/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.client.TezAppMasterStatus;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.dag.api.DAGNotRunningException;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.records.TezDAGID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAGClientHandler {
    private Logger LOG = LoggerFactory.getLogger(DAGClientHandler.class);
    private DAGAppMaster dagAppMaster;

    public DAGClientHandler(DAGAppMaster dagAppMaster) {
        this.dagAppMaster = dagAppMaster;
    }

    private DAG getCurrentDAG() {
        return this.dagAppMaster.getContext().getCurrentDAG();
    }

    private Set<String> getAllDagIDs() {
        return this.dagAppMaster.getContext().getAllDAGIDs();
    }

    public List<String> getAllDAGs() throws TezException {
        return Collections.singletonList(this.getCurrentDAG().getID().toString());
    }

    public DAGStatus getDAGStatus(String dagIdStr, Set<StatusGetOpts> statusOptions) throws TezException {
        return this.getDAG(dagIdStr).getDAGStatus(statusOptions);
    }

    public DAGStatus getDAGStatus(String dagIdStr, Set<StatusGetOpts> statusOptions, long timeout) throws TezException {
        return this.getDAG(dagIdStr).getDAGStatus(statusOptions, timeout);
    }

    public VertexStatus getVertexStatus(String dagIdStr, String vertexName, Set<StatusGetOpts> statusOptions) throws TezException {
        VertexStatusBuilder status = this.getDAG(dagIdStr).getVertexStatus(vertexName, statusOptions);
        if (status == null) {
            throw new TezException("Unknown vertexName: " + vertexName);
        }
        return status;
    }

    DAG getDAG(String dagIdStr) throws TezException {
        TezDAGID dagId;
        try {
            dagId = TezDAGID.fromString((String)dagIdStr);
        }
        catch (IllegalArgumentException e) {
            throw new TezException("Bad dagId: " + dagIdStr, (Throwable)e);
        }
        DAG currentDAG = this.getCurrentDAG();
        if (currentDAG == null) {
            throw new TezException("No running dag at present");
        }
        String currentDAGIdStr = currentDAG.getID().toString();
        if (!currentDAGIdStr.equals(dagIdStr)) {
            if (this.getAllDagIDs().contains(dagIdStr)) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Looking for finished dagId " + dagIdStr + " current dag is " + currentDAGIdStr);
                }
                throw new DAGNotRunningException("DAG " + dagIdStr + " Not running, current dag is " + currentDAGIdStr);
            }
            this.LOG.warn("Current DAGID : " + currentDAGIdStr + ", Looking for string (not found): " + dagIdStr + ", dagIdObj: " + dagId);
            throw new TezException("Unknown dagId: " + dagIdStr);
        }
        return currentDAG;
    }

    public void tryKillDAG(String dagIdStr) throws TezException {
        DAG dag = this.getDAG(dagIdStr);
        this.LOG.info("Sending client kill to dag: " + dagIdStr);
        this.dagAppMaster.tryKillDAG(dag, "Kill Dag request received from client");
    }

    public synchronized String submitDAG(DAGProtos.DAGPlan dagPlan, Map<String, LocalResource> additionalAmResources) throws TezException {
        return this.dagAppMaster.submitDAGToAppMaster(dagPlan, additionalAmResources);
    }

    public synchronized void shutdownAM() throws TezException {
        this.LOG.info("Received message to shutdown AM");
        if (this.dagAppMaster != null) {
            this.dagAppMaster.shutdownTezAM("AM Shutdown request received from client");
        }
    }

    public synchronized TezAppMasterStatus getTezAppMasterStatus() throws TezException {
        switch (this.dagAppMaster.getState()) {
            case NEW: 
            case INITED: {
                return TezAppMasterStatus.INITIALIZING;
            }
            case IDLE: {
                return TezAppMasterStatus.READY;
            }
            case RECOVERING: 
            case RUNNING: {
                return TezAppMasterStatus.RUNNING;
            }
            case ERROR: 
            case FAILED: 
            case SUCCEEDED: 
            case KILLED: {
                return TezAppMasterStatus.SHUTDOWN;
            }
        }
        return TezAppMasterStatus.INITIALIZING;
    }

    public ACLManager getACLManager() {
        return this.dagAppMaster.getACLManager();
    }

    public ACLManager getACLManager(String dagIdStr) throws TezException {
        DAG dag = this.getDAG(dagIdStr);
        return dag.getACLManager();
    }
}

