/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.utils;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.client.TezClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSpecificLaunchCmdOption {
    private static final Logger LOG = LoggerFactory.getLogger(TaskSpecificLaunchCmdOption.class);
    static final Pattern INVALID_TASK_NAME_REGEX = Pattern.compile("[^(\\w\\s;:,\\[\\]\\-)]");
    static final Pattern TASKS_REGEX = Pattern.compile("([\\w\\s\\-]+)\\[([\\d:,\\s]*)\\];?");
    static final Pattern RANGE_REGEX = Pattern.compile("(\\d+):(\\d+)");
    private final Map<String, BitSet> tasksMap;
    private final String tsLaunchCmdOpts;
    private final String[] tsLogParams;

    public TaskSpecificLaunchCmdOption(Configuration conf) {
        this.tsLaunchCmdOpts = conf.getTrimmed("tez.task-specific.launch.cmd-opts");
        this.tsLogParams = TezClientUtils.parseLogParams((String)conf.getTrimmed("tez.task-specific.log.level"));
        this.tasksMap = this.shouldParseSpecificTaskList() ? this.getSpecificTasks(conf) : null;
    }

    public String getTaskSpecificOption(String launchCmdOpts, String vertexName, int taskIdx) {
        if (this.tsLaunchCmdOpts != null) {
            launchCmdOpts = launchCmdOpts == null ? "" : launchCmdOpts;
            vertexName = vertexName.replaceAll(" ", "");
            String result = this.tsLaunchCmdOpts.replaceAll("__VERTEX_NAME__", vertexName).replaceAll("__TASK_INDEX__", Integer.toString(taskIdx));
            result = launchCmdOpts + " " + result;
            LOG.info("Launch-cmd options added to vertexName=" + vertexName + ", taskIdx=" + taskIdx + ", tsLaunchCmdOpts=" + result.trim());
            return result.trim();
        }
        return launchCmdOpts;
    }

    public boolean hasModifiedTaskLaunchOpts() {
        return !Strings.isNullOrEmpty((String)this.tsLaunchCmdOpts);
    }

    public String[] getTaskSpecificLogParams() {
        return this.tsLogParams;
    }

    public boolean hasModifiedLogProperties() {
        return this.tsLogParams != null;
    }

    public boolean addTaskSpecificLaunchCmdOption(String vertexName, int taskId) {
        if (this.tasksMap == null || taskId < 0) {
            return false;
        }
        BitSet taskSet = this.tasksMap.get(vertexName);
        return taskSet == null ? false : (taskSet.isEmpty() ? true : taskSet.get(taskId));
    }

    private boolean shouldParseSpecificTaskList() {
        return !Strings.isNullOrEmpty((String)this.tsLaunchCmdOpts) || this.tsLogParams != null;
    }

    private Map<String, BitSet> getSpecificTasks(Configuration conf) {
        String specificTaskList = conf.getTrimmed("tez.task-specific.launch.cmd-opts.list");
        if (!Strings.isNullOrEmpty((String)specificTaskList) && this.isValid(specificTaskList)) {
            HashMap<String, BitSet> resultSet = new HashMap<String, BitSet>();
            Matcher matcher = TASKS_REGEX.matcher(specificTaskList);
            while (matcher.find()) {
                String vertexName = matcher.group(1).trim();
                BitSet taskSet = this.parseTasks(matcher.group(2).trim());
                resultSet.put(vertexName, taskSet);
            }
            LOG.info("Specific tasks with additional launch-cmd options=" + resultSet);
            return resultSet;
        }
        return null;
    }

    private boolean isValid(String specificTaskList) {
        if (INVALID_TASK_NAME_REGEX.matcher(specificTaskList).find()) {
            LOG.warn("Invalid option specified, tez.task-specific.launch.cmd-opts.list=" + specificTaskList);
            return false;
        }
        return true;
    }

    private BitSet parseTasks(String tasksInVertex) {
        BitSet taskSet = new BitSet();
        if (Strings.isNullOrEmpty((String)tasksInVertex)) {
            return taskSet;
        }
        Iterable tasks = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)tasksInVertex);
        for (String task : tasks) {
            if (task.endsWith(":") || task.startsWith(":")) {
                LOG.warn("Partial range is considered as an invalid option");
                return null;
            }
            Matcher taskMatcher = RANGE_REGEX.matcher(task);
            if (taskMatcher.find()) {
                int start = Integer.parseInt(taskMatcher.group(1).trim());
                int end = Integer.parseInt(taskMatcher.group(2).trim());
                for (int i = Math.min(start, end); i <= Math.max(start, end); ++i) {
                    taskSet.set(i);
                }
                continue;
            }
            taskSet.set(Integer.parseInt(task.trim()));
        }
        return taskSet;
    }
}

