/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezTaskUmbilicalProtocol;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.launcher.ContainerLauncher;
import org.apache.tez.dag.app.rm.NMCommunicatorEvent;
import org.apache.tez.dag.app.rm.NMCommunicatorEventType;
import org.apache.tez.dag.app.rm.NMCommunicatorLaunchRequestEvent;
import org.apache.tez.dag.app.rm.NMCommunicatorStopRequestEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventCompleted;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunched;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.task.TezChild;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalContainerLauncher
extends AbstractService
implements ContainerLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(LocalContainerLauncher.class);
    private final AppContext context;
    private final TaskAttemptListener taskAttemptListener;
    private final AtomicBoolean serviceStopped = new AtomicBoolean(false);
    private final String workingDirectory;
    private final Map<String, String> localEnv = new HashMap<String, String>();
    private final ExecutionContext executionContext;
    private int numExecutors;
    private final ConcurrentHashMap<ContainerId, RunningTaskCallback> runningContainers = new ConcurrentHashMap();
    private final ExecutorService callbackExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CallbackExecutor").build());
    private BlockingQueue<NMCommunicatorEvent> eventQueue = new LinkedBlockingQueue<NMCommunicatorEvent>();
    private Thread eventHandlingThread;
    private ListeningExecutorService taskExecutorService;

    public LocalContainerLauncher(AppContext context, TaskAttemptListener taskAttemptListener, String workingDirectory) throws UnknownHostException {
        super(LocalContainerLauncher.class.getName());
        this.context = context;
        this.taskAttemptListener = taskAttemptListener;
        this.workingDirectory = workingDirectory;
        AuxiliaryServiceHelper.setServiceDataIntoEnv((String)"mapreduce_shuffle", (ByteBuffer)ByteBuffer.allocate(4).putInt(0), this.localEnv);
        this.executionContext = new ExecutionContextImpl(InetAddress.getLocalHost().getHostName());
    }

    public synchronized void serviceInit(Configuration conf) {
        this.numExecutors = conf.getInt("tez.am.inline.task.execution.max-tasks", 1);
        Preconditions.checkState((this.numExecutors >= 1 ? 1 : 0) != 0, (Object)"Must have at least 1 executor");
        ExecutorService rawExecutor = Executors.newFixedThreadPool(this.numExecutors, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LocalTaskExecutionThread #%d").build());
        this.taskExecutorService = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
    }

    public void serviceStart() throws Exception {
        this.eventHandlingThread = new Thread((Runnable)new TezSubTaskRunner(), "LocalContainerLauncher-SubTaskRunner");
        this.eventHandlingThread.start();
    }

    public void serviceStop() throws Exception {
        if (!this.serviceStopped.compareAndSet(false, true)) {
            LOG.info("Service Already stopped. Ignoring additional stop");
            return;
        }
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
            this.eventHandlingThread.join(2000L);
        }
        if (this.taskExecutorService != null) {
            this.taskExecutorService.shutdownNow();
        }
        this.callbackExecutor.shutdownNow();
    }

    @Override
    public void dagComplete(DAG dag) {
    }

    @Override
    public void dagSubmitted() {
    }

    void sendContainerLaunchFailedMsg(ContainerId containerId, String message) {
        this.context.getEventHandler().handle((Event)new AMContainerEventLaunchFailed(containerId, message));
    }

    private void handleLaunchFailed(Throwable t, ContainerId containerId) {
        String message = t instanceof RejectedExecutionException ? "Failed to queue container launch for container Id: " + containerId : "Failed to launch container for container Id: " + containerId;
        LOG.error(message, t);
        this.sendContainerLaunchFailedMsg(containerId, message);
    }

    private void launch(NMCommunicatorLaunchRequestEvent event) {
        String tokenIdentifier = this.context.getApplicationID().toString();
        try {
            TezChild tezChild;
            try {
                tezChild = this.createTezChild(this.context.getAMConf(), event.getContainerId(), tokenIdentifier, this.context.getApplicationAttemptId().getAttemptId(), this.context.getLocalDirs(), (TezTaskUmbilicalProtocol)this.taskAttemptListener, TezCommonUtils.parseCredentialsBytes((byte[])event.getContainerLaunchContext().getTokens().array()));
            }
            catch (InterruptedException e) {
                this.handleLaunchFailed(e, event.getContainerId());
                return;
            }
            catch (TezException e) {
                this.handleLaunchFailed(e, event.getContainerId());
                return;
            }
            catch (IOException e) {
                this.handleLaunchFailed(e, event.getContainerId());
                return;
            }
            ListenableFuture runningTaskFuture = this.taskExecutorService.submit(this.createSubTask(tezChild, event.getContainerId()));
            RunningTaskCallback callback = new RunningTaskCallback(this.context, event.getContainerId());
            this.runningContainers.put(event.getContainerId(), callback);
            Futures.addCallback((ListenableFuture)runningTaskFuture, (FutureCallback)callback, (Executor)this.callbackExecutor);
        }
        catch (RejectedExecutionException e) {
            this.handleLaunchFailed(e, event.getContainerId());
        }
    }

    private void stop(NMCommunicatorStopRequestEvent event) {
        RunningTaskCallback callback = this.runningContainers.get(event.getContainerId());
        if (callback == null) {
            LOG.info("Ignoring stop request for containerId: " + event.getContainerId());
        } else {
            LOG.info("Ignoring stop request for containerId {}. Relying on regular task shutdown for it to end", (Object)event.getContainerId());
        }
        this.context.getEventHandler().handle((Event)new AMContainerEvent(event.getContainerId(), AMContainerEventType.C_NM_STOP_SENT));
    }

    private synchronized Callable<TezChild.ContainerExecutionResult> createSubTask(final TezChild tezChild, final ContainerId containerId) {
        return new Callable<TezChild.ContainerExecutionResult>(){

            @Override
            public TezChild.ContainerExecutionResult call() throws InterruptedException, TezException, IOException {
                Thread.interrupted();
                LocalContainerLauncher.this.context.getEventHandler().handle((Event)new AMContainerEventLaunched(containerId));
                ContainerLaunchedEvent lEvt = new ContainerLaunchedEvent(containerId, LocalContainerLauncher.this.context.getClock().getTime(), LocalContainerLauncher.this.context.getApplicationAttemptId());
                LocalContainerLauncher.this.context.getHistoryHandler().handle(new DAGHistoryEvent(LocalContainerLauncher.this.context.getCurrentDAGID(), lEvt));
                return tezChild.run();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TezChild createTezChild(Configuration defaultConf, ContainerId containerId, String tokenIdentifier, int attemptNumber, String[] localDirs, TezTaskUmbilicalProtocol tezTaskUmbilicalProtocol, Credentials credentials) throws InterruptedException, TezException, IOException {
        long memAvailable;
        HashMap<String, String> containerEnv = new HashMap<String, String>();
        containerEnv.putAll(this.localEnv);
        containerEnv.put(ApplicationConstants.Environment.USER.name(), this.context.getUser());
        LocalContainerLauncher localContainerLauncher = this;
        synchronized (localContainerLauncher) {
            memAvailable = Runtime.getRuntime().maxMemory() / (long)this.numExecutors;
        }
        TezChild tezChild = TezChild.newTezChild((Configuration)defaultConf, null, (int)0, (String)containerId.toString(), (String)tokenIdentifier, (int)attemptNumber, (String[])localDirs, (String)this.workingDirectory, containerEnv, (String)"", (ExecutionContext)this.executionContext, (Credentials)credentials, (long)memAvailable, (String)this.context.getUser());
        tezChild.setUmbilical(tezTaskUmbilicalProtocol);
        return tezChild;
    }

    public void handle(NMCommunicatorEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    private class RunningTaskCallback
    implements FutureCallback<TezChild.ContainerExecutionResult> {
        private final AppContext appContext;
        private final ContainerId containerId;

        RunningTaskCallback(AppContext appContext, ContainerId containerId) {
            this.appContext = appContext;
            this.containerId = containerId;
        }

        public void onSuccess(TezChild.ContainerExecutionResult result) {
            LocalContainerLauncher.this.runningContainers.remove(this.containerId);
            LOG.info("ContainerExecutionResult for: " + this.containerId + " = " + result);
            if (result.getExitStatus() == TezChild.ContainerExecutionResult.ExitStatus.SUCCESS || result.getExitStatus() == TezChild.ContainerExecutionResult.ExitStatus.ASKED_TO_DIE) {
                LOG.info("Container: " + this.containerId + " completed successfully");
                this.appContext.getEventHandler().handle((Event)new AMContainerEventCompleted(this.containerId, result.getExitStatus().getExitCode(), null, TaskAttemptTerminationCause.CONTAINER_EXITED));
            } else {
                LOG.info("Container: " + this.containerId + " completed but with errors");
                this.appContext.getEventHandler().handle((Event)new AMContainerEventCompleted(this.containerId, result.getExitStatus().getExitCode(), (String)(result.getErrorMessage() == null ? (result.getThrowable() == null ? null : result.getThrowable().getMessage()) : result.getErrorMessage()), TaskAttemptTerminationCause.APPLICATION_ERROR));
            }
        }

        public void onFailure(Throwable t) {
            LocalContainerLauncher.this.runningContainers.remove(this.containerId);
            if (!(t instanceof CancellationException)) {
                LOG.info("Container: " + this.containerId + ": Execution Failed: ", t);
                this.appContext.getEventHandler().handle((Event)new AMContainerEventCompleted(this.containerId, TezChild.ContainerExecutionResult.ExitStatus.EXECUTION_FAILURE.getExitCode(), t.getMessage(), TaskAttemptTerminationCause.APPLICATION_ERROR));
            } else {
                LOG.info("Ignoring CancellationException - triggered by LocalContainerLauncher");
                this.appContext.getEventHandler().handle((Event)new AMContainerEventCompleted(this.containerId, TezChild.ContainerExecutionResult.ExitStatus.SUCCESS.getExitCode(), "CancellationException", TaskAttemptTerminationCause.CONTAINER_EXITED));
            }
        }
    }

    private class TezSubTaskRunner
    implements Runnable {
        private TezSubTaskRunner() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted() && !LocalContainerLauncher.this.serviceStopped.get()) {
                try {
                    NMCommunicatorEvent event = (NMCommunicatorEvent)((Object)LocalContainerLauncher.this.eventQueue.take());
                    switch ((NMCommunicatorEventType)event.getType()) {
                        case CONTAINER_LAUNCH_REQUEST: {
                            LocalContainerLauncher.this.launch((NMCommunicatorLaunchRequestEvent)event);
                            break;
                        }
                        case CONTAINER_STOP_REQUEST: {
                            LocalContainerLauncher.this.stop((NMCommunicatorStopRequestEvent)event);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!LocalContainerLauncher.this.serviceStopped.get()) {
                        LOG.error("TezSubTaskRunner interrupted ", (Throwable)e);
                    }
                    return;
                }
                catch (Throwable e) {
                    LOG.error("TezSubTaskRunner failed due to exception", e);
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

