/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGStatusBuilder;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAGReport;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;

public interface DAG {
    public TezDAGID getID();

    public Map<String, LocalResource> getLocalResources();

    public String getName();

    public DAGState getState();

    public DAGReport getReport();

    public TezCounters getAllCounters();

    public TezCounters getCachedCounters();

    public EventHandler getEventHandler();

    public Vertex getVertex(String var1);

    public Map<TezVertexID, Vertex> getVertices();

    public Vertex getVertex(TezVertexID var1);

    public List<String> getDiagnostics();

    public int getTotalVertices();

    public int getSuccessfulVertices();

    public float getProgress();

    public float getCompletedTaskProgress();

    public boolean isUber();

    public String getUserName();

    public Configuration getConf();

    public DAGProtos.DAGPlan getJobPlan();

    public DAGStatusBuilder getDAGStatus(Set<StatusGetOpts> var1);

    public DAGStatusBuilder getDAGStatus(Set<StatusGetOpts> var1, long var2) throws TezException;

    public VertexStatusBuilder getVertexStatus(String var1, Set<StatusGetOpts> var2);

    public boolean isComplete();

    public Credentials getCredentials();

    public UserGroupInformation getDagUGI();

    public DAGState restoreFromEvent(HistoryEvent var1);

    public ACLManager getACLManager();

    public Map<String, TezVertexID> getVertexNameIDMapping();
}

