/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.speculation.legacy;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.SpeculatorEvent;
import org.apache.tez.dag.app.dag.event.SpeculatorEventTaskAttemptStatusUpdate;
import org.apache.tez.dag.app.dag.speculation.legacy.LegacyTaskRuntimeEstimator;
import org.apache.tez.dag.app.dag.speculation.legacy.TaskRuntimeEstimator;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;

public class LegacySpeculator {
    private static final long ON_SCHEDULE = Long.MIN_VALUE;
    private static final long ALREADY_SPECULATING = -9223372036854775807L;
    private static final long TOO_NEW = -9223372036854775806L;
    private static final long PROGRESS_IS_GOOD = -9223372036854775805L;
    private static final long NOT_RUNNING = -9223372036854775804L;
    private static final long TOO_LATE_TO_SPECULATE = -9223372036854775803L;
    private static final long SOONEST_RETRY_AFTER_NO_SPECULATE = 1000L;
    private static final long SOONEST_RETRY_AFTER_SPECULATE = 15000L;
    private static final double PROPORTION_RUNNING_TASKS_SPECULATABLE = 0.1;
    private static final double PROPORTION_TOTAL_TASKS_SPECULATABLE = 0.01;
    private static final int MINIMUM_ALLOWED_SPECULATIVE_TASKS = 10;
    private static final Log LOG = LogFactory.getLog(LegacySpeculator.class);
    private final ConcurrentMap<TezTaskID, Boolean> runningTasks = new ConcurrentHashMap<TezTaskID, Boolean>();
    private final ConcurrentMap<TezTaskAttemptID, TaskAttemptHistoryStatistics> runningTaskAttemptStatistics = new ConcurrentHashMap<TezTaskAttemptID, TaskAttemptHistoryStatistics>();
    private static final long MAX_WAITTING_TIME_FOR_HEARTBEAT = 9000L;
    private final Set<TezTaskID> mayHaveSpeculated = new HashSet<TezTaskID>();
    private Vertex vertex;
    private TaskRuntimeEstimator estimator;
    private final Clock clock;
    private long nextSpeculateTime = Long.MIN_VALUE;

    public LegacySpeculator(Configuration conf, AppContext context, Vertex vertex) {
        this(conf, context.getClock(), vertex);
    }

    public LegacySpeculator(Configuration conf, Clock clock, Vertex vertex) {
        this(conf, LegacySpeculator.getEstimator(conf, vertex), clock, vertex);
    }

    private static TaskRuntimeEstimator getEstimator(Configuration conf, Vertex vertex) {
        LegacyTaskRuntimeEstimator estimator = new LegacyTaskRuntimeEstimator();
        estimator.contextualize(conf, vertex);
        return estimator;
    }

    public LegacySpeculator(Configuration conf, TaskRuntimeEstimator estimator, Clock clock, Vertex vertex) {
        this.vertex = vertex;
        this.estimator = estimator;
        this.clock = clock;
    }

    void maybeSpeculate() {
        long now = this.clock.getTime();
        if (now < this.nextSpeculateTime) {
            return;
        }
        int speculations = this.maybeScheduleASpeculation();
        long mininumRecomp = speculations > 0 ? 15000L : 1000L;
        long wait = Math.max(mininumRecomp, this.clock.getTime() - now);
        this.nextSpeculateTime = now + wait;
        if (speculations > 0) {
            LOG.info((Object)("We launched " + speculations + " speculations.  Waiting " + wait + " milliseconds."));
        }
    }

    public void notifyAttemptStarted(TezTaskAttemptID taId, long timestamp) {
        this.estimator.enrollAttempt(taId, timestamp);
    }

    public void notifyAttemptStatusUpdate(TezTaskAttemptID taId, TaskAttemptState reportedState, long timestamp) {
        this.statusUpdate(taId, reportedState, timestamp);
        this.maybeSpeculate();
    }

    private void statusUpdate(TezTaskAttemptID attemptID, TaskAttemptState reportedState, long timestamp) {
        TezTaskID taskID = attemptID.getTaskID();
        Task task = this.vertex.getTask(taskID);
        Preconditions.checkState((task != null ? 1 : 0) != 0, (Object)("Null task for attempt: " + attemptID));
        this.estimator.updateAttempt(attemptID, reportedState, timestamp);
        if (reportedState == TaskAttemptState.RUNNING) {
            this.runningTasks.putIfAbsent(taskID, Boolean.TRUE);
        } else {
            this.runningTasks.remove(taskID, Boolean.TRUE);
            if (reportedState == TaskAttemptState.STARTING) {
                this.runningTaskAttemptStatistics.remove(attemptID);
            }
        }
    }

    public void handle(SpeculatorEvent event) {
        SpeculatorEventTaskAttemptStatusUpdate updateEvent = (SpeculatorEventTaskAttemptStatusUpdate)event;
        if (updateEvent.hasJustStarted()) {
            this.notifyAttemptStarted(updateEvent.getAttemptId(), updateEvent.getTimestamp());
        } else {
            this.notifyAttemptStatusUpdate(updateEvent.getAttemptId(), updateEvent.getTaskAttemptState(), updateEvent.getTimestamp());
        }
    }

    private long speculationValue(Task task, long now) {
        Map<TezTaskAttemptID, TaskAttempt> attempts = task.getAttempts();
        TezTaskID taskID = task.getTaskId();
        long acceptableRuntime = Long.MIN_VALUE;
        long result = Long.MIN_VALUE;
        if (task.getState() == TaskState.SUCCEEDED) {
            return -9223372036854775804L;
        }
        if (!this.mayHaveSpeculated.contains(taskID) && (acceptableRuntime = this.estimator.thresholdRuntime(taskID)) == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        TezTaskAttemptID runningTaskAttemptID = null;
        int numberRunningAttempts = 0;
        for (TaskAttempt taskAttempt : attempts.values()) {
            if (taskAttempt.getState() != TaskAttemptState.RUNNING && taskAttempt.getState() != TaskAttemptState.STARTING) continue;
            if (++numberRunningAttempts > 1) {
                return -9223372036854775807L;
            }
            runningTaskAttemptID = taskAttempt.getID();
            long estimatedRunTime = this.estimator.estimatedRuntime(runningTaskAttemptID);
            long taskAttemptStartTime = this.estimator.attemptEnrolledTime(runningTaskAttemptID);
            if (taskAttemptStartTime > now) {
                return -9223372036854775806L;
            }
            long estimatedEndTime = estimatedRunTime + taskAttemptStartTime;
            long estimatedReplacementEndTime = now + this.estimator.newAttemptEstimatedRuntime();
            float progress = taskAttempt.getProgress();
            TaskAttemptHistoryStatistics data = (TaskAttemptHistoryStatistics)this.runningTaskAttemptStatistics.get(runningTaskAttemptID);
            if (data == null) {
                this.runningTaskAttemptStatistics.put(runningTaskAttemptID, new TaskAttemptHistoryStatistics(estimatedRunTime, progress, now));
            } else if (estimatedRunTime == data.getEstimatedRunTime() && progress == data.getProgress()) {
                if (data.notHeartbeatedInAWhile(now)) {
                    this.statusUpdate(taskAttempt.getID(), taskAttempt.getState(), this.clock.getTime());
                }
            } else {
                data.setEstimatedRunTime(estimatedRunTime);
                data.setProgress(progress);
                data.resetHeartBeatTime(now);
            }
            if (estimatedEndTime < now) {
                return -9223372036854775805L;
            }
            if (estimatedReplacementEndTime >= estimatedEndTime) {
                return -9223372036854775803L;
            }
            result = estimatedEndTime - estimatedReplacementEndTime;
        }
        if (numberRunningAttempts == 0) {
            return -9223372036854775804L;
        }
        if (acceptableRuntime == Long.MIN_VALUE && (acceptableRuntime = this.estimator.thresholdRuntime(taskID)) == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return result;
    }

    protected void addSpeculativeAttempt(TezTaskID taskID) {
        LOG.info((Object)("DefaultSpeculator.addSpeculativeAttempt -- we are speculating " + taskID));
        this.vertex.scheduleSpeculativeTask(taskID);
        this.mayHaveSpeculated.add(taskID);
    }

    private int maybeScheduleASpeculation() {
        int successes = 0;
        long now = this.clock.getTime();
        int numberSpeculationsAlready = 0;
        int numberRunningTasks = 0;
        Map<TezTaskID, Task> tasks = this.vertex.getTasks();
        int numberAllowedSpeculativeTasks = (int)Math.max(10.0, 0.01 * (double)tasks.size());
        TezTaskID bestTaskID = null;
        long bestSpeculationValue = -1L;
        for (Map.Entry<TezTaskID, Task> taskEntry : tasks.entrySet()) {
            long mySpeculationValue = this.speculationValue(taskEntry.getValue(), now);
            if (mySpeculationValue == -9223372036854775807L) {
                ++numberSpeculationsAlready;
            }
            if (mySpeculationValue != -9223372036854775804L) {
                ++numberRunningTasks;
            }
            if (mySpeculationValue <= bestSpeculationValue) continue;
            bestTaskID = taskEntry.getKey();
            bestSpeculationValue = mySpeculationValue;
        }
        numberAllowedSpeculativeTasks = (int)Math.max((double)numberAllowedSpeculativeTasks, 0.1 * (double)numberRunningTasks);
        if (bestTaskID != null && numberAllowedSpeculativeTasks > numberSpeculationsAlready) {
            this.addSpeculativeAttempt(bestTaskID);
            ++successes;
        }
        return successes;
    }

    static class TaskAttemptHistoryStatistics {
        private long estimatedRunTime;
        private float progress;
        private long lastHeartBeatTime;

        public TaskAttemptHistoryStatistics(long estimatedRunTime, float progress, long nonProgressStartTime) {
            this.estimatedRunTime = estimatedRunTime;
            this.progress = progress;
            this.resetHeartBeatTime(nonProgressStartTime);
        }

        public long getEstimatedRunTime() {
            return this.estimatedRunTime;
        }

        public float getProgress() {
            return this.progress;
        }

        public void setEstimatedRunTime(long estimatedRunTime) {
            this.estimatedRunTime = estimatedRunTime;
        }

        public void setProgress(float progress) {
            this.progress = progress;
        }

        public boolean notHeartbeatedInAWhile(long now) {
            if (now - this.lastHeartBeatTime <= 9000L) {
                return false;
            }
            this.resetHeartBeatTime(now);
            return true;
        }

        public void resetHeartBeatTime(long lastHeartBeatTime) {
            this.lastHeartBeatTime = lastHeartBeatTime;
        }
    }
}

