/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.tez.dag.app.rm.NMCommunicatorEventType;

public class NMCommunicatorEvent
extends AbstractEvent<NMCommunicatorEventType> {
    private final ContainerId containerId;
    private final NodeId nodeId;
    private final Token containerToken;

    public NMCommunicatorEvent(ContainerId containerId, NodeId nodeId, Token containerToken, NMCommunicatorEventType type) {
        super((Enum)type);
        this.containerId = containerId;
        this.nodeId = nodeId;
        this.containerToken = containerToken;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Token getContainerToken() {
        return this.containerToken;
    }

    public String toSrting() {
        return super.toString() + " for container " + this.containerId + ", nodeId: " + this.nodeId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.containerId == null ? 0 : this.containerId.hashCode());
        result = 31 * result + (this.containerToken == null ? 0 : this.containerToken.hashCode());
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NMCommunicatorEvent other = (NMCommunicatorEvent)((Object)obj);
        if (this.containerId == null ? other.containerId != null : !this.containerId.equals((Object)other.containerId)) {
            return false;
        }
        if (this.containerToken == null ? other.containerToken != null : !this.containerToken.equals(other.containerToken)) {
            return false;
        }
        return !(this.nodeId == null ? other.nodeId != null : !this.nodeId.equals((Object)other.nodeId));
    }
}

