/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.logging.HistoryLoggingService;
import org.apache.tez.dag.history.recovery.RecoveryService;
import org.apache.tez.dag.records.TezDAGID;

public class HistoryEventHandler
extends CompositeService {
    private static Log LOG = LogFactory.getLog(HistoryEventHandler.class);
    private final AppContext context;
    private RecoveryService recoveryService;
    private boolean recoveryEnabled;
    private HistoryLoggingService historyLoggingService;

    public HistoryEventHandler(AppContext context) {
        super(HistoryEventHandler.class.getName());
        this.context = context;
    }

    public void serviceInit(Configuration conf) throws Exception {
        LOG.info((Object)"Initializing HistoryEventHandler");
        this.recoveryEnabled = this.context.getAMConf().getBoolean("tez.dag.recovery.enabled", true);
        String historyServiceClassName = this.context.getAMConf().get("tez.history.logging.service.class", "org.apache.tez.dag.history.logging.impl.SimpleHistoryLoggingService");
        this.historyLoggingService = (HistoryLoggingService)((Object)ReflectionUtils.createClazzInstance((String)historyServiceClassName));
        this.historyLoggingService.setAppContext(this.context);
        this.addService((Service)this.historyLoggingService);
        if (this.recoveryEnabled) {
            this.recoveryService = new RecoveryService(this.context);
            this.addService((Service)this.recoveryService);
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        LOG.info((Object)"Starting HistoryEventHandler");
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        LOG.info((Object)"Stopping HistoryEventHandler");
        super.serviceStop();
    }

    public void handleCriticalEvent(DAGHistoryEvent event) throws IOException {
        TezDAGID dagId = event.getDagID();
        String dagIdStr = "N/A";
        if (dagId != null) {
            dagIdStr = dagId.toString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling history event, eventType=" + (Object)((Object)event.getHistoryEvent().getEventType())));
        }
        if (this.recoveryEnabled && event.getHistoryEvent().isRecoveryEvent()) {
            this.recoveryService.handle(event);
        }
        if (event.getHistoryEvent().isHistoryEvent()) {
            this.historyLoggingService.handle(event);
        }
        LOG.info((Object)("[HISTORY][DAG:" + dagIdStr + "]" + "[Event:" + event.getHistoryEvent().getEventType().name() + "]" + ": " + event.getHistoryEvent().toString()));
    }

    public void handle(DAGHistoryEvent event) {
        try {
            this.handleCriticalEvent(event);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to handle recovery event, eventType=" + (Object)((Object)event.getHistoryEvent().getEventType())), (Throwable)e);
        }
    }

    public boolean hasRecoveryFailed() {
        if (this.recoveryEnabled) {
            return this.recoveryService.hasRecoveryFailed();
        }
        return false;
    }
}

