/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.dag.app.AppContext;

public abstract class HeartbeatHandlerBase<T>
extends AbstractService {
    protected int timeOut = 300000;
    protected int timeOutCheckInterval = 30000;
    protected Thread timeOutCheckerThread;
    private final String name;
    protected final EventHandler eventHandler;
    protected final Clock clock;
    protected final AppContext appContext;
    private ConcurrentMap<T, ReportTime> runningMap;
    private volatile boolean stopped;

    public HeartbeatHandlerBase(AppContext appContext, int expectedConcurrency, String name) {
        super(name);
        this.name = name;
        this.eventHandler = appContext.getEventHandler();
        this.clock = appContext.getClock();
        this.appContext = appContext;
        expectedConcurrency = expectedConcurrency == 0 ? 1 : expectedConcurrency;
        this.runningMap = new ConcurrentHashMap<T, ReportTime>(16, 0.75f, expectedConcurrency);
    }

    public void serviceInit(Configuration conf) {
        this.timeOut = this.getConfiguredTimeout(conf);
        this.timeOutCheckInterval = this.getConfiguredTimeoutCheckInterval(conf);
    }

    public void serviceStart() {
        this.timeOutCheckerThread = new Thread(this.createPingChecker());
        this.timeOutCheckerThread.setName(this.name + " PingChecker");
        this.timeOutCheckerThread.start();
    }

    public void serviceStop() {
        this.stopped = true;
        if (this.timeOutCheckerThread != null) {
            this.timeOutCheckerThread.interrupt();
        }
    }

    protected Runnable createPingChecker() {
        return new PingChecker();
    }

    protected abstract int getConfiguredTimeout(Configuration var1);

    protected abstract int getConfiguredTimeoutCheckInterval(Configuration var1);

    public void progressing(T id) {
        ReportTime time = (ReportTime)this.runningMap.get(id);
        if (time != null) {
            time.setLastProgress(this.clock.getTime());
        }
    }

    public void pinged(T id) {
        ReportTime time = (ReportTime)this.runningMap.get(id);
        if (time != null) {
            time.setLastPing(this.clock.getTime());
        }
    }

    public void register(T id) {
        this.runningMap.put(id, new ReportTime(this.clock.getTime()));
    }

    public void unregister(T id) {
        this.runningMap.remove(id);
    }

    protected abstract boolean hasTimedOut(ReportTime var1, long var2);

    protected abstract void handleTimeOut(T var1);

    private class PingChecker
    implements Runnable {
        private PingChecker() {
        }

        @Override
        public void run() {
            while (!HeartbeatHandlerBase.this.stopped && !Thread.currentThread().isInterrupted()) {
                Iterator iterator = HeartbeatHandlerBase.this.runningMap.entrySet().iterator();
                long currentTime = HeartbeatHandlerBase.this.clock.getTime();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!HeartbeatHandlerBase.this.hasTimedOut((ReportTime)entry.getValue(), currentTime)) continue;
                    iterator.remove();
                    HeartbeatHandlerBase.this.handleTimeOut(entry.getKey());
                }
                try {
                    Thread.sleep(HeartbeatHandlerBase.this.timeOutCheckInterval);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    protected static class ReportTime {
        private long lastPing;
        private long lastProgress;

        public ReportTime(long time) {
            this.setLastProgress(time);
        }

        public synchronized void setLastPing(long time) {
            this.lastPing = time;
        }

        public synchronized void setLastProgress(long time) {
            this.lastProgress = time;
            this.lastPing = time;
        }

        public synchronized long getLastPing() {
            return this.lastPing;
        }

        public synchronized long getLastProgress() {
            return this.lastProgress;
        }
    }
}

