/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class TaskAttemptStartedEvent
implements HistoryEvent {
    private TezTaskAttemptID taskAttemptId;
    private String inProgressLogsUrl;
    private String completedLogsUrl;
    private String vertexName;
    private long startTime;
    private ContainerId containerId;
    private NodeId nodeId;

    public TaskAttemptStartedEvent(TezTaskAttemptID taId, String vertexName, long startTime, ContainerId containerId, NodeId nodeId, String inProgressLogsUrl, String completedLogsUrl) {
        this.taskAttemptId = taId;
        this.vertexName = vertexName;
        this.startTime = startTime;
        this.containerId = containerId;
        this.nodeId = nodeId;
        this.inProgressLogsUrl = inProgressLogsUrl;
        this.completedLogsUrl = completedLogsUrl;
    }

    public TaskAttemptStartedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_ATTEMPT_STARTED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskAttemptStartedProto toProto() {
        return RecoveryProtos.TaskAttemptStartedProto.newBuilder().setTaskAttemptId(this.taskAttemptId.toString()).setStartTime(this.startTime).setContainerId(this.containerId.toString()).setNodeId(this.nodeId.toString()).build();
    }

    public void fromProto(RecoveryProtos.TaskAttemptStartedProto proto) {
        this.taskAttemptId = TezTaskAttemptID.fromString((String)proto.getTaskAttemptId());
        this.startTime = proto.getStartTime();
        this.containerId = ConverterUtils.toContainerId((String)proto.getContainerId());
        this.nodeId = ConverterUtils.toNodeId((String)proto.getNodeId());
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.TaskAttemptStartedProto proto = RecoveryProtos.TaskAttemptStartedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", taskAttemptId=" + this.taskAttemptId + ", startTime=" + this.startTime + ", containerId=" + this.containerId + ", nodeId=" + this.nodeId + ", inProgressLogs=" + this.inProgressLogsUrl + ", completedLogs=" + this.completedLogsUrl;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public String getInProgressLogsUrl() {
        return this.inProgressLogsUrl;
    }

    public String getCompletedLogsUrl() {
        return this.completedLogsUrl;
    }
}

