/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class DAGStartedEvent
implements HistoryEvent {
    private TezDAGID dagID;
    private long startTime;
    private String user;
    private String dagName;

    public DAGStartedEvent() {
    }

    public DAGStartedEvent(TezDAGID dagID, long startTime, String user, String dagName) {
        this.dagID = dagID;
        this.startTime = startTime;
        this.user = user;
        this.dagName = dagName;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_STARTED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.DAGStartedProto toProto() {
        return RecoveryProtos.DAGStartedProto.newBuilder().setDagId(this.dagID.toString()).setStartTime(this.startTime).build();
    }

    public void fromProto(RecoveryProtos.DAGStartedProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.startTime = proto.getStartTime();
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.DAGStartedProto proto = RecoveryProtos.DAGStartedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "dagID=" + this.dagID + ", startTime=" + this.startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TezDAGID getDagID() {
        return this.dagID;
    }

    public String getUser() {
        return this.user;
    }

    public String getDagName() {
        return this.dagName;
    }
}

