/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputUpdatePayloadEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;

public class RootInputVertexManager
extends VertexManagerPlugin {
    private String configuredInputName;

    public RootInputVertexManager(VertexManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
    }

    public void onVertexStarted(Map<String, List<Integer>> completions) {
        int numTasks = this.getContext().getVertexNumTasks(this.getContext().getVertexName());
        ArrayList scheduledTasks = Lists.newArrayListWithCapacity((int)numTasks);
        for (int i = 0; i < numTasks; ++i) {
            scheduledTasks.add(new VertexManagerPluginContext.TaskWithLocationHint(new Integer(i), null));
        }
        this.getContext().scheduleVertexTasks((List)scheduledTasks);
    }

    public void onSourceTaskCompleted(String srcVertexName, Integer attemptId) {
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
        LinkedList riEvents = Lists.newLinkedList();
        boolean dataInformationEventSeen = false;
        for (Event event : events) {
            if (event instanceof InputConfigureVertexTasksEvent) {
                Preconditions.checkState((!dataInformationEventSeen ? 1 : 0) != 0);
                Preconditions.checkState((this.getContext().getVertexNumTasks(this.getContext().getVertexName()) == -1 ? 1 : 0) != 0, (Object)("Parallelism for the vertex should be set to -1 if the InputInitializer is setting parallelism, VertexName: " + this.getContext().getVertexName()));
                Preconditions.checkState((this.configuredInputName == null ? 1 : 0) != 0, (Object)("RootInputVertexManager cannot configure multiple inputs. Use a custom VertexManager, VertexName: " + this.getContext().getVertexName() + ", ConfiguredInput: " + this.configuredInputName + ", CurrentInput: " + inputName));
                this.configuredInputName = inputName;
                InputConfigureVertexTasksEvent cEvent = (InputConfigureVertexTasksEvent)event;
                HashMap<String, InputSpecUpdate> rootInputSpecUpdate = new HashMap<String, InputSpecUpdate>();
                rootInputSpecUpdate.put(inputName, cEvent.getInputSpecUpdate() == null ? InputSpecUpdate.getDefaultSinglePhysicalInputSpecUpdate() : cEvent.getInputSpecUpdate());
                this.getContext().setVertexParallelism(cEvent.getNumTasks(), cEvent.getLocationHint(), null, rootInputSpecUpdate);
            }
            if (event instanceof InputUpdatePayloadEvent) {
                Preconditions.checkState((!dataInformationEventSeen ? 1 : 0) != 0);
                inputDescriptor.setUserPayload(UserPayload.create((ByteBuffer)((InputUpdatePayloadEvent)event).getUserPayload()));
                continue;
            }
            if (!(event instanceof InputDataInformationEvent)) continue;
            dataInformationEventSeen = true;
            Preconditions.checkState((this.getContext().getVertexNumTasks(this.getContext().getVertexName()) != 0 ? 1 : 0) != 0);
            Preconditions.checkState((this.configuredInputName == null || this.configuredInputName.equals(inputName) ? 1 : 0) != 0, (Object)("RootInputVertexManager cannot configure multiple inputs. Use a custom VertexManager, VertexName:" + this.getContext().getVertexName() + ", ConfiguredInput: " + this.configuredInputName + ", CurrentInput: " + inputName));
            this.configuredInputName = inputName;
            InputDataInformationEvent rEvent = (InputDataInformationEvent)event;
            rEvent.setTargetIndex(rEvent.getSourceIndex());
            riEvents.add(rEvent);
        }
        this.getContext().addRootInputEvents(inputName, (Collection)riEvents);
    }
}

