/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.avro.HistoryEventType;
import org.apache.tez.dag.records.TezDAGID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryEventHandler
extends AbstractService
implements EventHandler<DAGHistoryEvent> {
    private static Log LOG = LogFactory.getLog(HistoryEventHandler.class);
    private final AppContext context;

    public HistoryEventHandler(AppContext context) {
        super(HistoryEventHandler.class.getName());
        this.context = context;
    }

    public void serviceStart() {
        LOG.info((Object)"Starting HistoryEventHandler");
    }

    public void serviceStop() {
        LOG.info((Object)"Stopping HistoryEventHandler");
    }

    public void handle(DAGHistoryEvent event) {
        TezDAGID dagId = this.context.getCurrentDAGID();
        String dagIdStr = "N/A";
        if (dagId != null) {
            dagIdStr = this.context.getCurrentDAGID().toString();
        }
        LOG.info((Object)("[HISTORY][DAG:" + dagIdStr + "]" + "[Event:" + ((HistoryEventType)event.getType()).name() + "]" + ": " + event.getHistoryEvent().getBlob().toString()));
    }
}

