/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.speculate;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStatusUpdate;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.speculate.LegacyTaskRuntimeEstimator;
import org.apache.tez.dag.app.speculate.Speculator;
import org.apache.tez.dag.app.speculate.SpeculatorEvent;
import org.apache.tez.dag.app.speculate.TaskRuntimeEstimator;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.TezBuilderUtils;

public class DefaultSpeculator
extends AbstractService
implements Speculator {
    private static final long ON_SCHEDULE = Long.MIN_VALUE;
    private static final long ALREADY_SPECULATING = -9223372036854775807L;
    private static final long TOO_NEW = -9223372036854775806L;
    private static final long PROGRESS_IS_GOOD = -9223372036854775805L;
    private static final long NOT_RUNNING = -9223372036854775804L;
    private static final long TOO_LATE_TO_SPECULATE = -9223372036854775803L;
    private static final long SOONEST_RETRY_AFTER_NO_SPECULATE = 1000L;
    private static final long SOONEST_RETRY_AFTER_SPECULATE = 15000L;
    private static final double PROPORTION_RUNNING_TASKS_SPECULATABLE = 0.1;
    private static final double PROPORTION_TOTAL_TASKS_SPECULATABLE = 0.01;
    private static final int MINIMUM_ALLOWED_SPECULATIVE_TASKS = 10;
    private static final Log LOG = LogFactory.getLog(DefaultSpeculator.class);
    private final ConcurrentMap<TezTaskID, Boolean> runningTasks = new ConcurrentHashMap<TezTaskID, Boolean>();
    private final Map<Task, AtomicBoolean> pendingSpeculations = new ConcurrentHashMap<Task, AtomicBoolean>();
    private final ConcurrentMap<TezVertexID, AtomicInteger> vertexContainerNeeds = new ConcurrentHashMap<TezVertexID, AtomicInteger>();
    private final Set<TezTaskID> mayHaveSpeculated = new HashSet<TezTaskID>();
    private final Configuration conf;
    private AppContext context;
    private Thread speculationBackgroundThread = null;
    private BlockingQueue<SpeculatorEvent> eventQueue = new LinkedBlockingQueue<SpeculatorEvent>();
    private TaskRuntimeEstimator estimator;
    private BlockingQueue<Object> scanControl = new LinkedBlockingQueue<Object>();
    private final Clock clock;
    private final EventHandler<TaskEvent> eventHandler;

    public DefaultSpeculator(Configuration conf, AppContext context) {
        this(conf, context, context.getClock());
    }

    public DefaultSpeculator(Configuration conf, AppContext context, Clock clock) {
        this(conf, context, DefaultSpeculator.getEstimator(conf, context), clock);
    }

    private static TaskRuntimeEstimator getEstimator(Configuration conf, AppContext context) {
        TaskRuntimeEstimator estimator;
        try {
            Class estimatorClass = conf.getClass("yarn.app.mapreduce.am.job.task.estimator.class", LegacyTaskRuntimeEstimator.class, TaskRuntimeEstimator.class);
            Constructor estimatorConstructor = estimatorClass.getConstructor(new Class[0]);
            estimator = (TaskRuntimeEstimator)estimatorConstructor.newInstance(new Object[0]);
            estimator.contextualize(conf, context);
        }
        catch (InstantiationException ex) {
            LOG.error((Object)"Can't make a speculation runtime extimator", (Throwable)ex);
            throw new TezUncheckedException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            LOG.error((Object)"Can't make a speculation runtime extimator", (Throwable)ex);
            throw new TezUncheckedException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            LOG.error((Object)"Can't make a speculation runtime extimator", (Throwable)ex);
            throw new TezUncheckedException((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            LOG.error((Object)"Can't make a speculation runtime extimator", (Throwable)ex);
            throw new TezUncheckedException((Throwable)ex);
        }
        return estimator;
    }

    public DefaultSpeculator(Configuration conf, AppContext context, TaskRuntimeEstimator estimator, Clock clock) {
        super(DefaultSpeculator.class.getName());
        this.conf = conf;
        this.context = context;
        this.estimator = estimator;
        this.clock = clock;
        this.eventHandler = context.getEventHandler();
    }

    public void serviceStart() {
        Runnable speculationBackgroundCore = new Runnable(){

            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    long backgroundRunStartTime = DefaultSpeculator.this.clock.getTime();
                    try {
                        int speculations = DefaultSpeculator.this.computeSpeculations();
                        long mininumRecomp = speculations > 0 ? 15000L : 1000L;
                        long wait = Math.max(mininumRecomp, DefaultSpeculator.this.clock.getTime() - backgroundRunStartTime);
                        if (speculations > 0) {
                            LOG.info((Object)("We launched " + speculations + " speculations.  Sleeping " + wait + " milliseconds."));
                        }
                        Object pollResult = DefaultSpeculator.this.scanControl.poll(wait, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Background thread returning, interrupted : " + e));
                        e.printStackTrace(System.out);
                        return;
                    }
                }
            }
        };
        this.speculationBackgroundThread = new Thread(speculationBackgroundCore, "DefaultSpeculator background processing");
        this.speculationBackgroundThread.start();
    }

    public void serviceStop() {
        if (this.speculationBackgroundThread != null) {
            this.speculationBackgroundThread.interrupt();
        }
    }

    public void handleAttempt(TaskAttemptEventStatusUpdate.TaskAttemptStatusOld status) {
        long timestamp = this.clock.getTime();
        this.statusUpdate(status, timestamp);
    }

    public boolean eventQueueEmpty() {
        return this.eventQueue.isEmpty();
    }

    public void scanForSpeculations() {
        LOG.info((Object)"We got asked to run a debug speculation scan.");
        System.out.println("We got asked to run a debug speculation scan.");
        System.out.println("There are " + this.scanControl.size() + " events stacked already.");
        this.scanControl.add(new Object());
        Thread.yield();
    }

    private AtomicInteger containerNeed(TezTaskID taskID) {
        TezVertexID vId = taskID.getVertexID();
        AtomicInteger result = (AtomicInteger)this.vertexContainerNeeds.get(vId);
        if (result == null) {
            this.vertexContainerNeeds.putIfAbsent(vId, new AtomicInteger(0));
            result = (AtomicInteger)this.vertexContainerNeeds.get(vId);
        }
        return result;
    }

    private synchronized void processSpeculatorEvent(SpeculatorEvent event) {
        switch ((Speculator.EventType)event.getType()) {
            case ATTEMPT_STATUS_UPDATE: {
                this.statusUpdate(event.getReportedStatus(), event.getTimestamp());
                break;
            }
            case TASK_CONTAINER_NEED_UPDATE: {
                AtomicInteger need = this.containerNeed(event.getTaskID());
                need.addAndGet(event.containersNeededChange());
                break;
            }
            case ATTEMPT_START: {
                LOG.info((Object)("ATTEMPT_START " + event.getTaskID()));
                this.estimator.enrollAttempt(event.getReportedStatus(), event.getTimestamp());
                break;
            }
            case JOB_CREATE: {
                LOG.info((Object)("JOB_CREATE " + event.getJobID()));
                this.estimator.contextualize(this.getConfig(), this.context);
            }
        }
    }

    protected void statusUpdate(TaskAttemptEventStatusUpdate.TaskAttemptStatusOld reportedStatus, long timestamp) {
        String stateString = reportedStatus.taskState.toString();
        TezTaskAttemptID attemptID = reportedStatus.id;
        TezTaskID taskID = attemptID.getTaskID();
        DAG job = this.context.getCurrentDAG();
        if (job == null) {
            return;
        }
        Task task = job.getVertex(taskID.getVertexID()).getTask(taskID);
        if (task == null) {
            return;
        }
        this.estimator.updateAttempt(reportedStatus, timestamp);
        if (this.pendingSpeculations.get(task) != null && this.pendingSpeculations.get(task).get()) {
            return;
        }
        if (stateString.equals(TaskAttemptState.RUNNING.name())) {
            this.runningTasks.putIfAbsent(taskID, Boolean.TRUE);
        } else {
            this.runningTasks.remove(taskID, Boolean.TRUE);
        }
    }

    private long speculationValue(TezTaskID taskID, long now) {
        DAG job = this.context.getCurrentDAG();
        Task task = job.getVertex(taskID.getVertexID()).getTask(taskID);
        Map<TezTaskAttemptID, TaskAttempt> attempts = task.getAttempts();
        long acceptableRuntime = Long.MIN_VALUE;
        long result = Long.MIN_VALUE;
        if (!this.mayHaveSpeculated.contains(taskID) && (acceptableRuntime = this.estimator.thresholdRuntime(taskID)) == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        TezTaskAttemptID runningTaskAttemptID = null;
        int numberRunningAttempts = 0;
        for (TaskAttempt taskAttempt : attempts.values()) {
            if (taskAttempt.getState() != TaskAttemptState.RUNNING && taskAttempt.getState() != TaskAttemptState.STARTING) continue;
            if (++numberRunningAttempts > 1) {
                return -9223372036854775807L;
            }
            runningTaskAttemptID = taskAttempt.getID();
            long estimatedRunTime = this.estimator.estimatedRuntime(runningTaskAttemptID);
            long taskAttemptStartTime = this.estimator.attemptEnrolledTime(runningTaskAttemptID);
            if (taskAttemptStartTime > now) {
                return -9223372036854775806L;
            }
            long estimatedEndTime = estimatedRunTime + taskAttemptStartTime;
            long estimatedReplacementEndTime = now + this.estimator.estimatedNewAttemptRuntime(taskID);
            if (estimatedEndTime < now) {
                return -9223372036854775805L;
            }
            if (estimatedReplacementEndTime >= estimatedEndTime) {
                return -9223372036854775803L;
            }
            result = estimatedEndTime - estimatedReplacementEndTime;
        }
        if (numberRunningAttempts == 0) {
            return -9223372036854775804L;
        }
        if (acceptableRuntime == Long.MIN_VALUE && (acceptableRuntime = this.estimator.thresholdRuntime(taskID)) == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return result;
    }

    protected void addSpeculativeAttempt(TezTaskID taskID) {
        LOG.info((Object)("DefaultSpeculator.addSpeculativeAttempt -- we are speculating " + taskID));
        this.eventHandler.handle((Event)new TaskEvent(taskID, TaskEventType.T_ADD_SPEC_ATTEMPT));
        this.mayHaveSpeculated.add(taskID);
    }

    public void handle(SpeculatorEvent event) {
        this.processSpeculatorEvent(event);
    }

    private int maybeScheduleAMapSpeculation() {
        return this.maybeScheduleASpeculation(0);
    }

    private int maybeScheduleAReduceSpeculation() {
        return this.maybeScheduleASpeculation(1);
    }

    private int maybeScheduleASpeculation(int vertexId) {
        int successes = 0;
        long now = this.clock.getTime();
        for (Map.Entry vertexEntry : this.vertexContainerNeeds.entrySet()) {
            if (((AtomicInteger)vertexEntry.getValue()).get() > 0) continue;
            int numberSpeculationsAlready = 0;
            int numberRunningTasks = 0;
            DAG job = this.context.getCurrentDAG();
            Map<TezTaskID, Task> tasks = job.getVertex(TezBuilderUtils.newVertexID(job.getID(), vertexId)).getTasks();
            int numberAllowedSpeculativeTasks = (int)Math.max(10.0, 0.01 * (double)tasks.size());
            TezTaskID bestTaskID = null;
            long bestSpeculationValue = -1L;
            for (Map.Entry<TezTaskID, Task> taskEntry : tasks.entrySet()) {
                long mySpeculationValue = this.speculationValue(taskEntry.getKey(), now);
                if (mySpeculationValue == -9223372036854775807L) {
                    ++numberSpeculationsAlready;
                }
                if (mySpeculationValue != -9223372036854775804L) {
                    ++numberRunningTasks;
                }
                if (mySpeculationValue <= bestSpeculationValue) continue;
                bestTaskID = taskEntry.getKey();
                bestSpeculationValue = mySpeculationValue;
            }
            numberAllowedSpeculativeTasks = (int)Math.max((double)numberAllowedSpeculativeTasks, 0.1 * (double)numberRunningTasks);
            if (bestTaskID == null || numberAllowedSpeculativeTasks <= numberSpeculationsAlready) continue;
            this.addSpeculativeAttempt(bestTaskID);
            ++successes;
        }
        return successes;
    }

    private int computeSpeculations() {
        return this.maybeScheduleAMapSpeculation() + this.maybeScheduleAReduceSpeculation();
    }
}

