/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.VertexScheduler;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.event.TaskEventAddTezEvent;
import org.apache.tez.dag.app.dag.impl.RootInputLeafOutputDescriptor;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.runtime.api.events.RootInputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;
import org.apache.tez.runtime.api.events.RootInputUpdatePayloadEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootInputVertexManager
implements VertexScheduler {
    private final Vertex managedVertex;
    private final EventMetaData sourceInfo;
    private final Map<String, EventMetaData> destInfoMap;
    private final EventHandler eventHandler;

    public RootInputVertexManager(Vertex vertex, EventHandler eventHandler) {
        this.managedVertex = vertex;
        this.eventHandler = eventHandler;
        this.sourceInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, vertex.getName(), "NULL", null);
        Map<String, RootInputLeafOutputDescriptor<InputDescriptor>> inputs = this.managedVertex.getAdditionalInputs();
        this.destInfoMap = Maps.newHashMapWithExpectedSize((int)inputs.size());
        for (RootInputLeafOutputDescriptor<InputDescriptor> input : inputs.values()) {
            EventMetaData destInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, vertex.getName(), input.getEntityName(), null);
            this.destInfoMap.put(input.getEntityName(), destInfo);
        }
    }

    @Override
    public void initialize(Configuration conf) {
    }

    @Override
    public void onVertexStarted(List<TezTaskAttemptID> completions) {
        this.managedVertex.scheduleTasks(this.managedVertex.getTasks().keySet());
    }

    @Override
    public void onSourceTaskCompleted(TezTaskAttemptID attemptId) {
    }

    @Override
    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
    }

    @Override
    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<org.apache.tez.runtime.api.Event> events) {
        boolean dataInformationEventSeen = false;
        Preconditions.checkState((boolean)EnumSet.of(VertexState.INITIALIZING, VertexState.NEW).contains((Object)this.managedVertex.getState()));
        for (org.apache.tez.runtime.api.Event event : events) {
            if (event instanceof RootInputConfigureVertexTasksEvent) {
                Preconditions.checkState((!dataInformationEventSeen ? 1 : 0) != 0);
                Preconditions.checkState((this.managedVertex.getTotalTasks() == -1 ? 1 : 0) != 0, (Object)"Parallelism for the vertex should be set to -1 if the InputInitializer is setting parallelism");
                RootInputConfigureVertexTasksEvent cEvent = (RootInputConfigureVertexTasksEvent)event;
                this.managedVertex.setVertexLocationHint(new VertexLocationHint(cEvent.getNumTasks(), cEvent.getTaskLocationHints()));
                this.managedVertex.setParallelism(cEvent.getNumTasks(), null);
            }
            if (event instanceof RootInputUpdatePayloadEvent) {
                Preconditions.checkState((!dataInformationEventSeen ? 1 : 0) != 0);
                inputDescriptor.setUserPayload(((RootInputUpdatePayloadEvent)event).getUserPayload());
                continue;
            }
            if (!(event instanceof RootInputDataInformationEvent)) continue;
            dataInformationEventSeen = true;
            Preconditions.checkState((this.managedVertex.getTasks().size() != 0 ? 1 : 0) != 0);
            TezEvent tezEvent = new TezEvent(event, this.sourceInfo);
            tezEvent.setDestinationInfo(this.destInfoMap.get(inputName));
            this.sendEventToTask(new TezTaskID(this.managedVertex.getVertexId(), ((RootInputDataInformationEvent)event).getIndex()), tezEvent);
        }
    }

    private void sendEventToTask(TezTaskID taskId, TezEvent tezEvent) {
        this.eventHandler.handle((Event)new TaskEventAddTezEvent(taskId, tezEvent));
    }
}

