/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.io;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class NonSyncByteArrayOutputStream
extends ByteArrayOutputStream {
    public NonSyncByteArrayOutputStream(int size) {
        super(size);
    }

    public NonSyncByteArrayOutputStream() {
    }

    @Override
    public void write(int b) {
        this.enLargeBuffer(1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.enLargeBuffer(len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public void write(DataInput in, int length) throws IOException {
        this.enLargeBuffer(length);
        in.readFully(this.buf, this.count, length);
        this.count += length;
    }

    private int enLargeBuffer(int increment) {
        int temp;
        int newLen = temp = this.count + increment;
        if (temp > this.buf.length) {
            if (this.buf.length << 1 > temp) {
                newLen = this.buf.length << 1;
            }
            byte[] newbuf = new byte[newLen];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        return newLen;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    @Override
    public int size() {
        return this.count;
    }
}

