/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.util;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;

public class TezMxBeanResourceCalculator
extends ResourceCalculatorProcessTree {
    private final OperatingSystemMXBean osBean;
    private final Runtime runtime = Runtime.getRuntime();
    private static final Method getCommittedVirtualMemorySize = TezMxBeanResourceCalculator.getMxBeanMethod("getCommittedVirtualMemorySize");
    private static final Method getProcessCpuTime = TezMxBeanResourceCalculator.getMxBeanMethod("getProcessCpuTime");

    public TezMxBeanResourceCalculator(String root) {
        super(root);
        this.osBean = ManagementFactory.getOperatingSystemMXBean();
    }

    public void updateProcessTree() {
    }

    public String getProcessTreeDump() {
        return "";
    }

    public long getCumulativeVmem(int olderThanAge) {
        try {
            return (Long)getCommittedVirtualMemorySize.invoke((Object)this.osBean, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
        catch (IllegalAccessException e) {
            return -1L;
        }
        catch (InvocationTargetException e) {
            return -1L;
        }
    }

    public long getCumulativeRssmem(int olderThanAge) {
        return this.runtime.totalMemory();
    }

    public long getCumulativeCpuTime() {
        try {
            return TimeUnit.MILLISECONDS.convert((Long)getProcessCpuTime.invoke((Object)this.osBean, new Object[0]), TimeUnit.NANOSECONDS);
        }
        catch (InvocationTargetException e) {
            return -1L;
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
        catch (IllegalAccessException e) {
            return -1L;
        }
    }

    public boolean checkPidPgrpidForMatch() {
        return true;
    }

    public float getCpuUsagePercent() {
        return -1.0f;
    }

    private static Method getMxBeanMethod(String methodName) {
        String JAVA_VENDOR_NAME = System.getProperty("java.vendor");
        boolean IBM_JAVA = JAVA_VENDOR_NAME.contains("IBM");
        try {
            Class<?> mbeanClazz = IBM_JAVA ? Class.forName("com.ibm.lang.management.OperatingSystemMXBean") : Class.forName("com.sun.management.OperatingSystemMXBean");
            if (IBM_JAVA) {
                if (methodName.equals("getCommittedVirtualMemorySize")) {
                    methodName = "getProcessVirtualMemorySize";
                }
                if (methodName.equals("getProcessCpuTime")) {
                    methodName = "getProcessCpuTimeByNS";
                }
            }
            Method method = mbeanClazz.getMethod(methodName, new Class[0]);
            return method;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

