/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezID;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TezVertexID
extends TezID {
    public static final String VERTEX = "vertex";
    static final ThreadLocal<NumberFormat> tezVertexIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(2);
            return fmt;
        }
    };
    private static LoadingCache<TezVertexID, TezVertexID> vertexIDCache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<TezVertexID, TezVertexID>(){

        public TezVertexID load(TezVertexID key) throws Exception {
            return key;
        }
    });
    private TezDAGID dagId;

    public TezVertexID() {
    }

    public static TezVertexID getInstance(TezDAGID dagId, int id) {
        Preconditions.checkArgument((dagId != null ? 1 : 0) != 0, (Object)"DagID cannot be null");
        return (TezVertexID)vertexIDCache.getUnchecked((Object)new TezVertexID(dagId, id));
    }

    private TezVertexID(TezDAGID dagId, int id) {
        super(id);
        this.dagId = dagId;
    }

    public TezDAGID getDAGId() {
        return this.dagId;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezVertexID that = (TezVertexID)o;
        return this.dagId.equals(that.dagId);
    }

    @Override
    public int compareTo(TezID o) {
        TezVertexID that = (TezVertexID)o;
        return this.dagId.compareTo(that.dagId);
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(VERTEX)).toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.dagId = TezDAGID.readTezDAGID(in);
        super.readFields(in);
    }

    public static TezVertexID readTezVertexID(DataInput in) throws IOException {
        TezDAGID dagID = TezDAGID.readTezDAGID(in);
        int vertexIdInt = TezID.readID(in);
        return TezVertexID.getInstance(dagID, vertexIdInt);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.dagId.write(out);
        super.write(out);
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.dagId.appendTo(builder).append('_').append(tezVertexIdFormat.get().format(this.id));
    }

    @Override
    public int hashCode() {
        return this.dagId.hashCode() * 530017 + this.id;
    }

    public static TezVertexID fromString(String taskIdStr) {
        try {
            String[] split = taskIdStr.split("_");
            String rmId = split[1];
            int appId = TezDAGID.tezAppIdFormat.get().parse(split[2]).intValue();
            int dagId = TezDAGID.tezDagIdFormat.get().parse(split[3]).intValue();
            int id = tezVertexIdFormat.get().parse(split[4]).intValue();
            return TezVertexID.getInstance(TezDAGID.getInstance(rmId, appId, dagId), id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

