/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.Private
public class EnvironmentUpdateUtils {
    public static void put(String key, String value) {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.put(key, value);
        if (!Shell.WINDOWS) {
            EnvironmentUpdateUtils.updateEnvironment(environment);
        } else {
            EnvironmentUpdateUtils.updateEnvironmentOnWindows(environment);
        }
    }

    public static void putAll(Map<String, String> additionalEnvironment) {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.putAll(additionalEnvironment);
        if (!Shell.WINDOWS) {
            EnvironmentUpdateUtils.updateEnvironment(environment);
        } else {
            EnvironmentUpdateUtils.updateEnvironmentOnWindows(environment);
        }
    }

    private static void updateEnvironment(Map<String, String> environment) {
        Map<String, String> currentEnv = System.getenv();
        EnvironmentUpdateUtils.copyMapValuesToPrivateField(currentEnv.getClass(), currentEnv, "m", environment);
    }

    private static void updateEnvironmentOnWindows(Map<String, String> environment) {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            EnvironmentUpdateUtils.copyMapValuesToPrivateField(processEnvironmentClass, null, "theEnvironment", environment);
            EnvironmentUpdateUtils.copyMapValuesToPrivateField(processEnvironmentClass, null, "theCaseInsensitiveEnvironment", environment);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to update Environment variables", e);
        }
    }

    private static void copyMapValuesToPrivateField(Class<?> klass, Object object, String fieldName, Map<String, String> newMapValues) {
        try {
            Field field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
            Map currentMap = (Map)field.get(object);
            currentMap.clear();
            currentMap.putAll(newMapValues);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Failed to update Environment variables", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to update Environment variables", e);
        }
    }
}

