/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.records.TezID;
import org.apache.tez.dag.records.TezVertexID;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TezTaskID
extends TezID {
    public static final String TASK = "task";
    protected static final ThreadLocal<NumberFormat> idFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(6);
            return fmt;
        }
    };
    private TezVertexID vertexId;

    public TezTaskID() {
        this.vertexId = new TezVertexID();
    }

    public TezTaskID(TezVertexID vertexId, int id) {
        super(id);
        if (vertexId == null) {
            throw new IllegalArgumentException("vertexId cannot be null");
        }
        this.vertexId = vertexId;
    }

    public TezVertexID getVertexID() {
        return this.vertexId;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezTaskID that = (TezTaskID)o;
        return this.vertexId.equals(that.vertexId);
    }

    public int compareTo(TezID o) {
        TezTaskID that = (TezTaskID)o;
        int vertexComp = this.vertexId.compareTo(that.vertexId);
        if (vertexComp == 0) {
            return this.id - that.id;
        }
        return vertexComp;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(TASK)).toString();
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.vertexId.appendTo(builder).append('_').append(idFormat.get().format(this.id));
    }

    public int hashCode() {
        return this.vertexId.hashCode() * 535013 + this.id;
    }

    public void readFields(DataInput in) throws IOException {
        this.vertexId.readFields(in);
        super.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.vertexId.write(out);
        super.write(out);
    }
}

