/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.tez.common.AsyncDispatcherConcurrent;
import org.apache.tez.common.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AsyncDispatcher
extends CompositeService
implements Dispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncDispatcher.class);
    private final String name;
    private final BlockingQueue<Event> eventQueue;
    private volatile boolean stopped = false;
    private volatile boolean drainEventsOnStop = false;
    private volatile boolean drained = true;
    private Object waitForDrained = new Object();
    private volatile boolean blockNewEvents = false;
    private EventHandler handlerInstance = new GenericEventHandler();
    private Thread eventHandlingThread;
    protected final Map<Class<? extends Enum>, EventHandler> eventHandlers = Maps.newHashMap();
    protected final Map<Class<? extends Enum>, AsyncDispatcher> eventDispatchers = Maps.newHashMap();
    protected final Map<Class<? extends Enum>, AsyncDispatcherConcurrent> concurrentEventDispatchers = Maps.newHashMap();
    private boolean exitOnDispatchException = false;

    public AsyncDispatcher(String name) {
        this(name, new LinkedBlockingQueue<Event>());
    }

    public AsyncDispatcher(String name, BlockingQueue<Event> eventQueue) {
        super(name);
        this.name = name;
        this.eventQueue = eventQueue;
    }

    public Runnable createThread() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!AsyncDispatcher.this.stopped && !Thread.currentThread().isInterrupted()) {
                    Event event;
                    AsyncDispatcher.this.drained = AsyncDispatcher.this.eventQueue.isEmpty();
                    if (AsyncDispatcher.this.blockNewEvents) {
                        Object object = AsyncDispatcher.this.waitForDrained;
                        synchronized (object) {
                            if (AsyncDispatcher.this.drained) {
                                AsyncDispatcher.this.waitForDrained.notify();
                            }
                        }
                    }
                    try {
                        event = (Event)AsyncDispatcher.this.eventQueue.take();
                    }
                    catch (InterruptedException ie) {
                        if (!AsyncDispatcher.this.stopped) {
                            LOG.warn("AsyncDispatcher thread interrupted", (Throwable)ie);
                        }
                        return;
                    }
                    if (event == null) continue;
                    AsyncDispatcher.this.dispatch(event);
                }
            }
        };
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.eventHandlingThread = new Thread(this.createThread());
        this.eventHandlingThread.setName("Dispatcher thread {" + this.name + "}");
        this.eventHandlingThread.start();
        super.serviceStart();
    }

    public void setDrainEventsOnStop() {
        this.drainEventsOnStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceStop() throws Exception {
        if (this.drainEventsOnStop) {
            this.blockNewEvents = true;
            LOG.info("AsyncDispatcher is draining to stop, ignoring any new events.");
            Object object = this.waitForDrained;
            synchronized (object) {
                while (!this.drained && this.eventHandlingThread.isAlive()) {
                    this.waitForDrained.wait(1000L);
                    LOG.info("Waiting for AsyncDispatcher to drain.");
                }
            }
        }
        this.stopped = true;
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
            try {
                this.eventHandlingThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted Exception while stopping", (Throwable)ie);
            }
        }
        super.serviceStop();
    }

    protected void dispatch(Event event) {
        block4: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatching the event " + event.getClass().getName() + "." + event.toString());
            }
            Class type = event.getType().getDeclaringClass();
            try {
                EventHandler handler = this.eventHandlers.get(type);
                if (handler == null) {
                    throw new Exception("No handler for registered for " + type);
                }
                handler.handle(event);
            }
            catch (Throwable t) {
                LOG.error("Error in dispatcher thread", t);
                if (!this.exitOnDispatchException || ShutdownHookManager.get().isShutdownInProgress() || this.stopped) break block4;
                Thread shutDownThread = new Thread(this.createShutDownThread());
                shutDownThread.setName("AsyncDispatcher ShutDown handler");
                shutDownThread.start();
            }
        }
    }

    private void checkForExistingHandler(Class<? extends Enum> eventType) {
        EventHandler registeredHandler = this.eventHandlers.get(eventType);
        Preconditions.checkState(registeredHandler == null, "Cannot register same event on multiple dispatchers");
    }

    private void checkForExistingDispatcher(Class<? extends Enum> eventType) {
        AsyncDispatcher registeredDispatcher = this.eventDispatchers.get(eventType);
        Preconditions.checkState(registeredDispatcher == null, "Multiple dispatchers cannot be registered for: " + eventType.getName());
    }

    private void checkForExistingConcurrentDispatcher(Class<? extends Enum> eventType) {
        AsyncDispatcherConcurrent concurrentDispatcher = this.concurrentEventDispatchers.get(eventType);
        Preconditions.checkState(concurrentDispatcher == null, "Multiple concurrent dispatchers cannot be registered for: " + eventType.getName());
    }

    @VisibleForTesting
    protected void checkForExistingDispatchers(boolean checkHandler, Class<? extends Enum> eventType) {
        if (checkHandler) {
            this.checkForExistingHandler(eventType);
        }
        this.checkForExistingDispatcher(eventType);
        this.checkForExistingConcurrentDispatcher(eventType);
    }

    @VisibleForTesting
    public void enableExitOnDispatchException() {
        this.exitOnDispatchException = true;
    }

    public void register(Class<? extends Enum> eventType, EventHandler handler) {
        Preconditions.checkState(this.getServiceState() == Service.STATE.NOTINITED);
        EventHandler registeredHandler = this.eventHandlers.get(eventType);
        this.checkForExistingDispatchers(false, eventType);
        LOG.info("Registering " + eventType + " for " + handler.getClass());
        if (registeredHandler == null) {
            this.eventHandlers.put(eventType, handler);
        } else if (!(registeredHandler instanceof MultiListenerHandler)) {
            MultiListenerHandler multiHandler = new MultiListenerHandler();
            multiHandler.addHandler((EventHandler<Event>)registeredHandler);
            multiHandler.addHandler((EventHandler<Event>)handler);
            this.eventHandlers.put(eventType, multiHandler);
        } else {
            MultiListenerHandler multiHandler = (MultiListenerHandler)registeredHandler;
            multiHandler.addHandler((EventHandler<Event>)handler);
        }
    }

    public void registerAndCreateDispatcher(Class<? extends Enum> eventType, EventHandler handler, String dispatcherName) {
        Preconditions.checkState(this.getServiceState() == Service.STATE.NOTINITED);
        this.checkForExistingDispatchers(true, eventType);
        LOG.info("Registering " + eventType + " for independent dispatch using: " + handler.getClass());
        AsyncDispatcher dispatcher = new AsyncDispatcher(dispatcherName);
        dispatcher.register(eventType, handler);
        this.eventDispatchers.put(eventType, dispatcher);
        this.addIfService((Object)dispatcher);
    }

    public AsyncDispatcherConcurrent registerAndCreateDispatcher(Class<? extends Enum> eventType, EventHandler handler, String dispatcherName, int numThreads) {
        Preconditions.checkState(this.getServiceState() == Service.STATE.NOTINITED);
        this.checkForExistingDispatchers(true, eventType);
        LOG.info("Registering " + eventType + " for concurrent dispatch using: " + handler.getClass());
        AsyncDispatcherConcurrent dispatcher = new AsyncDispatcherConcurrent(dispatcherName, numThreads);
        if (this.exitOnDispatchException) {
            dispatcher.enableExitOnDispatchException();
        }
        dispatcher.register(eventType, handler);
        this.concurrentEventDispatchers.put(eventType, dispatcher);
        this.addIfService((Object)dispatcher);
        return dispatcher;
    }

    public void registerWithExistingDispatcher(Class<? extends Enum> eventType, EventHandler handler, AsyncDispatcherConcurrent dispatcher) {
        Preconditions.checkState(this.getServiceState() == Service.STATE.NOTINITED);
        this.checkForExistingDispatchers(true, eventType);
        LOG.info("Registering " + eventType + " with existing concurrent dispatch using: " + handler.getClass());
        if (this.exitOnDispatchException) {
            dispatcher.enableExitOnDispatchException();
        }
        dispatcher.register(eventType, handler);
        this.concurrentEventDispatchers.put(eventType, dispatcher);
    }

    public EventHandler getEventHandler() {
        return this.handlerInstance;
    }

    Runnable createShutDownThread() {
        return new Runnable(){

            @Override
            public void run() {
                LOG.info("Exiting, bbye..");
                System.exit(-1);
            }
        };
    }

    @InterfaceAudience.Private
    public int getQueueSize() {
        return this.eventQueue.size();
    }

    static class MultiListenerHandler
    implements EventHandler<Event> {
        List<EventHandler<Event>> listofHandlers = new ArrayList<EventHandler<Event>>();

        public void handle(Event event) {
            for (EventHandler<Event> handler : this.listofHandlers) {
                handler.handle(event);
            }
        }

        void addHandler(EventHandler<Event> handler) {
            this.listofHandlers.add(handler);
        }
    }

    class GenericEventHandler
    implements EventHandler<Event> {
        GenericEventHandler() {
        }

        public void handle(Event event) {
            int remCapacity;
            if (AsyncDispatcher.this.stopped) {
                return;
            }
            if (AsyncDispatcher.this.blockNewEvents) {
                return;
            }
            AsyncDispatcher.this.drained = false;
            Class type = event.getType().getDeclaringClass();
            AsyncDispatcher registeredDispatcher = AsyncDispatcher.this.eventDispatchers.get(type);
            if (registeredDispatcher != null) {
                registeredDispatcher.getEventHandler().handle(event);
                return;
            }
            AsyncDispatcherConcurrent concurrentDispatcher = AsyncDispatcher.this.concurrentEventDispatchers.get(type);
            if (concurrentDispatcher != null) {
                concurrentDispatcher.getEventHandler().handle(event);
                return;
            }
            int qSize = AsyncDispatcher.this.eventQueue.size();
            if (qSize != 0 && qSize % 1000 == 0) {
                LOG.info("Size of event-queue is " + qSize);
            }
            if ((remCapacity = AsyncDispatcher.this.eventQueue.remainingCapacity()) < 1000) {
                LOG.warn("Very low remaining capacity in the event-queue: " + remCapacity);
            }
            try {
                AsyncDispatcher.this.eventQueue.put(event);
            }
            catch (InterruptedException e) {
                if (!AsyncDispatcher.this.stopped) {
                    LOG.warn("AsyncDispatcher thread interrupted", (Throwable)e);
                }
                throw new YarnRuntimeException((Throwable)e);
            }
        }
    }
}

