/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.UserPayload;

public class NamedEntityDescriptor<T extends NamedEntityDescriptor<T>>
extends EntityDescriptor<NamedEntityDescriptor<T>> {
    private final String entityName;

    @InterfaceAudience.Private
    public NamedEntityDescriptor(String entityName, String className) {
        super(className);
        Preconditions.checkArgument((entityName != null ? 1 : 0) != 0, (Object)"EntityName must be specified");
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public T setUserPayload(UserPayload userPayload) {
        super.setUserPayload(userPayload);
        return (T)this;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("write is not expected to be used for a NamedEntityDescriptor");
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        throw new UnsupportedOperationException("readFields is not expected to be used for a NamedEntityDescriptor");
    }

    @Override
    public String toString() {
        boolean hasPayload = this.getUserPayload() == null ? false : this.getUserPayload().getPayload() != null;
        return "EntityName=" + this.entityName + ", ClassName=" + this.getClassName() + ", hasPayload=" + hasPayload;
    }
}

