/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;

@InterfaceAudience.Private
public class TezCommonUtils {
    public static final FsPermission TEZ_AM_DIR_PERMISSION = FsPermission.createImmutable((short)448);
    public static final FsPermission TEZ_AM_FILE_PERMISSION = FsPermission.createImmutable((short)420);
    private static final Log LOG = LogFactory.getLog(TezClient.class);
    public static final String TEZ_SYSTEM_SUB_DIR = ".tez";

    public static Path getTezBaseStagingPath(Configuration conf) {
        Path baseStagingDir;
        String stagingDirStr = conf.get("tez.staging-dir", TezConfiguration.TEZ_AM_STAGING_DIR_DEFAULT);
        try {
            Path p = new Path(stagingDirStr);
            FileSystem fs = p.getFileSystem(conf);
            if (!fs.exists(p)) {
                TezCommonUtils.mkDirForAM(fs, p);
                LOG.info((Object)("Stage directory " + p + " doesn't exist and is created"));
            }
            baseStagingDir = fs.resolvePath(p);
        }
        catch (IOException e) {
            throw new TezUncheckedException(e);
        }
        return baseStagingDir;
    }

    @InterfaceAudience.Private
    public static Path createTezSystemStagingPath(Configuration conf, String strAppId) {
        Path tezStagingDir;
        Path baseStagingPath = TezCommonUtils.getTezBaseStagingPath(conf);
        try {
            tezStagingDir = new Path(baseStagingPath, TEZ_SYSTEM_SUB_DIR);
            FileSystem fs = tezStagingDir.getFileSystem(conf);
            tezStagingDir = new Path(tezStagingDir, strAppId);
            if (!fs.exists(tezStagingDir)) {
                TezCommonUtils.mkDirForAM(fs, tezStagingDir);
                LOG.info((Object)("Tez system stage directory " + tezStagingDir + " doesn't exist and is created"));
            }
        }
        catch (IOException e) {
            throw new TezUncheckedException(e);
        }
        return tezStagingDir;
    }

    @InterfaceAudience.Private
    public static Path getTezSystemStagingPath(Configuration conf, String strAppId) {
        Path baseStagingPath = TezCommonUtils.getTezBaseStagingPath(conf);
        Path tezStagingDir = new Path(baseStagingPath, TEZ_SYSTEM_SUB_DIR);
        tezStagingDir = new Path(tezStagingDir, strAppId);
        return tezStagingDir;
    }

    @InterfaceAudience.Private
    public static Path getTezConfStagingPath(Path tezSysStagingPath) {
        return new Path(tezSysStagingPath, "tez-conf.pb");
    }

    @InterfaceAudience.Private
    public static Path getTezAMJarStagingPath(Path tezSysStagingPath) {
        return new Path(tezSysStagingPath, "tez.session.local-resources.pb");
    }

    @InterfaceAudience.Private
    public static Path getTezBinPlanStagingPath(Path tezSysStagingPath) {
        return new Path(tezSysStagingPath, "tez-dag.pb");
    }

    @InterfaceAudience.Private
    public static Path getTezTextPlanStagingPath(Path tezSysStagingPath, String strAppId, String dagPBName) {
        String fileName = strAppId + "-" + dagPBName + "-" + "tez-dag.pb.txt";
        return new Path(tezSysStagingPath, fileName);
    }

    @InterfaceAudience.Private
    public static Path getRecoveryPath(Path tezSysStagingPath, Configuration conf) throws IOException {
        Path baseReecoveryPath = new Path(tezSysStagingPath, "recovery");
        FileSystem recoveryFS = baseReecoveryPath.getFileSystem(conf);
        return recoveryFS.makeQualified(baseReecoveryPath);
    }

    @InterfaceAudience.Private
    public static Path getAttemptRecoveryPath(Path recoveryPath, int attemptID) {
        return new Path(recoveryPath, Integer.toString(attemptID));
    }

    @InterfaceAudience.Private
    public static Path getDAGRecoveryPath(Path attemptRecoverPath, String dagID) {
        return new Path(attemptRecoverPath, dagID + ".recovery");
    }

    @InterfaceAudience.Private
    public static Path getSummaryRecoveryPath(Path attemptRecoverPath) {
        return new Path(attemptRecoverPath, "summary");
    }

    public static void mkDirForAM(FileSystem fs, Path dir) throws IOException {
        fs.mkdirs(dir, new FsPermission(TEZ_AM_DIR_PERMISSION));
    }

    public static FSDataOutputStream createFileForAM(FileSystem fs, Path filePath) throws IOException {
        return FileSystem.create((FileSystem)fs, (Path)filePath, (FsPermission)new FsPermission(TEZ_AM_FILE_PERMISSION));
    }

    public static void addAdditionalLocalResources(Map<String, LocalResource> additionalLrs, Map<String, LocalResource> originalLRs, String logContext) {
        if (additionalLrs != null && !additionalLrs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, LocalResource> lrEntry : additionalLrs.entrySet()) {
                LocalResource originalLr = originalLRs.get(lrEntry.getKey());
                if (originalLr != null) {
                    LocalResource additionalLr = lrEntry.getValue();
                    if (originalLr.getSize() != additionalLr.getSize()) {
                        throw new TezUncheckedException("Duplicate Resources found with different size for [" + logContext + "]: " + lrEntry.getKey() + " : " + "[" + additionalLr.getResource() + "=" + additionalLr.getSize() + "],[" + originalLr.getResource() + "=" + originalLr.getSize());
                    }
                    if (originalLr.getResource().equals(additionalLr.getResource())) {
                        sb.append("[").append(lrEntry.getKey()).append(" : Duplicate]");
                    } else {
                        sb.append("[").append(lrEntry.getKey()).append(" : DuplicateDifferentPath]");
                    }
                }
                originalLRs.put(lrEntry.getKey(), lrEntry.getValue());
            }
            String logString = sb.toString();
            if (!logString.isEmpty()) {
                LOG.warn((Object)("Found Resources Duplication in " + logContext + " after including resources from " + "tez.lib.uris" + " and " + "tez.aux.uris" + ": " + logString));
            }
        }
    }

    @InterfaceAudience.Private
    public static ByteString compressByteArrayToByteString(byte[] inBytes) throws IOException {
        ByteString.Output os = ByteString.newOutput();
        DeflaterOutputStream compressOs = new DeflaterOutputStream((OutputStream)os, new Deflater(9));
        compressOs.write(inBytes);
        compressOs.finish();
        ByteString byteString = os.toByteString();
        return byteString;
    }

    @InterfaceAudience.Private
    public static byte[] decompressByteStringToByteArray(ByteString byteString) throws IOException {
        InflaterInputStream in = new InflaterInputStream(byteString.newInput());
        byte[] bytes = IOUtils.toByteArray((InputStream)in);
        return bytes;
    }

    public static String getCredentialsInfo(Credentials credentials, String identifier) {
        StringBuilder sb = new StringBuilder();
        sb.append("Credentials: #" + identifier + "Tokens=").append(credentials.numberOfTokens());
        if (credentials.numberOfTokens() > 0) {
            Token token;
            sb.append(", Services=");
            Iterator tokenItr = credentials.getAllTokens().iterator();
            if (tokenItr.hasNext()) {
                token = (Token)tokenItr.next();
                sb.append(token.getService()).append("(").append(token.getKind()).append(")");
            }
            while (tokenItr.hasNext()) {
                token = (Token)tokenItr.next();
                sb.append(",").append(token.getService()).append("(").append(token.getKind()).append(")");
            }
        }
        return sb.toString();
    }

    public static void logCredentials(Log log, Credentials credentials, String identifier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)TezCommonUtils.getCredentialsInfo(credentials, identifier));
        }
    }

    public static Collection<String> tokenizeString(String str, String delim) {
        ArrayList<String> values = new ArrayList<String>();
        if (str == null || str.isEmpty()) {
            return values;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        return values;
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || (str = str.trim()).isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return str.split("\\s*,\\s*");
    }
}

