/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

@InterfaceAudience.Private
public class TezYARNUtils {
    private static Pattern ENV_VARIABLE_PATTERN = Pattern.compile(Shell.getEnvironmentVariableRegex());

    public static String getFrameworkClasspath(Configuration conf, boolean usingArchive) {
        HashMap<String, String> environment = new HashMap<String, String>();
        TezYARNUtils.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), ApplicationConstants.Environment.PWD.$(), File.pathSeparator);
        TezYARNUtils.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), ApplicationConstants.Environment.PWD.$() + File.separator + "*", File.pathSeparator);
        if (usingArchive) {
            TezYARNUtils.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), ApplicationConstants.Environment.PWD.$() + File.separator + "tezlib" + File.separator + "*", File.pathSeparator);
            TezYARNUtils.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), ApplicationConstants.Environment.PWD.$() + File.separator + "tezlib" + File.separator + "lib" + File.separator + "*", File.pathSeparator);
        }
        if (conf.getBoolean("tez.use.cluster.hadoop-libs", false)) {
            for (String c : conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
                TezYARNUtils.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), c.trim(), File.pathSeparator);
            }
        } else {
            TezYARNUtils.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), ApplicationConstants.Environment.HADOOP_CONF_DIR.$(), File.pathSeparator);
        }
        return StringInterner.weakIntern((String)((String)environment.get(ApplicationConstants.Environment.CLASSPATH.name())));
    }

    public static void appendToEnvFromInputString(Map<String, String> env, String envString, String classPathSeparator) {
        if (envString != null && envString.length() > 0) {
            String[] childEnvs;
            for (String cEnv : childEnvs = envString.split(",")) {
                String[] parts = cEnv.split("=");
                Matcher m = ENV_VARIABLE_PATTERN.matcher(parts[1]);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    String var = m.group(1);
                    String replace = env.get(var);
                    if (replace == null) {
                        replace = System.getenv(var);
                    }
                    if (replace == null) continue;
                    m.appendReplacement(sb, Matcher.quoteReplacement(replace));
                }
                m.appendTail(sb);
                TezYARNUtils.addToEnvironment(env, parts[0], sb.toString(), classPathSeparator);
            }
        }
    }

    public static void setEnvIfAbsentFromInputString(Map<String, String> env, String envString) {
        if (envString != null && envString.length() > 0) {
            String[] childEnvs;
            for (String cEnv : childEnvs = envString.split(",")) {
                String[] parts = cEnv.split("=");
                Matcher m = ENV_VARIABLE_PATTERN.matcher(parts[1]);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    String var = m.group(1);
                    String replace = env.get(var);
                    if (replace == null) {
                        replace = System.getenv(var);
                    }
                    if (replace == null) continue;
                    m.appendReplacement(sb, Matcher.quoteReplacement(replace));
                }
                m.appendTail(sb);
                TezYARNUtils.putIfAbsent(env, parts[0], sb.toString());
            }
        }
    }

    public static void addToEnvironment(Map<String, String> environment, String variable, String value, String classPathSeparator) {
        String val = environment.get(variable);
        val = val == null ? value : val + classPathSeparator + value;
        environment.put(StringInterner.weakIntern((String)variable), StringInterner.weakIntern((String)val));
    }

    private static void putIfAbsent(Map<String, String> env, String key, String value) {
        if (!env.containsKey(key)) {
            env.put(StringInterner.weakIntern((String)key), StringInterner.weakIntern((String)value));
        }
    }

    public static void setupDefaultEnv(Map<String, String> env, Configuration conf, String confEnvKey, String confEnvKeyDefault, boolean usingArchive) {
        String classpath = TezYARNUtils.getFrameworkClasspath(conf, usingArchive);
        TezYARNUtils.addToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), classpath, File.pathSeparator);
        TezYARNUtils.setEnvIfAbsentFromInputString(env, conf.get(confEnvKey, confEnvKeyDefault));
        TezYARNUtils.addToEnvironment(env, ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), ApplicationConstants.Environment.PWD.$(), File.pathSeparator);
    }
}

