/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.protobuf.ByteString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.impl.pb.LocalResourcePBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.client.PreWarmContext;
import org.apache.tez.client.TezSessionStatus;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EdgeManagerDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TezEntityDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;

public class DagTypeConverters {
    public static DAGProtos.PlanLocalResourceVisibility convertToDAGPlan(LocalResourceVisibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return DAGProtos.PlanLocalResourceVisibility.PUBLIC;
            }
            case PRIVATE: {
                return DAGProtos.PlanLocalResourceVisibility.PRIVATE;
            }
            case APPLICATION: {
                return DAGProtos.PlanLocalResourceVisibility.APPLICATION;
            }
        }
        throw new RuntimeException("unknown 'visibility': " + visibility);
    }

    public static LocalResourceVisibility convertFromDAGPlan(DAGProtos.PlanLocalResourceVisibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return LocalResourceVisibility.PUBLIC;
            }
            case PRIVATE: {
                return LocalResourceVisibility.PRIVATE;
            }
            case APPLICATION: {
                return LocalResourceVisibility.APPLICATION;
            }
        }
        throw new RuntimeException("unknown 'visibility': " + (Object)((Object)visibility));
    }

    public static DAGProtos.PlanEdgeDataSourceType convertToDAGPlan(EdgeProperty.DataSourceType sourceType) {
        switch (sourceType) {
            case PERSISTED: {
                return DAGProtos.PlanEdgeDataSourceType.PERSISTED;
            }
            case PERSISTED_RELIABLE: {
                return DAGProtos.PlanEdgeDataSourceType.PERSISTED_RELIABLE;
            }
            case EPHEMERAL: {
                return DAGProtos.PlanEdgeDataSourceType.EPHEMERAL;
            }
        }
        throw new RuntimeException("unknown 'dataSourceType': " + (Object)((Object)sourceType));
    }

    public static EdgeProperty.DataSourceType convertFromDAGPlan(DAGProtos.PlanEdgeDataSourceType sourceType) {
        switch (sourceType) {
            case PERSISTED: {
                return EdgeProperty.DataSourceType.PERSISTED;
            }
            case PERSISTED_RELIABLE: {
                return EdgeProperty.DataSourceType.PERSISTED_RELIABLE;
            }
            case EPHEMERAL: {
                return EdgeProperty.DataSourceType.EPHEMERAL;
            }
        }
        throw new RuntimeException("unknown 'dataSourceType': " + (Object)((Object)sourceType));
    }

    public static DAGProtos.PlanEdgeDataMovementType convertToDAGPlan(EdgeProperty.DataMovementType type) {
        switch (type) {
            case ONE_TO_ONE: {
                return DAGProtos.PlanEdgeDataMovementType.ONE_TO_ONE;
            }
            case BROADCAST: {
                return DAGProtos.PlanEdgeDataMovementType.BROADCAST;
            }
            case SCATTER_GATHER: {
                return DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER;
            }
            case CUSTOM: {
                return DAGProtos.PlanEdgeDataMovementType.CUSTOM;
            }
        }
        throw new RuntimeException("unknown 'dataMovementType': " + (Object)((Object)type));
    }

    public static EdgeProperty.DataMovementType convertFromDAGPlan(DAGProtos.PlanEdgeDataMovementType type) {
        switch (type) {
            case ONE_TO_ONE: {
                return EdgeProperty.DataMovementType.ONE_TO_ONE;
            }
            case BROADCAST: {
                return EdgeProperty.DataMovementType.BROADCAST;
            }
            case SCATTER_GATHER: {
                return EdgeProperty.DataMovementType.SCATTER_GATHER;
            }
        }
        throw new IllegalArgumentException("unknown 'dataMovementType': " + (Object)((Object)type));
    }

    public static DAGProtos.PlanEdgeSchedulingType convertToDAGPlan(EdgeProperty.SchedulingType type) {
        switch (type) {
            case SEQUENTIAL: {
                return DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL;
            }
            case CONCURRENT: {
                return DAGProtos.PlanEdgeSchedulingType.CONCURRENT;
            }
        }
        throw new RuntimeException("unknown 'SchedulingType': " + (Object)((Object)type));
    }

    public static EdgeProperty.SchedulingType convertFromDAGPlan(DAGProtos.PlanEdgeSchedulingType type) {
        switch (type) {
            case SEQUENTIAL: {
                return EdgeProperty.SchedulingType.SEQUENTIAL;
            }
            case CONCURRENT: {
                return EdgeProperty.SchedulingType.CONCURRENT;
            }
        }
        throw new IllegalArgumentException("unknown 'SchedulingType': " + (Object)((Object)type));
    }

    public static DAGProtos.PlanLocalResourceType convertToDAGPlan(LocalResourceType type) {
        switch (type) {
            case ARCHIVE: {
                return DAGProtos.PlanLocalResourceType.ARCHIVE;
            }
            case FILE: {
                return DAGProtos.PlanLocalResourceType.FILE;
            }
            case PATTERN: {
                return DAGProtos.PlanLocalResourceType.PATTERN;
            }
        }
        throw new IllegalArgumentException("unknown 'type': " + type);
    }

    public static LocalResourceType convertFromDAGPlan(DAGProtos.PlanLocalResourceType type) {
        switch (type) {
            case ARCHIVE: {
                return LocalResourceType.ARCHIVE;
            }
            case FILE: {
                return LocalResourceType.FILE;
            }
            case PATTERN: {
                return LocalResourceType.PATTERN;
            }
        }
        throw new IllegalArgumentException("unknown 'type': " + (Object)((Object)type));
    }

    public static VertexLocationHint convertFromDAGPlan(List<DAGProtos.PlanTaskLocationHint> locationHints) {
        ArrayList<VertexLocationHint.TaskLocationHint> outputList = new ArrayList<VertexLocationHint.TaskLocationHint>();
        for (DAGProtos.PlanTaskLocationHint inputHint : locationHints) {
            VertexLocationHint.TaskLocationHint outputHint = new VertexLocationHint.TaskLocationHint(new HashSet<String>(inputHint.getHostList()), new HashSet<String>(inputHint.getRackList()));
            outputList.add(outputHint);
        }
        return new VertexLocationHint(outputList);
    }

    public static String convertToDAGPlan(URL resource) {
        return resource.getScheme() + "://" + resource.getHost() + ":" + resource.getPort() + resource.getFile();
    }

    public static Map<String, LocalResource> createLocalResourceMapFromDAGPlan(List<DAGProtos.PlanLocalResource> localResourcesList) {
        HashMap<String, LocalResource> map = new HashMap<String, LocalResource>();
        for (DAGProtos.PlanLocalResource res : localResourcesList) {
            LocalResourcePBImpl r = new LocalResourcePBImpl();
            if (res.hasPattern()) {
                r.setPattern(res.getPattern());
            }
            r.setResource(ConverterUtils.getYarnUrlFromPath((Path)new Path(res.getUri())));
            r.setSize(res.getSize());
            r.setTimestamp(res.getTimeStamp());
            r.setType(DagTypeConverters.convertFromDAGPlan(res.getType()));
            r.setVisibility(DagTypeConverters.convertFromDAGPlan(res.getVisibility()));
            map.put(res.getName(), (LocalResource)r);
        }
        return map;
    }

    public static Map<String, String> createEnvironmentMapFromDAGPlan(List<DAGProtos.PlanKeyValuePair> environmentSettingList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (DAGProtos.PlanKeyValuePair setting : environmentSettingList) {
            map.put(setting.getKey(), setting.getValue());
        }
        return map;
    }

    public static Map<String, DAGProtos.EdgePlan> createEdgePlanMapFromDAGPlan(List<DAGProtos.EdgePlan> edgeList) {
        HashMap<String, DAGProtos.EdgePlan> edgePlanMap = new HashMap<String, DAGProtos.EdgePlan>();
        for (DAGProtos.EdgePlan edgePlanItem : edgeList) {
            edgePlanMap.put(edgePlanItem.getId(), edgePlanItem);
        }
        return edgePlanMap;
    }

    public static EdgeProperty createEdgePropertyMapFromDAGPlan(DAGProtos.EdgePlan edge) {
        if (edge.getDataMovementType() == DAGProtos.PlanEdgeDataMovementType.CUSTOM) {
            return new EdgeProperty(edge.hasEdgeManager() ? DagTypeConverters.convertEdgeManagerDescriptorFromDAGPlan(edge.getEdgeManager()) : null, DagTypeConverters.convertFromDAGPlan(edge.getDataSourceType()), DagTypeConverters.convertFromDAGPlan(edge.getSchedulingType()), DagTypeConverters.convertOutputDescriptorFromDAGPlan(edge.getEdgeSource()), DagTypeConverters.convertInputDescriptorFromDAGPlan(edge.getEdgeDestination()));
        }
        return new EdgeProperty(DagTypeConverters.convertFromDAGPlan(edge.getDataMovementType()), DagTypeConverters.convertFromDAGPlan(edge.getDataSourceType()), DagTypeConverters.convertFromDAGPlan(edge.getSchedulingType()), DagTypeConverters.convertOutputDescriptorFromDAGPlan(edge.getEdgeSource()), DagTypeConverters.convertInputDescriptorFromDAGPlan(edge.getEdgeDestination()));
    }

    public static Resource createResourceRequestFromTaskConfig(DAGProtos.PlanTaskConfiguration taskConfig) {
        return Resource.newInstance((int)taskConfig.getMemoryMb(), (int)taskConfig.getVirtualCores());
    }

    public static Map<String, String> convertConfFromProto(DAGProtos.ConfigurationProto confProto) {
        List<DAGProtos.PlanKeyValuePair> settingList = confProto.getConfKeyValuesList();
        HashMap<String, String> map = new HashMap<String, String>();
        for (DAGProtos.PlanKeyValuePair setting : settingList) {
            map.put(setting.getKey(), setting.getValue());
        }
        return map;
    }

    public static DAGProtos.TezEntityDescriptorProto convertToDAGPlan(TezEntityDescriptor descriptor) {
        DAGProtos.TezEntityDescriptorProto.Builder builder = DAGProtos.TezEntityDescriptorProto.newBuilder();
        builder.setClassName(descriptor.getClassName());
        if (descriptor.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((byte[])descriptor.getUserPayload()));
        }
        return builder.build();
    }

    public static DAGProtos.RootInputLeafOutputProto convertToDAGPlan(RootInputLeafOutput<? extends TezEntityDescriptor> descriptor) {
        DAGProtos.RootInputLeafOutputProto.Builder builder = DAGProtos.RootInputLeafOutputProto.newBuilder();
        builder.setName(descriptor.getName());
        builder.setEntityDescriptor(DagTypeConverters.convertToDAGPlan(descriptor.getDescriptor()));
        if (descriptor.getInitializerClass() != null) {
            builder.setInitializerClassName(descriptor.getInitializerClass().getName());
        }
        return builder.build();
    }

    public static InputDescriptor convertInputDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        byte[] bb = null;
        if (proto.hasUserPayload()) {
            bb = proto.getUserPayload().toByteArray();
        }
        return new InputDescriptor(className).setUserPayload(bb);
    }

    public static OutputDescriptor convertOutputDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        byte[] bb = null;
        if (proto.hasUserPayload()) {
            bb = proto.getUserPayload().toByteArray();
        }
        return new OutputDescriptor(className).setUserPayload(bb);
    }

    public static VertexManagerPluginDescriptor convertVertexManagerPluginDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        byte[] bb = null;
        if (proto.hasUserPayload()) {
            bb = proto.getUserPayload().toByteArray();
        }
        return new VertexManagerPluginDescriptor(className).setUserPayload(bb);
    }

    public static EdgeManagerDescriptor convertEdgeManagerDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        byte[] bb = null;
        if (proto.hasUserPayload()) {
            bb = proto.getUserPayload().toByteArray();
        }
        return new EdgeManagerDescriptor(className).setUserPayload(bb);
    }

    public static ProcessorDescriptor convertProcessorDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        byte[] bb = null;
        if (proto.hasUserPayload()) {
            bb = proto.getUserPayload().toByteArray();
        }
        return new ProcessorDescriptor(className).setUserPayload(bb);
    }

    public static TezSessionStatus convertTezSessionStatusFromProto(DAGClientAMProtocolRPC.TezSessionStatusProto proto) {
        switch (proto) {
            case INITIALIZING: {
                return TezSessionStatus.INITIALIZING;
            }
            case READY: {
                return TezSessionStatus.READY;
            }
            case RUNNING: {
                return TezSessionStatus.RUNNING;
            }
            case SHUTDOWN: {
                return TezSessionStatus.SHUTDOWN;
            }
        }
        throw new TezUncheckedException("Could not convert to TezSessionStatus from proto");
    }

    public static DAGClientAMProtocolRPC.TezSessionStatusProto convertTezSessionStatusToProto(TezSessionStatus status) {
        switch (status) {
            case INITIALIZING: {
                return DAGClientAMProtocolRPC.TezSessionStatusProto.INITIALIZING;
            }
            case READY: {
                return DAGClientAMProtocolRPC.TezSessionStatusProto.READY;
            }
            case RUNNING: {
                return DAGClientAMProtocolRPC.TezSessionStatusProto.RUNNING;
            }
            case SHUTDOWN: {
                return DAGClientAMProtocolRPC.TezSessionStatusProto.SHUTDOWN;
            }
        }
        throw new TezUncheckedException("Could not convert TezSessionStatus to proto");
    }

    public static DAGProtos.PlanLocalResourcesProto convertFromLocalResources(Map<String, LocalResource> localResources) {
        DAGProtos.PlanLocalResourcesProto.Builder builder = DAGProtos.PlanLocalResourcesProto.newBuilder();
        for (Map.Entry<String, LocalResource> entry : localResources.entrySet()) {
            DAGProtos.PlanLocalResource plr = DagTypeConverters.convertLocalResourceToPlanLocalResource(entry.getKey(), entry.getValue());
            builder.addLocalResources(plr);
        }
        return builder.build();
    }

    public static Map<String, LocalResource> convertFromPlanLocalResources(DAGProtos.PlanLocalResourcesProto proto) {
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>(proto.getLocalResourcesCount());
        for (DAGProtos.PlanLocalResource plr : proto.getLocalResourcesList()) {
            String name = plr.getName();
            LocalResource lr = DagTypeConverters.convertPlanLocalResourceToLocalResource(plr);
            localResources.put(name, lr);
        }
        return localResources;
    }

    public static DAGProtos.PlanLocalResource convertLocalResourceToPlanLocalResource(String name, LocalResource lr) {
        DAGProtos.PlanLocalResource.Builder localResourcesBuilder = DAGProtos.PlanLocalResource.newBuilder();
        localResourcesBuilder.setName(name);
        localResourcesBuilder.setUri(DagTypeConverters.convertToDAGPlan(lr.getResource()));
        localResourcesBuilder.setSize(lr.getSize());
        localResourcesBuilder.setTimeStamp(lr.getTimestamp());
        localResourcesBuilder.setType(DagTypeConverters.convertToDAGPlan(lr.getType()));
        localResourcesBuilder.setVisibility(DagTypeConverters.convertToDAGPlan(lr.getVisibility()));
        if (lr.getType() == LocalResourceType.PATTERN) {
            if (lr.getPattern() == null || lr.getPattern().isEmpty()) {
                throw new TezUncheckedException("LocalResource type set to pattern but pattern is null or empty");
            }
            localResourcesBuilder.setPattern(lr.getPattern());
        }
        return localResourcesBuilder.build();
    }

    public static LocalResource convertPlanLocalResourceToLocalResource(DAGProtos.PlanLocalResource plr) {
        return LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)new Path(plr.getUri())), (LocalResourceType)DagTypeConverters.convertFromDAGPlan(plr.getType()), (LocalResourceVisibility)DagTypeConverters.convertFromDAGPlan(plr.getVisibility()), (long)plr.getSize(), (long)plr.getTimeStamp(), (String)(plr.hasPattern() ? plr.getPattern() : null));
    }

    public static TezCounters convertTezCountersFromProto(DAGProtos.TezCountersProto proto) {
        TezCounters counters = new TezCounters();
        for (DAGProtos.TezCounterGroupProto counterGroupProto : proto.getCounterGroupsList()) {
            CounterGroup group = (CounterGroup)counters.addGroup(counterGroupProto.getName(), counterGroupProto.getDisplayName());
            for (DAGProtos.TezCounterProto counterProto : counterGroupProto.getCountersList()) {
                Object counter = group.findCounter(counterProto.getName(), counterProto.getDisplayName());
                counter.setValue(counterProto.getValue());
            }
        }
        return counters;
    }

    public static DAGProtos.TezCountersProto convertTezCountersToProto(TezCounters counters) {
        DAGProtos.TezCountersProto.Builder builder = DAGProtos.TezCountersProto.newBuilder();
        Iterator groupIterator = counters.iterator();
        int groupIndex = 0;
        while (groupIterator.hasNext()) {
            CounterGroup counterGroup = (CounterGroup)groupIterator.next();
            DAGProtos.TezCounterGroupProto.Builder groupBuilder = DAGProtos.TezCounterGroupProto.newBuilder();
            groupBuilder.setName(counterGroup.getName());
            groupBuilder.setDisplayName(counterGroup.getDisplayName());
            Iterator counterIterator = counterGroup.iterator();
            int counterIndex = 0;
            while (counterIterator.hasNext()) {
                TezCounter counter = (TezCounter)counterIterator.next();
                DAGProtos.TezCounterProto tezCounterProto = DAGProtos.TezCounterProto.newBuilder().setName(counter.getName()).setDisplayName(counter.getDisplayName()).setValue(counter.getValue()).build();
                groupBuilder.addCounters(counterIndex, tezCounterProto);
                ++counterIndex;
            }
            builder.addCounterGroups(groupIndex, groupBuilder.build());
            ++groupIndex;
        }
        return builder.build();
    }

    public static DAGProtos.StatusGetOptsProto convertStatusGetOptsToProto(StatusGetOpts statusGetOpts) {
        switch (statusGetOpts) {
            case GET_COUNTERS: {
                return DAGProtos.StatusGetOptsProto.GET_COUNTERS;
            }
        }
        throw new TezUncheckedException("Could not convert StatusGetOpts to proto");
    }

    public static StatusGetOpts convertStatusGetOptsFromProto(DAGProtos.StatusGetOptsProto proto) {
        switch (proto) {
            case GET_COUNTERS: {
                return StatusGetOpts.GET_COUNTERS;
            }
        }
        throw new TezUncheckedException("Could not convert to StatusGetOpts from proto");
    }

    public static List<DAGProtos.StatusGetOptsProto> convertStatusGetOptsToProto(Set<StatusGetOpts> statusGetOpts) {
        ArrayList<DAGProtos.StatusGetOptsProto> protos = new ArrayList<DAGProtos.StatusGetOptsProto>(statusGetOpts.size());
        for (StatusGetOpts opt : statusGetOpts) {
            protos.add(DagTypeConverters.convertStatusGetOptsToProto(opt));
        }
        return protos;
    }

    public static Set<StatusGetOpts> convertStatusGetOptsFromProto(List<DAGProtos.StatusGetOptsProto> protoList) {
        TreeSet<StatusGetOpts> opts = new TreeSet<StatusGetOpts>();
        for (DAGProtos.StatusGetOptsProto proto : protoList) {
            opts.add(DagTypeConverters.convertStatusGetOptsFromProto(proto));
        }
        return opts;
    }

    public static ByteString convertCredentialsToProto(Credentials credentials) {
        if (credentials == null) {
            return null;
        }
        ByteString.Output output = ByteString.newOutput();
        DataOutputStream dos = new DataOutputStream((OutputStream)output);
        try {
            credentials.writeTokenStorageToStream(dos);
            return output.toByteString();
        }
        catch (IOException e) {
            throw new TezUncheckedException("Failed to serialize Credentials", e);
        }
    }

    public static Credentials convertByteStringToCredentials(ByteString byteString) {
        if (byteString == null) {
            return null;
        }
        DataInputByteBuffer dib = new DataInputByteBuffer();
        dib.reset(new ByteBuffer[]{byteString.asReadOnlyByteBuffer()});
        Credentials credentials = new Credentials();
        try {
            credentials.readTokenStorageStream((DataInputStream)dib);
            return credentials;
        }
        catch (IOException e) {
            throw new TezUncheckedException("Failed to deserialize Credentials", e);
        }
    }

    public static VertexLocationHint convertVertexLocationHintFromProto(DAGProtos.VertexLocationHintProto proto) {
        ArrayList<VertexLocationHint.TaskLocationHint> outputList = new ArrayList<VertexLocationHint.TaskLocationHint>(proto.getTaskLocationHintsCount());
        for (DAGProtos.PlanTaskLocationHint inputHint : proto.getTaskLocationHintsList()) {
            VertexLocationHint.TaskLocationHint outputHint = new VertexLocationHint.TaskLocationHint(new HashSet<String>(inputHint.getHostList()), new HashSet<String>(inputHint.getRackList()));
            outputList.add(outputHint);
        }
        return new VertexLocationHint(outputList);
    }

    public static DAGProtos.VertexLocationHintProto convertVertexLocationHintToProto(VertexLocationHint vertexLocationHint) {
        DAGProtos.VertexLocationHintProto.Builder builder = DAGProtos.VertexLocationHintProto.newBuilder();
        if (vertexLocationHint.getTaskLocationHints() != null) {
            for (VertexLocationHint.TaskLocationHint taskLocationHint : vertexLocationHint.getTaskLocationHints()) {
                DAGProtos.PlanTaskLocationHint.Builder taskLHBuilder = DAGProtos.PlanTaskLocationHint.newBuilder();
                if (taskLocationHint.getDataLocalHosts() != null) {
                    taskLHBuilder.addAllHost(taskLocationHint.getDataLocalHosts());
                }
                if (taskLocationHint.getRacks() != null) {
                    taskLHBuilder.addAllRack(taskLocationHint.getRacks());
                }
                builder.addTaskLocationHints(taskLHBuilder.build());
            }
        }
        return builder.build();
    }

    public static DAGProtos.PreWarmContextProto convertPreWarmContextToProto(PreWarmContext preWarmContext) {
        DAGProtos.PreWarmContextProto.Builder builder = DAGProtos.PreWarmContextProto.newBuilder();
        builder.setProcessorDescriptor(DagTypeConverters.convertToDAGPlan(preWarmContext.getProcessorDescriptor()));
        builder.setNumTasks(preWarmContext.getNumTasks());
        builder.setMemoryMb(preWarmContext.getResource().getMemory());
        builder.setVirtualCores(preWarmContext.getResource().getVirtualCores());
        if (preWarmContext.getLocalResources() != null) {
            builder.setLocalResources(DagTypeConverters.convertFromLocalResources(preWarmContext.getLocalResources()));
        }
        if (preWarmContext.getEnvironment() != null) {
            for (Map.Entry<String, String> entry : preWarmContext.getEnvironment().entrySet()) {
                builder.addEnvironmentSetting(DAGProtos.PlanKeyValuePair.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
            }
        }
        if (preWarmContext.getLocationHints() != null) {
            builder.setLocationHints(DagTypeConverters.convertVertexLocationHintToProto(preWarmContext.getLocationHints()));
        }
        if (preWarmContext.getJavaOpts() != null) {
            builder.setJavaOpts(preWarmContext.getJavaOpts());
        }
        return builder.build();
    }

    public static PreWarmContext convertPreWarmContextFromProto(DAGProtos.PreWarmContextProto proto) {
        VertexLocationHint vertexLocationHint = null;
        if (proto.hasLocationHints()) {
            vertexLocationHint = DagTypeConverters.convertVertexLocationHintFromProto(proto.getLocationHints());
        }
        PreWarmContext context = new PreWarmContext(DagTypeConverters.convertProcessorDescriptorFromDAGPlan(proto.getProcessorDescriptor()), Resource.newInstance((int)proto.getMemoryMb(), (int)proto.getVirtualCores()), proto.getNumTasks(), vertexLocationHint);
        if (proto.hasLocalResources()) {
            context.setLocalResources(DagTypeConverters.convertFromPlanLocalResources(proto.getLocalResources()));
        }
        context.setEnvironment(DagTypeConverters.createEnvironmentMapFromDAGPlan(proto.getEnvironmentSettingList()));
        if (proto.hasJavaOpts()) {
            context.setJavaOpts(proto.getJavaOpts());
        }
        return context;
    }
}

