/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;

public class GroupInputEdge {
    private final VertexGroup inputVertexGroup;
    private final Vertex outputVertex;
    private final EdgeProperty edgeProperty;
    private final InputDescriptor mergedInput;

    public GroupInputEdge(VertexGroup inputVertexGroup, Vertex outputVertex, EdgeProperty edgeProperty, InputDescriptor mergedInput) {
        this.inputVertexGroup = inputVertexGroup;
        this.outputVertex = outputVertex;
        this.edgeProperty = edgeProperty;
        if (mergedInput == null) {
            throw new TezUncheckedException("Merged input must be specified when using GroupInputEdge");
        }
        this.mergedInput = mergedInput;
    }

    public VertexGroup getInputVertexGroup() {
        return this.inputVertexGroup;
    }

    public Vertex getOutputVertex() {
        return this.outputVertex;
    }

    public EdgeProperty getEdgeProperty() {
        return this.edgeProperty;
    }

    InputDescriptor getMergedInput() {
        return this.mergedInput;
    }

    @InterfaceAudience.Private
    public String getId() {
        return String.valueOf(this.hashCode());
    }

    public String toString() {
        return this.inputVertexGroup + " -> " + this.outputVertex + " (" + this.edgeProperty + ")";
    }
}

