/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.EdgeManagerDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;

public class EdgeProperty {
    final DataMovementType dataMovementType;
    final DataSourceType dataSourceType;
    final SchedulingType schedulingType;
    final InputDescriptor inputDescriptor;
    final OutputDescriptor outputDescriptor;
    final EdgeManagerDescriptor edgeManagerDescriptor;

    public EdgeProperty(DataMovementType dataMovementType, DataSourceType dataSourceType, SchedulingType schedulingType, OutputDescriptor edgeSource, InputDescriptor edgeDestination) {
        Preconditions.checkArgument((dataMovementType != DataMovementType.CUSTOM ? 1 : 0) != 0, (Object)((Object)((Object)DataMovementType.CUSTOM) + " cannot be used with this constructor"));
        this.dataMovementType = dataMovementType;
        this.dataSourceType = dataSourceType;
        this.schedulingType = schedulingType;
        this.outputDescriptor = edgeSource;
        this.inputDescriptor = edgeDestination;
        this.edgeManagerDescriptor = null;
    }

    public EdgeProperty(EdgeManagerDescriptor edgeManagerDescriptor, DataSourceType dataSourceType, SchedulingType schedulingType, OutputDescriptor edgeSource, InputDescriptor edgeDestination) {
        this.dataMovementType = DataMovementType.CUSTOM;
        this.edgeManagerDescriptor = edgeManagerDescriptor;
        this.dataSourceType = dataSourceType;
        this.schedulingType = schedulingType;
        this.inputDescriptor = edgeDestination;
        this.outputDescriptor = edgeSource;
    }

    public DataMovementType getDataMovementType() {
        return this.dataMovementType;
    }

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public SchedulingType getSchedulingType() {
        return this.schedulingType;
    }

    public InputDescriptor getEdgeDestination() {
        return this.inputDescriptor;
    }

    public OutputDescriptor getEdgeSource() {
        return this.outputDescriptor;
    }

    @InterfaceAudience.Private
    public EdgeManagerDescriptor getEdgeManagerDescriptor() {
        return this.edgeManagerDescriptor;
    }

    public String toString() {
        return "{ " + (Object)((Object)this.dataMovementType) + " : " + this.inputDescriptor.getClassName() + " >> " + (Object)((Object)this.dataSourceType) + " >> " + this.outputDescriptor.getClassName() + " >> " + (this.edgeManagerDescriptor == null ? "NullEdgeManager" : this.edgeManagerDescriptor.getClassName()) + " }";
    }

    public static enum SchedulingType {
        SEQUENTIAL,
        CONCURRENT;

    }

    public static enum DataSourceType {
        PERSISTED,
        PERSISTED_RELIABLE,
        EPHEMERAL;

    }

    public static enum DataMovementType {
        ONE_TO_ONE,
        BROADCAST,
        SCATTER_GATHER,
        CUSTOM;

    }
}

