/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.counters;

import org.apache.tez.common.counters.AbstractCounterGroup;
import org.apache.tez.common.counters.AggregateFrameworkCounter;
import org.apache.tez.common.counters.AggregateTezCounterDelegate;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.CounterGroupBase;
import org.apache.tez.common.counters.CounterGroupFactory;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.FileSystemCounterGroup;
import org.apache.tez.common.counters.FrameworkCounterGroup;
import org.apache.tez.common.counters.GenericCounter;
import org.apache.tez.common.counters.Limits;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;

public class AggregateTezCounters
extends TezCounters {
    private static final GroupFactory groupFactory = new GroupFactory();

    public AggregateTezCounters() {
        super(groupFactory);
    }

    private static class GroupFactory
    extends CounterGroupFactory<TezCounter, CounterGroup> {
        private GroupFactory() {
        }

        @Override
        protected <T extends Enum<T>> CounterGroupFactory.FrameworkGroupFactory<CounterGroup> newFrameworkGroupFactory(final Class<T> cls) {
            return new CounterGroupFactory.FrameworkGroupFactory<CounterGroup>(){

                @Override
                public CounterGroup newGroup(String name) {
                    return new AggregateFrameworkGroupImpl(cls);
                }
            };
        }

        @Override
        protected CounterGroup newGenericGroup(String name, String displayName, Limits limits) {
            return new AggregateGenericGroup(name, displayName, limits);
        }

        @Override
        protected CounterGroup newFileSystemGroup() {
            return new AggregateFileSystemGroup();
        }
    }

    private static class AggregateFileSystemGroup
    extends FileSystemCounterGroup<TezCounter>
    implements CounterGroup {
        private AggregateFileSystemGroup() {
        }

        @Override
        protected TezCounter newCounter(String scheme, FileSystemCounter key) {
            return new AggregateTezCounterDelegate<FileSystemCounterGroup.FSCounter>(new FileSystemCounterGroup.FSCounter(scheme, key));
        }

        @Override
        public CounterGroupBase<TezCounter> getUnderlyingGroup() {
            return this;
        }
    }

    private static class AggregateGenericGroup
    extends AbstractCounterGroup<TezCounter>
    implements CounterGroup {
        AggregateGenericGroup(String name, String displayName, Limits limits) {
            super(name, displayName, limits);
        }

        @Override
        protected TezCounter newCounter(String name, String displayName, long value) {
            return new AggregateTezCounterDelegate<GenericCounter>(new GenericCounter(name, displayName, value));
        }

        @Override
        protected TezCounter newCounter() {
            return new AggregateTezCounterDelegate<GenericCounter>(new GenericCounter());
        }

        @Override
        public CounterGroupBase<TezCounter> getUnderlyingGroup() {
            return this;
        }
    }

    private static class AggregateFrameworkGroupImpl<T extends Enum<T>>
    extends FrameworkCounterGroup<T, TezCounter>
    implements CounterGroup {
        AggregateFrameworkGroupImpl(Class<T> cls) {
            super(cls);
        }

        @Override
        protected FrameworkCounterGroup.FrameworkCounter<T> newCounter(T key) {
            return new AggregateFrameworkCounter(key, this.getName()).asFrameworkCounter();
        }

        @Override
        public CounterGroupBase<TezCounter> getUnderlyingGroup() {
            return this;
        }
    }
}

