/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.commons.internal.services;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.LinkedList;
import org.apache.tapestry5.commons.services.GenericsResolver;

public class GenericsResolverImpl
implements GenericsResolver {
    @Override
    public Class<?> extractGenericReturnType(Class<?> containingClass, Method method) {
        return this.asClass(this.resolve(method.getGenericReturnType(), containingClass));
    }

    @Override
    public Class extractGenericFieldType(Class containingClass, Field field) {
        return this.asClass(this.resolve(field.getGenericType(), (Type)containingClass));
    }

    @Override
    public Type extractActualType(Type containingType, Method method) {
        return this.resolve(method.getGenericReturnType(), containingType);
    }

    @Override
    public Type extractActualType(Type containingType, Field field) {
        return this.resolve(field.getGenericType(), containingType);
    }

    @Override
    public Type resolve(Type type, Type containingType) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            return this.resolve((ParameterizedType)type, containingType);
        }
        if (type instanceof GenericArrayType) {
            return this.resolve((GenericArrayType)type, containingType);
        }
        if (type instanceof WildcardType) {
            return this.resolve((WildcardType)type, containingType);
        }
        if (type instanceof TypeVariable) {
            return this.resolve((TypeVariable)type, containingType);
        }
        return type;
    }

    private boolean isAssignableFrom(Type suspectedSuperType, Type suspectedSubType) {
        Class suspectedSubClass;
        Class suspectedSuperClass = this.asClass(suspectedSuperType);
        if (!suspectedSuperClass.isAssignableFrom(suspectedSubClass = this.asClass(suspectedSubType))) {
            return false;
        }
        if (suspectedSuperType instanceof WildcardType) {
            for (Type t : ((WildcardType)suspectedSuperType).getUpperBounds()) {
                if (this.isAssignableFrom(t, suspectedSubType)) continue;
                return false;
            }
            for (Type t : ((WildcardType)suspectedSuperType).getLowerBounds()) {
                if (this.isAssignableFrom(suspectedSubType, t)) continue;
                return false;
            }
            return true;
        }
        Type curType = suspectedSubType;
        while (curType != null && !curType.equals(Object.class)) {
            Type[] types;
            Class curClass = this.asClass(curType);
            if (curClass.equals(suspectedSuperClass)) {
                Type resolved = this.resolve(curType, suspectedSubType);
                if (suspectedSuperType instanceof Class) {
                    if (resolved instanceof Class) {
                        return suspectedSuperType.equals(resolved);
                    }
                    return true;
                }
                if (suspectedSuperType instanceof ParameterizedType) {
                    if (resolved instanceof ParameterizedType) {
                        Type[] type2Arguments;
                        Type[] type1Arguments = ((ParameterizedType)suspectedSuperType).getActualTypeArguments();
                        if (type1Arguments.length != (type2Arguments = ((ParameterizedType)resolved).getActualTypeArguments()).length) {
                            return false;
                        }
                        for (int i = 0; i < type1Arguments.length; ++i) {
                            if (this.isAssignableFrom(type1Arguments[i], type2Arguments[i])) continue;
                            return false;
                        }
                        return true;
                    }
                } else if (suspectedSuperType instanceof GenericArrayType && resolved instanceof GenericArrayType) {
                    return this.isAssignableFrom(((GenericArrayType)suspectedSuperType).getGenericComponentType(), ((GenericArrayType)resolved).getGenericComponentType());
                }
                return false;
            }
            for (Type t : types = curClass.getGenericInterfaces()) {
                Type resolved = this.resolve(t, suspectedSubType);
                if (!this.isAssignableFrom(suspectedSuperType, resolved)) continue;
                return true;
            }
            curType = curClass.getGenericSuperclass();
        }
        return false;
    }

    @Override
    public Class asClass(Type actualType) {
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)actualType).getRawType();
            return (Class)rawType;
        }
        if (actualType instanceof GenericArrayType) {
            Type type = ((GenericArrayType)actualType).getGenericComponentType();
            return Array.newInstance(this.asClass(type), 0).getClass();
        }
        if (actualType instanceof TypeVariable) {
            return this.asClass(((TypeVariable)actualType).getBounds()[0]);
        }
        if (actualType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)actualType;
            Type[] bounds = wildcardType.getLowerBounds();
            if (bounds != null && bounds.length > 0) {
                return this.asClass(bounds[0]);
            }
            return Object.class;
        }
        throw new RuntimeException(String.format("Unable to convert %s to Class.", actualType));
    }

    public static String toString(Type type) {
        if (type instanceof ParameterizedType) {
            return GenericsResolverImpl.toString((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return GenericsResolverImpl.toString((WildcardType)type);
        }
        if (type instanceof GenericArrayType) {
            return GenericsResolverImpl.toString((GenericArrayType)type);
        }
        if (type instanceof Class) {
            Class theClass = (Class)type;
            return theClass.isArray() ? theClass.getName() + "[]" : theClass.getName();
        }
        return type.toString();
    }

    private Type resolve(TypeVariable typeVariable, Type containingType) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        if (!(genericDeclaration instanceof Class)) {
            Type bounds0 = typeVariable.getBounds()[0];
            return this.resolve(bounds0, containingType);
        }
        Class typeVariableOwner = (Class)genericDeclaration;
        LinkedList<Type> stack = new LinkedList<Type>();
        if (containingType instanceof ParameterizedType) {
            stack.add(containingType);
        }
        Class theClass = this.asClass(containingType);
        Type genericSuperclass = theClass.getGenericSuperclass();
        while (genericSuperclass != null && !theClass.equals(Object.class) && !theClass.equals(typeVariableOwner)) {
            stack.addFirst(genericSuperclass);
            theClass = this.asClass(genericSuperclass);
            genericSuperclass = theClass.getGenericSuperclass();
        }
        int i = GenericsResolverImpl.getTypeVariableIndex(typeVariable);
        Type resolved = typeVariable;
        for (Type t : stack) {
            if (!(t instanceof ParameterizedType)) continue;
            resolved = ((ParameterizedType)t).getActualTypeArguments()[i];
            if (resolved instanceof Class) {
                return resolved;
            }
            if (resolved instanceof TypeVariable) {
                i = GenericsResolverImpl.getTypeVariableIndex(resolved);
                continue;
            }
            return this.resolve(resolved, containingType);
        }
        return resolved.getBounds()[0];
    }

    private GenericArrayType resolve(GenericArrayType type, Type containingType) {
        Type componentType = type.getGenericComponentType();
        if (!(componentType instanceof Class)) {
            Type resolved = this.resolve(componentType, containingType);
            return GenericsResolverImpl.create(resolved);
        }
        return type;
    }

    private ParameterizedType resolve(ParameterizedType type, Type containingType) {
        Type[] types = (Type[])type.getActualTypeArguments().clone();
        boolean modified = this.resolve(types, containingType);
        return modified ? GenericsResolverImpl.create(type.getRawType(), type.getOwnerType(), types) : type;
    }

    private WildcardType resolve(WildcardType type, Type containingType) {
        Type[] upper = (Type[])type.getUpperBounds().clone();
        Type[] lower = (Type[])type.getLowerBounds().clone();
        boolean modified = this.resolve(upper, containingType);
        modified = modified || this.resolve(lower, containingType);
        return modified ? GenericsResolverImpl.create(upper, lower) : type;
    }

    private boolean resolve(Type[] types, Type containingType) {
        boolean modified = false;
        for (int i = 0; i < types.length; ++i) {
            Type t = types[i];
            if (t instanceof Class) continue;
            modified = true;
            Type resolved = this.resolve(t, containingType);
            if (resolved.equals(t)) continue;
            types[i] = resolved;
            modified = true;
        }
        return modified;
    }

    static ParameterizedType create(final Type rawType, final Type ownerType, final Type[] typeArguments) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return typeArguments;
            }

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return ownerType;
            }

            public String toString() {
                return GenericsResolverImpl.toString(this);
            }
        };
    }

    static GenericArrayType create(final Type componentType) {
        return new GenericArrayType(){

            @Override
            public Type getGenericComponentType() {
                return componentType;
            }

            public String toString() {
                return GenericsResolverImpl.toString(this);
            }
        };
    }

    static WildcardType create(final Type[] upperBounds, final Type[] lowerBounds) {
        return new WildcardType(){

            @Override
            public Type[] getUpperBounds() {
                return upperBounds;
            }

            @Override
            public Type[] getLowerBounds() {
                return lowerBounds;
            }

            public String toString() {
                return GenericsResolverImpl.toString(this);
            }
        };
    }

    static String toString(ParameterizedType pt) {
        String s = GenericsResolverImpl.toString(pt.getActualTypeArguments());
        return String.format("%s<%s>", GenericsResolverImpl.toString(pt.getRawType()), s);
    }

    static String toString(GenericArrayType gat) {
        return String.format("%s[]", GenericsResolverImpl.toString(gat.getGenericComponentType()));
    }

    static String toString(WildcardType wt) {
        boolean isSuper = wt.getLowerBounds().length > 0;
        return String.format("? %s %s", isSuper ? "super" : "extends", GenericsResolverImpl.toString(wt.getLowerBounds()));
    }

    static String toString(Type[] types) {
        StringBuilder sb = new StringBuilder();
        for (Type t : types) {
            sb.append(GenericsResolverImpl.toString(t)).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    private static int getTypeVariableIndex(TypeVariable typeVariable) {
        String typeVarName = typeVariable.getName();
        TypeVariable<?>[] typeParameters = typeVariable.getGenericDeclaration().getTypeParameters();
        for (int typeArgumentIndex = 0; typeArgumentIndex < typeParameters.length; ++typeArgumentIndex) {
            if (!typeParameters[typeArgumentIndex].getName().equals(typeVarName)) continue;
            return typeArgumentIndex;
        }
        throw new RuntimeException(String.format("%s does not have a TypeVariable matching %s", typeVariable.getGenericDeclaration(), typeVariable));
    }
}

