/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.commons.services;

import org.apache.tapestry5.commons.services.Coercion;
import org.apache.tapestry5.plastic.PlasticUtils;

public final class CoercionTuple<S, T> {
    private final Class<S> sourceType;
    private final Class<T> targetType;
    private final Coercion<S, T> coercion;
    private final Key key;

    private String convert(Class type) {
        if (Void.class.equals((Object)type)) {
            return "null";
        }
        String name = PlasticUtils.toTypeName((Class)type);
        int dotx = name.lastIndexOf(46);
        if (dotx > 0 && name.substring(0, dotx).equals("java.lang")) {
            return name.substring(dotx + 1);
        }
        return name;
    }

    public CoercionTuple(Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion) {
        this(sourceType, targetType, coercion, true);
    }

    public static <S, T> CoercionTuple<S, T> create(Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion) {
        return new CoercionTuple<S, T>(sourceType, targetType, coercion);
    }

    public CoercionTuple(Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion, boolean wrap) {
        assert (sourceType != null);
        assert (targetType != null);
        assert (coercion != null);
        this.sourceType = PlasticUtils.toWrapperType(sourceType);
        this.targetType = PlasticUtils.toWrapperType(targetType);
        this.coercion = wrap ? new CoercionWrapper(coercion) : coercion;
        this.key = new Key();
    }

    public String toString() {
        return this.coercion.toString();
    }

    public Coercion<S, T> getCoercion() {
        return this.coercion;
    }

    public Class<S> getSourceType() {
        return this.sourceType;
    }

    public Class<T> getTargetType() {
        return this.targetType;
    }

    public Key getKey() {
        return this.key;
    }

    public final class Key {
        public String toString() {
            return String.format("%s -> %s", CoercionTuple.this.sourceType.getName(), CoercionTuple.this.targetType.getName());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (CoercionTuple.this.sourceType == null ? 0 : CoercionTuple.this.sourceType.hashCode());
            result = 31 * result + (CoercionTuple.this.targetType == null ? 0 : CoercionTuple.this.targetType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoercionTuple other = (CoercionTuple)obj;
            if (CoercionTuple.this.sourceType == null ? other.sourceType != null : !CoercionTuple.this.sourceType.equals(other.sourceType)) {
                return false;
            }
            return !(CoercionTuple.this.targetType == null ? other.targetType != null : !CoercionTuple.this.targetType.equals(other.targetType));
        }
    }

    private class CoercionWrapper<WS, WT>
    implements Coercion<WS, WT> {
        private final Coercion<WS, WT> coercion;

        public CoercionWrapper(Coercion<WS, WT> coercion) {
            this.coercion = coercion;
        }

        @Override
        public WT coerce(WS input) {
            return this.coercion.coerce(input);
        }

        public String toString() {
            return String.format("%s --> %s", CoercionTuple.this.convert(CoercionTuple.this.sourceType), CoercionTuple.this.convert(CoercionTuple.this.targetType));
        }
    }
}

