/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.AuditEventTO;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.rest.api.service.AuditService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.audit.spi.AbstractAuditTrailManager;
import org.apereo.inspektr.audit.AuditActionContext;

public class WAAuditTrailManager
extends AbstractAuditTrailManager {
    private final WARestClient waRestClient;

    public WAAuditTrailManager(WARestClient restClient) {
        super(true);
        this.waRestClient = restClient;
    }

    protected void saveAuditRecord(AuditActionContext audit) {
        if (!this.waRestClient.isReady()) {
            LOG.debug("Syncope client is not yet ready to store audit record");
            return;
        }
        LOG.debug("Saving audit record {}", (Object)audit);
        try {
            String output = MAPPER.writeValueAsString(Map.of("resource", audit.getResourceOperatedUpon(), "clientIpAddress", audit.getClientInfo().getClientIpAddress(), "serverIpAddress", audit.getClientInfo().getServerIpAddress()));
            AuditEventTO auditEvent = new AuditEventTO();
            auditEvent.setWho(audit.getPrincipal());
            auditEvent.setWhen(audit.getWhenActionWasPerformed().atOffset(OffsetDateTime.now().getOffset()));
            auditEvent.setOutput(output);
            OpEvent.Outcome result = StringUtils.containsIgnoreCase((CharSequence)audit.getActionPerformed(), (CharSequence)"fail") ? OpEvent.Outcome.FAILURE : OpEvent.Outcome.SUCCESS;
            OpEvent opEvent = new OpEvent(OpEvent.CategoryType.WA, null, "AUTHENTICATION".toUpperCase(), audit.getActionPerformed(), result);
            auditEvent.setOpEvent(opEvent);
            ((AuditService)this.waRestClient.getService(AuditService.class)).create(auditEvent);
        }
        catch (JsonProcessingException e) {
            LOG.error("During serialization", (Throwable)e);
        }
    }

    public void removeAll() {
        throw new UnsupportedOperationException("Removing audit events from WA is not supported");
    }
}

