/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.saml2;

import org.apache.commons.lang3.StringUtils;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.exceptions.SAMLException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/saml2/metadata"})
@ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="SAML2")
public class SAML2MetadataEndpoint {
    public static final String METADATA_URL = "/saml2/metadata";
    private final String metadata;

    public SAML2MetadataEndpoint(SAML2Client saml2Client) {
        EntityDescriptor entityDescriptor = (EntityDescriptor)saml2Client.getServiceProviderMetadataResolver().getEntityDescriptorElement();
        entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleLogoutServices().removeIf(slo -> !saml2Client.getConfiguration().getSpLogoutResponseBindingType().equals(slo.getBinding()));
        entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleLogoutServices().forEach(slo -> slo.setLocation(StringUtils.substringBefore((String)slo.getLocation(), (String)"?").replace("login", "logout")));
        try {
            this.metadata = saml2Client.getConfiguration().toMetadataGenerator().getMetadata(entityDescriptor);
        }
        catch (Exception e) {
            throw new SAMLException("Unable to fetch metadata", (Throwable)e);
        }
    }

    @GetMapping(produces={"application/xml"})
    @ResponseBody
    public Mono<ResponseEntity<String>> metadata() {
        return Mono.just((Object)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"application/xml"})).body((Object)this.metadata));
    }
}

