/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.filters;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.session.Session;
import reactor.core.publisher.Mono;

public class PrincipalToRequestHeaderFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    @Autowired
    private CacheManager cacheManager;

    public PrincipalToRequestHeaderFilterFactory() {
        super(AbstractGatewayFilterFactory.NameConfig.class);
    }

    public GatewayFilter apply(AbstractGatewayFilterFactory.NameConfig config) {
        return (exchange, chain) -> exchange.getSession().flatMap(session -> Mono.justOrEmpty(Optional.ofNullable((Session)this.cacheManager.getCache("default").get((Object)session.getId(), Session.class)).map(cachedSession -> {
            String principal = null;
            SecurityContext ctx = (SecurityContext)cachedSession.getAttribute("SPRING_SECURITY_CONTEXT");
            if (ctx != null && ctx.getAuthentication() != null) {
                Object patt0$temp = ctx.getAuthentication().getPrincipal();
                if (patt0$temp instanceof OidcUser) {
                    OidcUser oidcUser = (OidcUser)patt0$temp;
                    principal = oidcUser.getIdToken().getTokenValue();
                } else {
                    Object patt1$temp = ctx.getAuthentication().getPrincipal();
                    if (patt1$temp instanceof OAuth2User) {
                        OAuth2User oAuth2User = (OAuth2User)patt1$temp;
                        principal = Objects.toString(oAuth2User.getAttributes().get("preferred_username"), null);
                    } else {
                        principal = ctx.getAuthentication().getName();
                    }
                }
            }
            return principal;
        }))).transform(principal -> principal.flatMap(p -> StringUtils.isEmpty((CharSequence)p) ? chain.filter(exchange) : chain.filter(exchange.mutate().request(exchange.getRequest().mutate().headers(headers -> headers.add(config.getName(), p)).build()).build()))).switchIfEmpty(chain.filter(exchange));
    }
}

