/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.syncope.sra.RouteProvider;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractRouteMatcher
implements ServerWebExchangeMatcher,
ApplicationListener<RefreshRoutesEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRouteMatcher.class);
    protected static final Map<String, Map<String, Boolean>> CACHE = new ConcurrentHashMap<String, Map<String, Boolean>>();
    @Autowired
    private RouteLocator routeLocator;
    @Autowired
    protected RouteProvider routeProvider;

    protected abstract String getCacheName();

    protected abstract boolean routeBehavior(Route var1);

    public void onApplicationEvent(RefreshRoutesEvent event) {
        Optional.ofNullable(CACHE.get(this.getCacheName())).ifPresent(Map::clear);
    }

    public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange) {
        return this.routeLocator.getRoutes().concatMap(route -> Mono.just((Object)route).filterWhen(r -> (Publisher)r.getPredicate().apply((Object)exchange)).doOnError(e -> LOG.error("Error applying predicate for route: {}", (Object)route.getId(), e)).onErrorResume(e -> Mono.empty())).next().flatMap(route -> {
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR, route.getId());
            LOG.debug("[{}] Route found: {}", (Object)this.getClass().getName(), route);
            boolean cond = Optional.ofNullable(CACHE.get(this.getCacheName()).get(route.getId())).orElseGet(() -> {
                boolean result = this.routeBehavior((Route)route);
                CACHE.get(this.getCacheName()).put(route.getId(), result);
                return result;
            });
            LOG.debug("[{}] Condition matched: {}", (Object)this.getClass().getName(), (Object)cond);
            return cond ? ServerWebExchangeMatcher.MatchResult.match() : ServerWebExchangeMatcher.MatchResult.notMatch();
        }).switchIfEmpty(Mono.defer(() -> {
            LOG.debug("[{}] No Route found", (Object)this.getClass().getName());
            return ServerWebExchangeMatcher.MatchResult.notMatch();
        }));
    }
}

