/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.syncope.common.lib.SyncopeProperties;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apereo.cas.client.Protocol;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="sra")
public class SRAProperties
extends SyncopeProperties {
    private static final long serialVersionUID = 1250377680268118123L;
    public static final String PREFIX = "sra";
    public static final String AM_TYPE = "am-type";
    private final Global global = new Global();
    private AMType amType = AMType.OIDC;
    private final OIDC oidc = new OIDC();
    private final OAUTH2 oauth2 = new OAUTH2();
    private final SAML2 saml2 = new SAML2();
    private final CAS cas = new CAS();

    public Global getGlobal() {
        return this.global;
    }

    public AMType getAmType() {
        return this.amType;
    }

    public void setAmType(AMType amType) {
        this.amType = amType;
    }

    public OIDC getOidc() {
        return this.oidc;
    }

    public OAUTH2 getOauth2() {
        return this.oauth2;
    }

    public SAML2 getSaml2() {
        return this.saml2;
    }

    public CAS getCas() {
        return this.cas;
    }

    public static class Global
    implements Serializable {
        private static final long serialVersionUID = -2035267979830256742L;
        private URI error = URI.create("/error");
        private URI postLogout = URI.create("/logout");

        public URI getError() {
            return this.error;
        }

        public void setError(URI error) {
            this.error = error;
        }

        public URI getPostLogout() {
            return this.postLogout;
        }

        public void setPostLogout(URI postLogout) {
            this.postLogout = postLogout;
        }
    }

    public static enum AMType {
        OIDC,
        OAUTH2,
        SAML2,
        CAS;

    }

    public static class OIDC
    implements Serializable {
        private static final long serialVersionUID = 4428057402762583676L;
        private String configuration;
        private String clientId;
        private String clientSecret;
        private List<String> scopes = Arrays.asList("openid", "address", "email", "phone", "profile");

        public String getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }
    }

    public static class OAUTH2
    implements Serializable {
        private static final long serialVersionUID = -5051777207539192764L;
        private String tokenUri;
        private String authorizationUri;
        private String userInfoUri;
        private String userNameAttributeName;
        private String jwkSetUri;
        private String issuer;
        private String clientId;
        private String clientSecret;
        private List<String> scopes = new ArrayList<String>();

        public String getTokenUri() {
            return this.tokenUri;
        }

        public void setTokenUri(String tokenUri) {
            this.tokenUri = tokenUri;
        }

        public String getAuthorizationUri() {
            return this.authorizationUri;
        }

        public void setAuthorizationUri(String authorizationUri) {
            this.authorizationUri = authorizationUri;
        }

        public String getUserInfoUri() {
            return this.userInfoUri;
        }

        public void setUserInfoUri(String userInfoUri) {
            this.userInfoUri = userInfoUri;
        }

        public String getUserNameAttributeName() {
            return this.userNameAttributeName;
        }

        public void setUserNameAttributeName(String userNameAttributeName) {
            this.userNameAttributeName = userNameAttributeName;
        }

        public String getJwkSetUri() {
            return this.jwkSetUri;
        }

        public void setJwkSetUri(String jwkSetUri) {
            this.jwkSetUri = jwkSetUri;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }
    }

    public static class SAML2
    implements Serializable {
        private static final long serialVersionUID = 6819907914821190235L;
        private SAML2BindingType authnRequestBinding = SAML2BindingType.POST;
        private SAML2BindingType logoutRequestBinding = SAML2BindingType.POST;
        private SAML2BindingType logoutResponseBinding = SAML2BindingType.REDIRECT;
        private String entityId;
        private long maximumAuthenticationLifetime = 3600L;
        private long acceptedSkew = 300L;
        private String spMetadataFilePath;
        private String idpMetadata;
        private String keystore;
        private String keystoreType;
        private String keystoreStorepass;
        private String keystoreKeypass;

        public SAML2BindingType getAuthnRequestBinding() {
            return this.authnRequestBinding;
        }

        public void setAuthnRequestBinding(SAML2BindingType authnRequestBinding) {
            this.authnRequestBinding = authnRequestBinding;
        }

        public SAML2BindingType getLogoutRequestBinding() {
            return this.logoutRequestBinding;
        }

        public void setLogoutRequestBinding(SAML2BindingType logoutRequestBinding) {
            this.logoutRequestBinding = logoutRequestBinding;
        }

        public SAML2BindingType getLogoutResponseBinding() {
            return this.logoutResponseBinding;
        }

        public void setLogoutResponseBinding(SAML2BindingType logoutResponseBinding) {
            this.logoutResponseBinding = logoutResponseBinding;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public long getMaximumAuthenticationLifetime() {
            return this.maximumAuthenticationLifetime;
        }

        public void setMaximumAuthenticationLifetime(long maximumAuthenticationLifetime) {
            this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
        }

        public long getAcceptedSkew() {
            return this.acceptedSkew;
        }

        public void setAcceptedSkew(int acceptedSkew) {
            this.acceptedSkew = acceptedSkew;
        }

        public String getSpMetadataFilePath() {
            return this.spMetadataFilePath;
        }

        public void setSpMetadataFilePath(String spMetadataFilePath) {
            this.spMetadataFilePath = spMetadataFilePath;
        }

        public String getIdpMetadata() {
            return this.idpMetadata;
        }

        public void setIdpMetadata(String idpMetadata) {
            this.idpMetadata = idpMetadata;
        }

        public String getKeystore() {
            return this.keystore;
        }

        public void setKeystore(String keystore) {
            this.keystore = keystore;
        }

        public String getKeystoreType() {
            return this.keystoreType;
        }

        public void setKeystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
        }

        public String getKeystoreStorePass() {
            return this.keystoreStorepass;
        }

        public void setKeystoreStorePass(String keystoreStorePass) {
            this.keystoreStorepass = keystoreStorePass;
        }

        public String getKeystoreKeypass() {
            return this.keystoreKeypass;
        }

        public void setKeystoreKeypass(String keystoreKeyPass) {
            this.keystoreKeypass = keystoreKeyPass;
        }
    }

    public static class CAS
    implements Serializable {
        private static final long serialVersionUID = -5413988649759834473L;
        private String serverPrefix;
        private Protocol protocol = Protocol.CAS3;

        public String getServerPrefix() {
            return this.serverPrefix;
        }

        public void setServerPrefix(String serverPrefix) {
            this.serverPrefix = serverPrefix;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public void setProtocol(Protocol protocol) {
            this.protocol = protocol;
        }
    }
}

