/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.to.SRARouteTO;
import org.apache.syncope.common.lib.types.SRARouteFilter;
import org.apache.syncope.common.lib.types.SRARouteFilterFactory;
import org.apache.syncope.common.lib.types.SRARoutePredicate;
import org.apache.syncope.common.lib.types.SRARoutePredicateFactory;
import org.apache.syncope.common.rest.api.service.SRARouteService;
import org.apache.syncope.sra.ApplicationContextUtils;
import org.apache.syncope.sra.filters.ClientCertsToRequestHeaderFilterFactory;
import org.apache.syncope.sra.filters.CustomGatewayFilterFactory;
import org.apache.syncope.sra.filters.LinkRewriteGatewayFilterFactory;
import org.apache.syncope.sra.filters.PrincipalToRequestHeaderFilterFactory;
import org.apache.syncope.sra.filters.QueryParamToRequestHeaderFilterFactory;
import org.apache.syncope.sra.predicates.CustomRoutePredicateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AddRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddRequestParameterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.DedupeResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.FallbackHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.MapRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.PrefixPathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.PreserveHostHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RedirectToGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestHeaderToRequestUriGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestRateLimiterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestSizeGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RetryGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewriteLocationResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewritePathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewriteResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SaveSessionGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetPathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetRequestHostHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetStatusGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.StripPrefixGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.ratelimit.KeyResolver;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.handler.predicate.AfterRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BeforeRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BetweenRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.CookieRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.HeaderRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.HostRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.MethodRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.PathRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.QueryRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.RemoteAddrRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.WeightRoutePredicateFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.unit.DataSize;
import org.springframework.web.server.ServerWebExchange;

public class RouteProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(RouteProvider.class);
    protected final ServiceOps serviceOps;
    protected final ConfigurableApplicationContext ctx;
    protected final String anonymousUser;
    protected final String anonymousKey;
    protected final boolean useGZIPCompression;
    protected SyncopeClient client;
    protected final List<SRARouteTO> routeTOs = new ArrayList<SRARouteTO>();

    public RouteProvider(ServiceOps serviceOps, ConfigurableApplicationContext ctx, String anonymousUser, String anonymousKey, boolean useGZIPCompression) {
        this.serviceOps = serviceOps;
        this.ctx = ctx;
        this.anonymousUser = anonymousUser;
        this.anonymousKey = anonymousKey;
        this.useGZIPCompression = useGZIPCompression;
    }

    protected GatewayFilter toFilter(SRARouteTO route, SRARouteFilter gwfilter) throws ClassNotFoundException, NumberFormatException {
        GatewayFilter filter = switch (gwfilter.getFactory()) {
            case SRARouteFilterFactory.ADD_REQUEST_HEADER -> {
                String[] addRequestHeaderArgs = gwfilter.getArgs().split(",");
                yield ((AddRequestHeaderGatewayFilterFactory)this.ctx.getBean(AddRequestHeaderGatewayFilterFactory.class)).apply(c -> c.setName(addRequestHeaderArgs[0].trim()).setValue(addRequestHeaderArgs[1].trim()));
            }
            case SRARouteFilterFactory.ADD_REQUEST_PARAMETER -> {
                String[] addRequestParameterArgs = gwfilter.getArgs().split(",");
                yield ((AddRequestParameterGatewayFilterFactory)this.ctx.getBean(AddRequestParameterGatewayFilterFactory.class)).apply(c -> c.setName(addRequestParameterArgs[0].trim()).setValue(addRequestParameterArgs[1].trim()));
            }
            case SRARouteFilterFactory.ADD_RESPONSE_HEADER -> {
                String[] addResponseHeaderArgs = gwfilter.getArgs().split(",");
                yield ((AddResponseHeaderGatewayFilterFactory)this.ctx.getBean(AddResponseHeaderGatewayFilterFactory.class)).apply(c -> c.setName(addResponseHeaderArgs[0].trim()).setValue(addResponseHeaderArgs[1].trim()));
            }
            case SRARouteFilterFactory.DEDUPE_RESPONSE_HEADER -> {
                String[] dedupeResponseHeaderArgs = gwfilter.getArgs().split(",");
                yield ((DedupeResponseHeaderGatewayFilterFactory)this.ctx.getBean(DedupeResponseHeaderGatewayFilterFactory.class)).apply(c -> {
                    c.setName(dedupeResponseHeaderArgs[0].trim());
                    if (dedupeResponseHeaderArgs.length > 1) {
                        c.setStrategy(DedupeResponseHeaderGatewayFilterFactory.Strategy.valueOf((String)dedupeResponseHeaderArgs[1].trim()));
                    }
                });
            }
            case SRARouteFilterFactory.FALLBACK_HEADERS -> {
                String[] fallbackHeadersArgs = gwfilter.getArgs().split(",");
                yield ((FallbackHeadersGatewayFilterFactory)this.ctx.getBean(FallbackHeadersGatewayFilterFactory.class)).apply(c -> {
                    if (StringUtils.isNotBlank((CharSequence)fallbackHeadersArgs[0])) {
                        c.setExecutionExceptionTypeHeaderName(fallbackHeadersArgs[0].trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)fallbackHeadersArgs[1])) {
                        c.setExecutionExceptionMessageHeaderName(fallbackHeadersArgs[1].trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)fallbackHeadersArgs[2])) {
                        c.setRootCauseExceptionTypeHeaderName(fallbackHeadersArgs[2].trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)fallbackHeadersArgs[3])) {
                        c.setRootCauseExceptionMessageHeaderName(fallbackHeadersArgs[3].trim());
                    }
                });
            }
            case SRARouteFilterFactory.MAP_REQUEST_HEADER -> {
                String[] mapRequestHeaderArgs = gwfilter.getArgs().split(",");
                yield ((MapRequestHeaderGatewayFilterFactory)this.ctx.getBean(MapRequestHeaderGatewayFilterFactory.class)).apply(c -> c.setFromHeader(mapRequestHeaderArgs[0].trim()).setToHeader(mapRequestHeaderArgs[1].trim()));
            }
            case SRARouteFilterFactory.PREFIX_PATH -> ((PrefixPathGatewayFilterFactory)this.ctx.getBean(PrefixPathGatewayFilterFactory.class)).apply(c -> c.setPrefix(gwfilter.getArgs().trim()));
            case SRARouteFilterFactory.PRESERVE_HOST_HEADER -> ((PreserveHostHeaderGatewayFilterFactory)this.ctx.getBean(PreserveHostHeaderGatewayFilterFactory.class)).apply();
            case SRARouteFilterFactory.REDIRECT_TO -> {
                String[] redirectArgs = gwfilter.getArgs().split(",");
                yield ((RedirectToGatewayFilterFactory)this.ctx.getBean(RedirectToGatewayFilterFactory.class)).apply(redirectArgs[0].trim(), redirectArgs[1].trim());
            }
            case SRARouteFilterFactory.REMOVE_REQUEST_HEADER -> ((RemoveRequestHeaderGatewayFilterFactory)this.ctx.getBean(RemoveRequestHeaderGatewayFilterFactory.class)).apply(c -> c.setName(gwfilter.getArgs().trim()));
            case SRARouteFilterFactory.REMOVE_RESPONSE_HEADER -> ((RemoveResponseHeaderGatewayFilterFactory)this.ctx.getBean(RemoveResponseHeaderGatewayFilterFactory.class)).apply(c -> c.setName(gwfilter.getArgs().trim()));
            case SRARouteFilterFactory.REQUEST_RATE_LIMITER -> {
                String[] requestRateLimiterArgs = gwfilter.getArgs().split(",");
                yield ((RequestRateLimiterGatewayFilterFactory)this.ctx.getBean(RequestRateLimiterGatewayFilterFactory.class)).apply(c -> {
                    if (StringUtils.isNotBlank((CharSequence)requestRateLimiterArgs[0])) {
                        c.setDenyEmptyKey(Boolean.valueOf(BooleanUtils.toBoolean((String)requestRateLimiterArgs[0].trim())));
                    }
                    if (StringUtils.isNotBlank((CharSequence)requestRateLimiterArgs[1])) {
                        c.setEmptyKeyStatus(requestRateLimiterArgs[1].trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)requestRateLimiterArgs[2])) {
                        c.setKeyResolver((KeyResolver)this.ctx.getBean(requestRateLimiterArgs[2].trim(), KeyResolver.class));
                    }
                    if (StringUtils.isNotBlank((CharSequence)requestRateLimiterArgs[3])) {
                        c.setRateLimiter((RateLimiter)this.ctx.getBean(requestRateLimiterArgs[3].trim(), RateLimiter.class));
                    }
                    if (StringUtils.isNotBlank((CharSequence)requestRateLimiterArgs[4])) {
                        c.setStatusCode(HttpStatus.valueOf((String)requestRateLimiterArgs[4].trim()));
                    }
                });
            }
            case SRARouteFilterFactory.REWRITE_PATH -> {
                String[] rewritePathArgs = gwfilter.getArgs().split(",");
                yield ((RewritePathGatewayFilterFactory)this.ctx.getBean(RewritePathGatewayFilterFactory.class)).apply(c -> c.setRegexp(rewritePathArgs[0].trim()).setReplacement(rewritePathArgs[1].trim()));
            }
            case SRARouteFilterFactory.REWRITE_LOCATION -> {
                String[] rewriteLocationArgs = gwfilter.getArgs().split(",");
                yield ((RewriteLocationResponseHeaderGatewayFilterFactory)this.ctx.getBean(RewriteLocationResponseHeaderGatewayFilterFactory.class)).apply(c -> {
                    c.setStripVersion(RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.valueOf((String)rewriteLocationArgs[0].trim()));
                    if (rewriteLocationArgs.length > 1) {
                        c.setLocationHeaderName(rewriteLocationArgs[1].trim());
                    }
                    if (rewriteLocationArgs.length > 2) {
                        c.setHostValue(rewriteLocationArgs[2].trim());
                    }
                    if (rewriteLocationArgs.length > 3) {
                        c.setProtocols(rewriteLocationArgs[3].trim());
                    }
                });
            }
            case SRARouteFilterFactory.REWRITE_RESPONSE_HEADER -> {
                String[] rewriteResponseHeaderArgs = gwfilter.getArgs().split(",");
                yield ((RewriteResponseHeaderGatewayFilterFactory)this.ctx.getBean(RewriteResponseHeaderGatewayFilterFactory.class)).apply(c -> c.setReplacement(rewriteResponseHeaderArgs[2].trim()).setRegexp(rewriteResponseHeaderArgs[1].trim()).setName(rewriteResponseHeaderArgs[0].trim()));
            }
            case SRARouteFilterFactory.RETRY -> {
                AtomicInteger retries = new AtomicInteger();
                try {
                    retries.set(Integer.valueOf(gwfilter.getArgs().trim()));
                }
                catch (NumberFormatException e) {
                    LOG.error("Unexpected argument value: {}", (Object)gwfilter.getArgs().trim(), (Object)e);
                    retries.set(0);
                }
                yield ((RetryGatewayFilterFactory)this.ctx.getBean(RetryGatewayFilterFactory.class)).apply(c -> c.setRetries(retries.get()));
            }
            case SRARouteFilterFactory.SAVE_SESSION -> ((SaveSessionGatewayFilterFactory)this.ctx.getBean(SaveSessionGatewayFilterFactory.class)).apply(c -> {});
            case SRARouteFilterFactory.SECURE_HEADERS -> ((SecureHeadersGatewayFilterFactory)this.ctx.getBean(SecureHeadersGatewayFilterFactory.class)).apply(c -> {});
            case SRARouteFilterFactory.SET_PATH -> ((SetPathGatewayFilterFactory)this.ctx.getBean(SetPathGatewayFilterFactory.class)).apply(c -> c.setTemplate(gwfilter.getArgs().trim()));
            case SRARouteFilterFactory.SET_REQUEST_HEADER -> {
                String[] setRequestHeaderArgs = gwfilter.getArgs().split(",");
                yield ((SetRequestHeaderGatewayFilterFactory)this.ctx.getBean(SetRequestHeaderGatewayFilterFactory.class)).apply(c -> c.setName(setRequestHeaderArgs[0].trim()).setValue(setRequestHeaderArgs[1].trim()));
            }
            case SRARouteFilterFactory.SET_RESPONSE_HEADER -> {
                String[] setResponseHeaderArgs = gwfilter.getArgs().split(",");
                yield ((SetResponseHeaderGatewayFilterFactory)this.ctx.getBean(SetResponseHeaderGatewayFilterFactory.class)).apply(c -> c.setName(setResponseHeaderArgs[0].trim()).setValue(setResponseHeaderArgs[1].trim()));
            }
            case SRARouteFilterFactory.SET_STATUS -> ((SetStatusGatewayFilterFactory)this.ctx.getBean(SetStatusGatewayFilterFactory.class)).apply(c -> c.setStatus(gwfilter.getArgs().trim()));
            case SRARouteFilterFactory.STRIP_PREFIX -> {
                AtomicInteger parts = new AtomicInteger();
                try {
                    parts.set(Integer.valueOf(gwfilter.getArgs().trim()));
                }
                catch (NumberFormatException e) {
                    LOG.error("Unexpected argument value: {}", (Object)gwfilter.getArgs().trim(), (Object)e);
                    parts.set(0);
                }
                yield ((StripPrefixGatewayFilterFactory)this.ctx.getBean(StripPrefixGatewayFilterFactory.class)).apply(c -> c.setParts(parts.get()));
            }
            case SRARouteFilterFactory.REQUEST_HEADER_TO_REQUEST_URI -> ((RequestHeaderToRequestUriGatewayFilterFactory)this.ctx.getBean(RequestHeaderToRequestUriGatewayFilterFactory.class)).apply(c -> c.setName(gwfilter.getArgs().trim()));
            case SRARouteFilterFactory.SET_REQUEST_SIZE -> ((RequestSizeGatewayFilterFactory)this.ctx.getBean(RequestSizeGatewayFilterFactory.class)).apply(c -> c.setMaxSize(DataSize.ofBytes((long)Long.valueOf(gwfilter.getArgs().trim()))));
            case SRARouteFilterFactory.SET_REQUEST_HOST -> ((SetRequestHostHeaderGatewayFilterFactory)this.ctx.getBean(SetRequestHostHeaderGatewayFilterFactory.class)).apply(c -> c.setHost(gwfilter.getArgs().trim()));
            case SRARouteFilterFactory.LINK_REWRITE -> ApplicationContextUtils.getOrCreateBean(this.ctx, LinkRewriteGatewayFilterFactory.class.getName(), LinkRewriteGatewayFilterFactory.class).apply(c -> c.setData(route.getTarget().toASCIIString() + "," + gwfilter.getArgs().trim()));
            case SRARouteFilterFactory.CLIENT_CERTS_TO_REQUEST_HEADER -> {
                String header = StringUtils.isBlank((CharSequence)gwfilter.getArgs()) ? "X-Client-Certificate" : gwfilter.getArgs();
                yield ApplicationContextUtils.getOrCreateBean(this.ctx, ClientCertsToRequestHeaderFilterFactory.class.getName(), ClientCertsToRequestHeaderFilterFactory.class).apply(c -> c.setName(header.trim()));
            }
            case SRARouteFilterFactory.QUERY_PARAM_TO_REQUEST_HEADER -> ApplicationContextUtils.getOrCreateBean(this.ctx, QueryParamToRequestHeaderFilterFactory.class.getName(), QueryParamToRequestHeaderFilterFactory.class).apply(c -> c.setName(gwfilter.getArgs().trim()));
            case SRARouteFilterFactory.PRINCIPAL_TO_REQUEST_HEADER -> ApplicationContextUtils.getOrCreateBean(this.ctx, PrincipalToRequestHeaderFilterFactory.class.getName(), PrincipalToRequestHeaderFilterFactory.class).apply(c -> c.setName(gwfilter.getArgs().trim()));
            case SRARouteFilterFactory.CUSTOM -> {
                String[] customArgs = gwfilter.getArgs().split(";");
                Consumer<CustomGatewayFilterFactory.Config> customConsumer = customArgs.length > 1 ? c -> c.setData(customArgs[1]) : c -> c.setData(null);
                CustomGatewayFilterFactory factory = ApplicationContextUtils.getOrCreateBean(this.ctx, customArgs[0], CustomGatewayFilterFactory.class);
                yield factory.getOrder().map(order -> new OrderedGatewayFilter(factory.apply(customConsumer), order.intValue())).orElseGet(() -> factory.apply(customConsumer));
            }
            default -> null;
        };
        if (filter == null) {
            throw new IllegalArgumentException("Could not translate " + String.valueOf(gwfilter));
        }
        return filter instanceof Ordered ? filter : new OrderedGatewayFilter(filter, 0);
    }

    protected AsyncPredicate<ServerWebExchange> toPredicate(SRARoutePredicate gwpredicate, boolean negate) throws ClassNotFoundException, NumberFormatException {
        AsyncPredicate predicate = switch (gwpredicate.getFactory()) {
            case SRARoutePredicateFactory.AFTER -> ((AfterRoutePredicateFactory)this.ctx.getBean(AfterRoutePredicateFactory.class)).applyAsync(c -> c.setDatetime(ZonedDateTime.parse(gwpredicate.getArgs().trim())));
            case SRARoutePredicateFactory.BEFORE -> ((BeforeRoutePredicateFactory)this.ctx.getBean(BeforeRoutePredicateFactory.class)).applyAsync(c -> c.setDatetime(ZonedDateTime.parse(gwpredicate.getArgs().trim())));
            case SRARoutePredicateFactory.BETWEEN -> {
                String[] betweenArgs = gwpredicate.getArgs().split(",");
                yield ((BetweenRoutePredicateFactory)this.ctx.getBean(BetweenRoutePredicateFactory.class)).applyAsync(c -> c.setDatetime1(ZonedDateTime.parse(betweenArgs[0].trim())).setDatetime2(ZonedDateTime.parse(betweenArgs[1].trim())));
            }
            case SRARoutePredicateFactory.COOKIE -> {
                String[] cookieArgs = gwpredicate.getArgs().split(",");
                yield ((CookieRoutePredicateFactory)this.ctx.getBean(CookieRoutePredicateFactory.class)).applyAsync(c -> c.setName(cookieArgs[0].trim()).setRegexp(cookieArgs[1].trim()));
            }
            case SRARoutePredicateFactory.HEADER -> {
                String[] headerArgs = gwpredicate.getArgs().split(",");
                yield ((HeaderRoutePredicateFactory)this.ctx.getBean(HeaderRoutePredicateFactory.class)).applyAsync(c -> c.setHeader(headerArgs[0].trim()).setRegexp(headerArgs[1].trim()));
            }
            case SRARoutePredicateFactory.HOST -> {
                String[] hostArgs = gwpredicate.getArgs().split(",");
                yield ((HostRoutePredicateFactory)this.ctx.getBean(HostRoutePredicateFactory.class)).applyAsync(c -> c.setPatterns(List.of(hostArgs)));
            }
            case SRARoutePredicateFactory.METHOD -> {
                String[] methodArgs = gwpredicate.getArgs().split(",");
                yield ((MethodRoutePredicateFactory)this.ctx.getBean(MethodRoutePredicateFactory.class)).applyAsync(c -> c.setMethods((HttpMethod[])Stream.of(methodArgs).map(arg -> HttpMethod.valueOf((String)arg.trim())).toArray(HttpMethod[]::new)));
            }
            case SRARoutePredicateFactory.PATH -> {
                String[] pathArgs = gwpredicate.getArgs().split(",");
                yield ((PathRoutePredicateFactory)this.ctx.getBean(PathRoutePredicateFactory.class)).applyAsync(c -> c.setPatterns(List.of(pathArgs)));
            }
            case SRARoutePredicateFactory.QUERY -> {
                String[] queryArgs = gwpredicate.getArgs().split(",");
                Consumer<QueryRoutePredicateFactory.Config> queryConsumer = queryArgs.length > 1 ? c -> c.setParam(queryArgs[0].trim()).setRegexp(queryArgs[1].trim()) : c -> c.setParam(queryArgs[0].trim());
                yield ((QueryRoutePredicateFactory)this.ctx.getBean(QueryRoutePredicateFactory.class)).applyAsync(queryConsumer);
            }
            case SRARoutePredicateFactory.REMOTE_ADDR -> {
                String[] remoteAddrArgs = gwpredicate.getArgs().split(",");
                yield ((RemoteAddrRoutePredicateFactory)this.ctx.getBean(RemoteAddrRoutePredicateFactory.class)).applyAsync(c -> c.setSources(List.of(remoteAddrArgs)));
            }
            case SRARoutePredicateFactory.WEIGHT -> {
                String[] weigthArgs = gwpredicate.getArgs().split(",");
                AtomicInteger weight = new AtomicInteger();
                try {
                    weight.set(Integer.valueOf(weigthArgs[1].trim()));
                }
                catch (NumberFormatException e) {
                    LOG.error("Unexpected argument value: {}", (Object)weigthArgs[1].trim(), (Object)e);
                    weight.set(0);
                }
                yield ((WeightRoutePredicateFactory)this.ctx.getBean(WeightRoutePredicateFactory.class)).applyAsync(c -> c.setGroup(weigthArgs[0].trim()).setWeight(weight.get()));
            }
            case SRARoutePredicateFactory.CUSTOM -> {
                String[] customArgs = gwpredicate.getArgs().split(";");
                yield ApplicationContextUtils.getOrCreateBean(this.ctx, customArgs[0], CustomRoutePredicateFactory.class).applyAsync(c -> c.setData(customArgs[1]));
            }
            default -> null;
        };
        if (predicate == null) {
            throw new IllegalArgumentException("Could not translate predicate " + String.valueOf(gwpredicate));
        }
        return negate ? predicate.negate() : predicate;
    }

    protected Route.AsyncBuilder toRoute(SRARouteTO gwroute) {
        Route.AsyncBuilder builder = (Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)new Route.AsyncBuilder().id(gwroute.getKey())).order(gwroute.getOrder())).uri(gwroute.getTarget());
        if (gwroute.getPredicates().isEmpty()) {
            builder.predicate(exchange -> true);
        } else {
            gwroute.getPredicates().forEach(gwpredicate -> {
                if (builder.getPredicate() == null) {
                    try {
                        builder.asyncPredicate(this.toPredicate((SRARoutePredicate)gwpredicate, gwpredicate.isNegate()));
                    }
                    catch (Exception e) {
                        LOG.error("Could not translate {}, skipping", gwpredicate, (Object)e);
                    }
                } else {
                    try {
                        switch (gwpredicate.getCond()) {
                            case OR: {
                                builder.or(this.toPredicate((SRARoutePredicate)gwpredicate, gwpredicate.isNegate()));
                                break;
                            }
                            default: {
                                builder.and(this.toPredicate((SRARoutePredicate)gwpredicate, gwpredicate.isNegate()));
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Could not translate {}, skipping", gwpredicate, (Object)e);
                    }
                }
            });
        }
        if (!gwroute.getFilters().isEmpty()) {
            builder.filters(gwroute.getFilters().stream().map(gwfilter -> {
                try {
                    return this.toFilter(gwroute, (SRARouteFilter)gwfilter);
                }
                catch (Exception e) {
                    LOG.error("Could not translate {}, skipping", gwfilter, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).toList());
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Route.AsyncBuilder> fetch() {
        Object object = this;
        synchronized (object) {
            if (this.client == null) {
                try {
                    this.client = new SyncopeClientFactoryBean().setAddress(this.serviceOps.get(NetworkService.Type.CORE).getAddress()).setUseCompression(this.useGZIPCompression).create((AuthenticationHandler)new AnonymousAuthenticationHandler(this.anonymousUser, this.anonymousKey));
                }
                catch (Exception e) {
                    LOG.error("Could not init SyncopeClient", (Throwable)e);
                    return List.of();
                }
            }
        }
        object = this.routeTOs;
        synchronized (object) {
            this.routeTOs.clear();
            this.routeTOs.addAll(((SRARouteService)this.client.getService(SRARouteService.class)).list());
        }
        return this.routeTOs.stream().map(this::toRoute).toList();
    }

    public List<SRARouteTO> getRouteTOs() {
        return this.routeTOs;
    }
}

