/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.oauth2;

import java.util.Set;
import org.apache.syncope.sra.ApplicationContextUtils;
import org.apache.syncope.sra.SRAProperties;
import org.apache.syncope.sra.security.LogoutRouteMatcher;
import org.apache.syncope.sra.security.oauth2.OAuth2SessionRemovalServerLogoutHandler;
import org.apache.syncope.sra.security.oauth2.OidcClientInitiatedServerLogoutSuccessHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.DelegatingReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.client.InMemoryReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.oidc.authentication.OidcAuthorizationCodeReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.DefaultReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.web.server.AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.OAuth2AuthorizationRequestRedirectWebFilter;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationCodeAuthenticationTokenConverter;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.authentication.OAuth2LoginAuthenticationWebFilter;
import org.springframework.security.web.server.DelegatingServerAuthenticationEntryPoint;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.LogoutWebFilter;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.context.WebSessionServerSecurityContextRepository;
import org.springframework.security.web.server.util.matcher.MediaTypeServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

public final class OAuth2SecurityConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2SecurityConfigUtils.class);

    private static ReactiveAuthenticationManager authenticationManager(SRAProperties.AMType amType) {
        WebClientReactiveAuthorizationCodeTokenResponseClient client = new WebClientReactiveAuthorizationCodeTokenResponseClient();
        OAuth2LoginReactiveAuthenticationManager authenticationManager = new OAuth2LoginReactiveAuthenticationManager((ReactiveOAuth2AccessTokenResponseClient)client, (ReactiveOAuth2UserService)new DefaultReactiveOAuth2UserService());
        if (SRAProperties.AMType.OIDC == amType) {
            OidcAuthorizationCodeReactiveAuthenticationManager oidc = new OidcAuthorizationCodeReactiveAuthenticationManager((ReactiveOAuth2AccessTokenResponseClient)client, (ReactiveOAuth2UserService)new OidcReactiveOAuth2UserService());
            authenticationManager = new DelegatingReactiveAuthenticationManager(new ReactiveAuthenticationManager[]{oidc, authenticationManager});
        }
        return authenticationManager;
    }

    public static void forLogin(ServerHttpSecurity http, SRAProperties.AMType amType, ApplicationContext ctx) {
        ReactiveClientRegistrationRepository clientRegistrationRepository = (ReactiveClientRegistrationRepository)ctx.getBean(ReactiveClientRegistrationRepository.class);
        InMemoryReactiveOAuth2AuthorizedClientService authorizedClientService = new InMemoryReactiveOAuth2AuthorizedClientService(clientRegistrationRepository);
        AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository authorizedClientRepository = new AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository((ReactiveOAuth2AuthorizedClientService)authorizedClientService);
        OAuth2AuthorizationRequestRedirectWebFilter authRequestRedirectFilter = new OAuth2AuthorizationRequestRedirectWebFilter(clientRegistrationRepository);
        http.addFilterAt((WebFilter)authRequestRedirectFilter, SecurityWebFiltersOrder.HTTP_BASIC);
        OAuth2LoginAuthenticationWebFilter authenticationFilter = new OAuth2LoginAuthenticationWebFilter(OAuth2SecurityConfigUtils.authenticationManager(amType), (ServerOAuth2AuthorizedClientRepository)authorizedClientRepository);
        authenticationFilter.setRequiresAuthenticationMatcher((ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher("/login/oauth2/code/{registrationId}"));
        authenticationFilter.setServerAuthenticationConverter((ServerAuthenticationConverter)new ServerOAuth2AuthorizationCodeAuthenticationTokenConverter(clientRegistrationRepository));
        authenticationFilter.setAuthenticationSuccessHandler((ServerAuthenticationSuccessHandler)new RedirectServerAuthenticationSuccessHandler());
        authenticationFilter.setAuthenticationFailureHandler((exchange, ex) -> Mono.error((Throwable)ex));
        authenticationFilter.setSecurityContextRepository((ServerSecurityContextRepository)new WebSessionServerSecurityContextRepository());
        http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.AUTHENTICATION);
        MediaTypeServerWebExchangeMatcher htmlMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.TEXT_HTML});
        htmlMatcher.setIgnoredMediaTypes(Set.of(MediaType.ALL));
        RedirectServerAuthenticationEntryPoint entrypoint = new RedirectServerAuthenticationEntryPoint("/oauth2/authorization/" + amType.name());
        http.exceptionHandling().authenticationEntryPoint(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)htmlMatcher, (ServerAuthenticationEntryPoint)entrypoint).getEntryPoint());
    }

    public static void forLogout(ServerHttpSecurity.AuthorizeExchangeSpec builder, SRAProperties.AMType amType, CacheManager cacheManager, LogoutRouteMatcher logoutRouteMatcher, ConfigurableApplicationContext ctx) {
        LogoutWebFilter logoutWebFilter = new LogoutWebFilter();
        logoutWebFilter.setRequiresLogoutMatcher((ServerWebExchangeMatcher)logoutRouteMatcher);
        logoutWebFilter.setLogoutHandler((ServerLogoutHandler)new OAuth2SessionRemovalServerLogoutHandler(cacheManager));
        if (SRAProperties.AMType.OIDC == amType) {
            try {
                OidcClientInitiatedServerLogoutSuccessHandler handler = ApplicationContextUtils.getOrCreateBean(ctx, OidcClientInitiatedServerLogoutSuccessHandler.class.getName(), OidcClientInitiatedServerLogoutSuccessHandler.class);
                logoutWebFilter.setLogoutSuccessHandler((ServerLogoutSuccessHandler)handler);
            }
            catch (ClassNotFoundException e) {
                LOG.error("While creating instance of {}", (Object)OidcClientInitiatedServerLogoutSuccessHandler.class.getName(), (Object)e);
            }
        }
        builder.and().logout().disable().addFilterAt((WebFilter)logoutWebFilter, SecurityWebFiltersOrder.LOGOUT);
    }

    private OAuth2SecurityConfigUtils() {
    }
}

