/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.cas;

import org.jasig.cas.client.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class CASUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CASUtils.class);

    public static Mono<String> safeGetParameter(ServerWebExchange exchange, String parameter) {
        if (exchange.getRequest().getMethod() == HttpMethod.POST) {
            LOG.debug("safeGetParameter called on a POST ServerHttpRequest for Restricted Parameters. Cannot complete check safely. Reverting to standard behavior for this Parameter");
            return exchange.getFormData().flatMap(form -> Mono.justOrEmpty((Object)((String)form.getFirst((Object)parameter))));
        }
        return Mono.justOrEmpty((Object)((String)exchange.getRequest().getQueryParams().getFirst((Object)parameter)));
    }

    public static Mono<String> retrieveTicketFromRequest(ServerWebExchange exchange, Protocol protocol) {
        return CASUtils.safeGetParameter(exchange, protocol.getArtifactParameterName());
    }

    public static ServerWebExchangeMatcher ticketAvailable(Protocol protocol) {
        return exchange -> CASUtils.retrieveTicketFromRequest(exchange, protocol).flatMap(ticket -> ServerWebExchangeMatcher.MatchResult.match()).switchIfEmpty(ServerWebExchangeMatcher.MatchResult.notMatch());
    }

    public static String constructServiceUrl(ServerWebExchange exchange, Protocol protocol) {
        return UriComponentsBuilder.fromHttpRequest((HttpRequest)exchange.getRequest()).replaceQueryParam(protocol.getArtifactParameterName(), new Object[0]).build().toUriString();
    }

    private CASUtils() {
    }
}

