/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.session;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.session.MapSession;
import org.springframework.session.ReactiveSessionRepository;
import reactor.core.publisher.Mono;

public class CacheManagerReactiveSessionRepository
implements ReactiveSessionRepository<MapSession> {
    @Autowired
    private CacheManager cacheManager;

    public Mono<MapSession> createSession() {
        return Mono.just((Object)new MapSession());
    }

    public Mono<Void> save(MapSession session) {
        return Mono.fromRunnable(() -> {
            if (!session.getId().equals(session.getOriginalId())) {
                this.cacheManager.getCache("default").evictIfPresent((Object)session.getOriginalId());
            }
            this.cacheManager.getCache("default").put((Object)session.getId(), (Object)session);
        });
    }

    public Mono<MapSession> findById(String id) {
        return Mono.defer(() -> Mono.justOrEmpty((Object)((MapSession)this.cacheManager.getCache("default").get((Object)id, MapSession.class))).map(MapSession::new).switchIfEmpty(this.deleteById(id).then(Mono.empty())));
    }

    public Mono<Void> deleteById(String id) {
        return Mono.fromRunnable(() -> this.cacheManager.getCache("default").evictIfPresent((Object)id));
    }
}

