/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.cas;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.sra.security.web.server.DoNothingIfCommittedServerRedirectStrategy;
import org.springframework.cache.CacheManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import reactor.core.publisher.Mono;

public class CASServerLogoutHandler
implements ServerLogoutHandler {
    private final ServerRedirectStrategy redirectStrategy = new DoNothingIfCommittedServerRedirectStrategy();
    private final CacheManager cacheManager;
    private final String casServerLogoutUrl;

    public CASServerLogoutHandler(CacheManager cacheManager, String casServerUrlPrefix) {
        this.cacheManager = cacheManager;
        this.casServerLogoutUrl = StringUtils.appendIfMissing((String)casServerUrlPrefix, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "logout";
    }

    public Mono<Void> logout(WebFilterExchange exchange, Authentication authentication) {
        return exchange.getExchange().getSession().flatMap(session -> {
            this.cacheManager.getCache("default").evictIfPresent((Object)session.getId());
            return session.invalidate().then(this.redirectStrategy.sendRedirect(exchange.getExchange(), URI.create(this.casServerLogoutUrl)));
        }).onErrorResume(Mono::error);
    }
}

