/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.filters;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.session.Session;
import reactor.core.publisher.Mono;

public class PrincipalToRequestHeaderFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    @Autowired
    private CacheManager cacheManager;

    public PrincipalToRequestHeaderFilterFactory() {
        super(AbstractGatewayFilterFactory.NameConfig.class);
    }

    public GatewayFilter apply(AbstractGatewayFilterFactory.NameConfig config) {
        return (exchange, chain) -> exchange.getSession().flatMap(session -> Mono.justOrEmpty(Optional.ofNullable((Session)this.cacheManager.getCache("default").get((Object)session.getId(), Session.class)).map(cachedSession -> {
            String principal = null;
            SecurityContext ctx = (SecurityContext)cachedSession.getAttribute("SPRING_SECURITY_CONTEXT");
            if (ctx != null && ctx.getAuthentication() != null) {
                principal = ctx.getAuthentication().getPrincipal() instanceof OidcUser ? ((OidcUser)ctx.getAuthentication().getPrincipal()).getIdToken().getTokenValue() : (ctx.getAuthentication().getPrincipal() instanceof OAuth2User ? Objects.toString(((OAuth2User)ctx.getAuthentication().getPrincipal()).getAttributes().get("preferred_username"), null) : ctx.getAuthentication().getName());
            }
            return principal;
        }))).transform(principal -> principal.flatMap(p -> StringUtils.isEmpty((CharSequence)p) ? chain.filter(exchange) : chain.filter(exchange.mutate().request(exchange.getRequest().mutate().headers(headers -> headers.add(config.getName(), p)).build()).build()))).switchIfEmpty(chain.filter(exchange));
    }
}

