/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra;

import java.util.List;
import org.apache.syncope.sra.session.CacheManagerReactiveSessionRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.MapSession;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.config.annotation.web.server.EnableSpringWebSession;

@Configuration(proxyBeanMethods=false)
@EnableCaching
@EnableSpringWebSession
public class SessionConfig {
    public static final String DEFAULT_CACHE = "default";

    @ConditionalOnMissingBean
    @Bean
    public ReactiveSessionRepository<MapSession> reactiveSessionRepository() {
        return new CacheManagerReactiveSessionRepository();
    }

    @ConditionalOnMissingBean
    @Bean
    public CacheManager cacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(List.of(new ConcurrentMapCache(DEFAULT_CACHE)));
        return cacheManager;
    }
}

