/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.to.SRARouteTO;
import org.apache.syncope.common.lib.types.SRARouteFilter;
import org.apache.syncope.common.lib.types.SRARoutePredicate;
import org.apache.syncope.common.rest.api.service.SRARouteService;
import org.apache.syncope.sra.ApplicationContextUtils;
import org.apache.syncope.sra.filters.ClientCertsToRequestHeaderFilterFactory;
import org.apache.syncope.sra.filters.CustomGatewayFilterFactory;
import org.apache.syncope.sra.filters.LinkRewriteGatewayFilterFactory;
import org.apache.syncope.sra.filters.PrincipalToRequestHeaderFilterFactory;
import org.apache.syncope.sra.filters.QueryParamToRequestHeaderFilterFactory;
import org.apache.syncope.sra.predicates.CustomRoutePredicateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AddRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddRequestParameterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.DedupeResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.FallbackHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.MapRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.PrefixPathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.PreserveHostHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RedirectToGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestHeaderToRequestUriGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestRateLimiterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestSizeGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RetryGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewriteLocationResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewritePathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewriteResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SaveSessionGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetPathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetRequestHostHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetStatusGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.StripPrefixGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.ratelimit.KeyResolver;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.handler.predicate.AfterRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BeforeRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BetweenRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.CookieRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.HeaderRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.HostRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.MethodRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.PathRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.QueryRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.RemoteAddrRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.WeightRoutePredicateFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.unit.DataSize;
import org.springframework.web.server.ServerWebExchange;

public class RouteProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(RouteProvider.class);
    protected final ServiceOps serviceOps;
    protected final ConfigurableApplicationContext ctx;
    protected final String anonymousUser;
    protected final String anonymousKey;
    protected final boolean useGZIPCompression;
    protected SyncopeClient client;
    protected final List<SRARouteTO> routeTOs = new ArrayList<SRARouteTO>();

    public RouteProvider(ServiceOps serviceOps, ConfigurableApplicationContext ctx, String anonymousUser, String anonymousKey, boolean useGZIPCompression) {
        this.serviceOps = serviceOps;
        this.ctx = ctx;
        this.anonymousUser = anonymousUser;
        this.anonymousKey = anonymousKey;
        this.useGZIPCompression = useGZIPCompression;
    }

    protected GatewayFilter toFilter(SRARouteTO route, SRARouteFilter gwfilter) throws ClassNotFoundException, NumberFormatException {
        GatewayFilter filter;
        switch (gwfilter.getFactory()) {
            case ADD_REQUEST_HEADER: {
                String[] addRequestHeaderArgs = gwfilter.getArgs().split(",");
                filter = ((AddRequestHeaderGatewayFilterFactory)this.ctx.getBean(AddRequestHeaderGatewayFilterFactory.class)).apply(c -> c.setName(addRequestHeaderArgs[0].trim()).setValue(addRequestHeaderArgs[1].trim()));
                break;
            }
            case ADD_REQUEST_PARAMETER: {
                String[] addRequestParameterArgs = gwfilter.getArgs().split(",");
                filter = ((AddRequestParameterGatewayFilterFactory)this.ctx.getBean(AddRequestParameterGatewayFilterFactory.class)).apply(c -> c.setName(addRequestParameterArgs[0].trim()).setValue(addRequestParameterArgs[1].trim()));
                break;
            }
            case ADD_RESPONSE_HEADER: {
                String[] addResponseHeaderArgs = gwfilter.getArgs().split(",");
                filter = ((AddResponseHeaderGatewayFilterFactory)this.ctx.getBean(AddResponseHeaderGatewayFilterFactory.class)).apply(c -> c.setName(addResponseHeaderArgs[0].trim()).setValue(addResponseHeaderArgs[1].trim()));
                break;
            }
            case DEDUPE_RESPONSE_HEADER: {
                String[] dedupeResponseHeaderArgs = gwfilter.getArgs().split(",");
                filter = ((DedupeResponseHeaderGatewayFilterFactory)this.ctx.getBean(DedupeResponseHeaderGatewayFilterFactory.class)).apply(c -> {
                    c.setName(dedupeResponseHeaderArgs[0].trim());
                    if (dedupeResponseHeaderArgs.length > 1) {
                        c.setStrategy(DedupeResponseHeaderGatewayFilterFactory.Strategy.valueOf((String)dedupeResponseHeaderArgs[1].trim()));
                    }
                });
                break;
            }
            case FALLBACK_HEADERS: {
                String[] fallbackHeadersArgs = gwfilter.getArgs().split(",");
                filter = ((FallbackHeadersGatewayFilterFactory)this.ctx.getBean(FallbackHeadersGatewayFilterFactory.class)).apply(c -> {
                    if (StringUtils.isNotBlank((CharSequence)fallbackHeadersArgs[0])) {
                        c.setExecutionExceptionTypeHeaderName(fallbackHeadersArgs[0].trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)fallbackHeadersArgs[1])) {
                        c.setExecutionExceptionMessageHeaderName(fallbackHeadersArgs[1].trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)fallbackHeadersArgs[2])) {
                        c.setRootCauseExceptionTypeHeaderName(fallbackHeadersArgs[2].trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)fallbackHeadersArgs[3])) {
                        c.setRootCauseExceptionMessageHeaderName(fallbackHeadersArgs[3].trim());
                    }
                });
                break;
            }
            case MAP_REQUEST_HEADER: {
                String[] mapRequestHeaderArgs = gwfilter.getArgs().split(",");
                filter = ((MapRequestHeaderGatewayFilterFactory)this.ctx.getBean(MapRequestHeaderGatewayFilterFactory.class)).apply(c -> c.setFromHeader(mapRequestHeaderArgs[0].trim()).setToHeader(mapRequestHeaderArgs[1].trim()));
                break;
            }
            case PREFIX_PATH: {
                filter = ((PrefixPathGatewayFilterFactory)this.ctx.getBean(PrefixPathGatewayFilterFactory.class)).apply(c -> c.setPrefix(gwfilter.getArgs().trim()));
                break;
            }
            case PRESERVE_HOST_HEADER: {
                filter = ((PreserveHostHeaderGatewayFilterFactory)this.ctx.getBean(PreserveHostHeaderGatewayFilterFactory.class)).apply();
                break;
            }
            case REDIRECT_TO: {
                String[] redirectArgs = gwfilter.getArgs().split(",");
                filter = ((RedirectToGatewayFilterFactory)this.ctx.getBean(RedirectToGatewayFilterFactory.class)).apply(redirectArgs[0].trim(), redirectArgs[1].trim());
                break;
            }
            case REMOVE_REQUEST_HEADER: {
                filter = ((RemoveRequestHeaderGatewayFilterFactory)this.ctx.getBean(RemoveRequestHeaderGatewayFilterFactory.class)).apply(c -> c.setName(gwfilter.getArgs().trim()));
                break;
            }
            case REMOVE_RESPONSE_HEADER: {
                filter = ((RemoveResponseHeaderGatewayFilterFactory)this.ctx.getBean(RemoveResponseHeaderGatewayFilterFactory.class)).apply(c -> c.setName(gwfilter.getArgs().trim()));
                break;
            }
            case REQUEST_RATE_LIMITER: {
                String[] requestRateLimiterArgs = gwfilter.getArgs().split(",");
                filter = ((RequestRateLimiterGatewayFilterFactory)this.ctx.getBean(RequestRateLimiterGatewayFilterFactory.class)).apply(c -> {
                    if (StringUtils.isNotBlank((CharSequence)requestRateLimiterArgs[0])) {
                        c.setDenyEmptyKey(Boolean.valueOf(BooleanUtils.toBoolean((String)requestRateLimiterArgs[0].trim())));
                    }
                    if (StringUtils.isNotBlank((CharSequence)requestRateLimiterArgs[1])) {
                        c.setEmptyKeyStatus(requestRateLimiterArgs[1].trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)requestRateLimiterArgs[2])) {
                        c.setKeyResolver((KeyResolver)this.ctx.getBean(requestRateLimiterArgs[2].trim(), KeyResolver.class));
                    }
                    if (StringUtils.isNotBlank((CharSequence)requestRateLimiterArgs[3])) {
                        c.setRateLimiter((RateLimiter)this.ctx.getBean(requestRateLimiterArgs[3].trim(), RateLimiter.class));
                    }
                    if (StringUtils.isNotBlank((CharSequence)requestRateLimiterArgs[4])) {
                        c.setStatusCode(HttpStatus.valueOf((String)requestRateLimiterArgs[4].trim()));
                    }
                });
                break;
            }
            case REWRITE_PATH: {
                String[] rewritePathArgs = gwfilter.getArgs().split(",");
                filter = ((RewritePathGatewayFilterFactory)this.ctx.getBean(RewritePathGatewayFilterFactory.class)).apply(c -> c.setRegexp(rewritePathArgs[0].trim()).setReplacement(rewritePathArgs[1].trim()));
                break;
            }
            case REWRITE_LOCATION: {
                String[] rewriteLocationArgs = gwfilter.getArgs().split(",");
                filter = ((RewriteLocationResponseHeaderGatewayFilterFactory)this.ctx.getBean(RewriteLocationResponseHeaderGatewayFilterFactory.class)).apply(c -> {
                    c.setStripVersion(RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.valueOf((String)rewriteLocationArgs[0].trim()));
                    if (rewriteLocationArgs.length > 1) {
                        c.setLocationHeaderName(rewriteLocationArgs[1].trim());
                    }
                    if (rewriteLocationArgs.length > 2) {
                        c.setHostValue(rewriteLocationArgs[2].trim());
                    }
                    if (rewriteLocationArgs.length > 3) {
                        c.setProtocols(rewriteLocationArgs[3].trim());
                    }
                });
                break;
            }
            case REWRITE_RESPONSE_HEADER: {
                String[] rewriteResponseHeaderArgs = gwfilter.getArgs().split(",");
                filter = ((RewriteResponseHeaderGatewayFilterFactory)this.ctx.getBean(RewriteResponseHeaderGatewayFilterFactory.class)).apply(c -> c.setReplacement(rewriteResponseHeaderArgs[2].trim()).setRegexp(rewriteResponseHeaderArgs[1].trim()).setName(rewriteResponseHeaderArgs[0].trim()));
                break;
            }
            case RETRY: {
                AtomicInteger retries = new AtomicInteger();
                try {
                    retries.set(Integer.valueOf(gwfilter.getArgs().trim()));
                }
                catch (NumberFormatException e) {
                    LOG.error("Unexpected argument value: {}", (Object)gwfilter.getArgs().trim(), (Object)e);
                    retries.set(0);
                }
                filter = ((RetryGatewayFilterFactory)this.ctx.getBean(RetryGatewayFilterFactory.class)).apply(c -> c.setRetries(retries.get()));
                break;
            }
            case SAVE_SESSION: {
                filter = ((SaveSessionGatewayFilterFactory)this.ctx.getBean(SaveSessionGatewayFilterFactory.class)).apply(c -> {});
                break;
            }
            case SECURE_HEADERS: {
                filter = ((SecureHeadersGatewayFilterFactory)this.ctx.getBean(SecureHeadersGatewayFilterFactory.class)).apply(c -> {});
                break;
            }
            case SET_PATH: {
                filter = ((SetPathGatewayFilterFactory)this.ctx.getBean(SetPathGatewayFilterFactory.class)).apply(c -> c.setTemplate(gwfilter.getArgs().trim()));
                break;
            }
            case SET_REQUEST_HEADER: {
                String[] setRequestHeaderArgs = gwfilter.getArgs().split(",");
                filter = ((SetRequestHeaderGatewayFilterFactory)this.ctx.getBean(SetRequestHeaderGatewayFilterFactory.class)).apply(c -> c.setName(setRequestHeaderArgs[0].trim()).setValue(setRequestHeaderArgs[1].trim()));
                break;
            }
            case SET_RESPONSE_HEADER: {
                String[] setResponseHeaderArgs = gwfilter.getArgs().split(",");
                filter = ((SetResponseHeaderGatewayFilterFactory)this.ctx.getBean(SetResponseHeaderGatewayFilterFactory.class)).apply(c -> c.setName(setResponseHeaderArgs[0].trim()).setValue(setResponseHeaderArgs[1].trim()));
                break;
            }
            case SET_STATUS: {
                filter = ((SetStatusGatewayFilterFactory)this.ctx.getBean(SetStatusGatewayFilterFactory.class)).apply(c -> c.setStatus(gwfilter.getArgs().trim()));
                break;
            }
            case STRIP_PREFIX: {
                AtomicInteger parts = new AtomicInteger();
                try {
                    parts.set(Integer.valueOf(gwfilter.getArgs().trim()));
                }
                catch (NumberFormatException e) {
                    LOG.error("Unexpected argument value: {}", (Object)gwfilter.getArgs().trim(), (Object)e);
                    parts.set(0);
                }
                filter = ((StripPrefixGatewayFilterFactory)this.ctx.getBean(StripPrefixGatewayFilterFactory.class)).apply(c -> c.setParts(parts.get()));
                break;
            }
            case REQUEST_HEADER_TO_REQUEST_URI: {
                filter = ((RequestHeaderToRequestUriGatewayFilterFactory)this.ctx.getBean(RequestHeaderToRequestUriGatewayFilterFactory.class)).apply(c -> c.setName(gwfilter.getArgs().trim()));
                break;
            }
            case SET_REQUEST_SIZE: {
                filter = ((RequestSizeGatewayFilterFactory)this.ctx.getBean(RequestSizeGatewayFilterFactory.class)).apply(c -> c.setMaxSize(DataSize.ofBytes((long)Long.valueOf(gwfilter.getArgs().trim()))));
                break;
            }
            case SET_REQUEST_HOST: {
                filter = ((SetRequestHostHeaderGatewayFilterFactory)this.ctx.getBean(SetRequestHostHeaderGatewayFilterFactory.class)).apply(c -> c.setHost(gwfilter.getArgs().trim()));
                break;
            }
            case LINK_REWRITE: {
                filter = ApplicationContextUtils.getOrCreateBean(this.ctx, LinkRewriteGatewayFilterFactory.class.getName(), LinkRewriteGatewayFilterFactory.class).apply(c -> c.setData(route.getTarget().toASCIIString() + "," + gwfilter.getArgs().trim()));
                break;
            }
            case CLIENT_CERTS_TO_REQUEST_HEADER: {
                String header = StringUtils.isBlank((CharSequence)gwfilter.getArgs()) ? "X-Client-Certificate" : gwfilter.getArgs();
                filter = ApplicationContextUtils.getOrCreateBean(this.ctx, ClientCertsToRequestHeaderFilterFactory.class.getName(), ClientCertsToRequestHeaderFilterFactory.class).apply(c -> c.setName(header.trim()));
                break;
            }
            case QUERY_PARAM_TO_REQUEST_HEADER: {
                filter = ApplicationContextUtils.getOrCreateBean(this.ctx, QueryParamToRequestHeaderFilterFactory.class.getName(), QueryParamToRequestHeaderFilterFactory.class).apply(c -> c.setName(gwfilter.getArgs().trim()));
                break;
            }
            case PRINCIPAL_TO_REQUEST_HEADER: {
                filter = ApplicationContextUtils.getOrCreateBean(this.ctx, PrincipalToRequestHeaderFilterFactory.class.getName(), PrincipalToRequestHeaderFilterFactory.class).apply(c -> c.setName(gwfilter.getArgs().trim()));
                break;
            }
            case CUSTOM: {
                String[] customArgs = gwfilter.getArgs().split(";");
                Consumer<CustomGatewayFilterFactory.Config> customConsumer = customArgs.length > 1 ? c -> c.setData(customArgs[1]) : c -> c.setData(null);
                CustomGatewayFilterFactory factory = ApplicationContextUtils.getOrCreateBean(this.ctx, customArgs[0], CustomGatewayFilterFactory.class);
                filter = factory.getOrder().map(order -> new OrderedGatewayFilter(factory.apply(customConsumer), order.intValue())).orElseGet(() -> factory.apply(customConsumer));
                break;
            }
            default: {
                filter = null;
            }
        }
        if (filter == null) {
            throw new IllegalArgumentException("Could not translate " + String.valueOf(gwfilter));
        }
        return filter instanceof Ordered ? filter : new OrderedGatewayFilter(filter, 0);
    }

    protected AsyncPredicate<ServerWebExchange> toPredicate(SRARoutePredicate gwpredicate, boolean negate) throws ClassNotFoundException, NumberFormatException {
        AsyncPredicate predicate;
        switch (gwpredicate.getFactory()) {
            case AFTER: {
                predicate = ((AfterRoutePredicateFactory)this.ctx.getBean(AfterRoutePredicateFactory.class)).applyAsync(c -> c.setDatetime(ZonedDateTime.parse(gwpredicate.getArgs().trim())));
                break;
            }
            case BEFORE: {
                predicate = ((BeforeRoutePredicateFactory)this.ctx.getBean(BeforeRoutePredicateFactory.class)).applyAsync(c -> c.setDatetime(ZonedDateTime.parse(gwpredicate.getArgs().trim())));
                break;
            }
            case BETWEEN: {
                String[] betweenArgs = gwpredicate.getArgs().split(",");
                predicate = ((BetweenRoutePredicateFactory)this.ctx.getBean(BetweenRoutePredicateFactory.class)).applyAsync(c -> c.setDatetime1(ZonedDateTime.parse(betweenArgs[0].trim())).setDatetime2(ZonedDateTime.parse(betweenArgs[1].trim())));
                break;
            }
            case COOKIE: {
                String[] cookieArgs = gwpredicate.getArgs().split(",");
                predicate = ((CookieRoutePredicateFactory)this.ctx.getBean(CookieRoutePredicateFactory.class)).applyAsync(c -> c.setName(cookieArgs[0].trim()).setRegexp(cookieArgs[1].trim()));
                break;
            }
            case HEADER: {
                String[] headerArgs = gwpredicate.getArgs().split(",");
                predicate = ((HeaderRoutePredicateFactory)this.ctx.getBean(HeaderRoutePredicateFactory.class)).applyAsync(c -> c.setHeader(headerArgs[0].trim()).setRegexp(headerArgs[1].trim()));
                break;
            }
            case HOST: {
                String[] hostArgs = gwpredicate.getArgs().split(",");
                predicate = ((HostRoutePredicateFactory)this.ctx.getBean(HostRoutePredicateFactory.class)).applyAsync(c -> c.setPatterns(List.of(hostArgs)));
                break;
            }
            case METHOD: {
                String[] methodArgs = gwpredicate.getArgs().split(",");
                predicate = ((MethodRoutePredicateFactory)this.ctx.getBean(MethodRoutePredicateFactory.class)).applyAsync(c -> c.setMethods((HttpMethod[])Stream.of(methodArgs).map(arg -> HttpMethod.resolve((String)arg.trim())).toArray(HttpMethod[]::new)));
                break;
            }
            case PATH: {
                String[] pathArgs = gwpredicate.getArgs().split(",");
                predicate = ((PathRoutePredicateFactory)this.ctx.getBean(PathRoutePredicateFactory.class)).applyAsync(c -> c.setPatterns(List.of(pathArgs)));
                break;
            }
            case QUERY: {
                String[] queryArgs = gwpredicate.getArgs().split(",");
                Consumer<QueryRoutePredicateFactory.Config> queryConsumer = queryArgs.length > 1 ? c -> c.setParam(queryArgs[0].trim()).setRegexp(queryArgs[1].trim()) : c -> c.setParam(queryArgs[0].trim());
                predicate = ((QueryRoutePredicateFactory)this.ctx.getBean(QueryRoutePredicateFactory.class)).applyAsync(queryConsumer);
                break;
            }
            case REMOTE_ADDR: {
                String[] remoteAddrArgs = gwpredicate.getArgs().split(",");
                predicate = ((RemoteAddrRoutePredicateFactory)this.ctx.getBean(RemoteAddrRoutePredicateFactory.class)).applyAsync(c -> c.setSources(List.of(remoteAddrArgs)));
                break;
            }
            case WEIGHT: {
                String[] weigthArgs = gwpredicate.getArgs().split(",");
                AtomicInteger weight = new AtomicInteger();
                try {
                    weight.set(Integer.valueOf(weigthArgs[1].trim()));
                }
                catch (NumberFormatException e) {
                    LOG.error("Unexpected argument value: {}", (Object)weigthArgs[1].trim(), (Object)e);
                    weight.set(0);
                }
                predicate = ((WeightRoutePredicateFactory)this.ctx.getBean(WeightRoutePredicateFactory.class)).applyAsync(c -> c.setGroup(weigthArgs[0].trim()).setWeight(weight.get()));
                break;
            }
            case CUSTOM: {
                String[] customArgs = gwpredicate.getArgs().split(";");
                predicate = ApplicationContextUtils.getOrCreateBean(this.ctx, customArgs[0], CustomRoutePredicateFactory.class).applyAsync(c -> c.setData(customArgs[1]));
                break;
            }
            default: {
                predicate = null;
            }
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Could not translate predicate " + String.valueOf(gwpredicate));
        }
        return negate ? predicate.negate() : predicate;
    }

    protected Route.AsyncBuilder toRoute(SRARouteTO gwroute) {
        Route.AsyncBuilder builder = (Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)new Route.AsyncBuilder().id(gwroute.getKey())).order(gwroute.getOrder())).uri(gwroute.getTarget());
        if (gwroute.getPredicates().isEmpty()) {
            builder.predicate(exchange -> true);
        } else {
            gwroute.getPredicates().forEach(gwpredicate -> {
                if (builder.getPredicate() == null) {
                    try {
                        builder.asyncPredicate(this.toPredicate((SRARoutePredicate)gwpredicate, gwpredicate.isNegate()));
                    }
                    catch (Exception e) {
                        LOG.error("Could not translate {}, skipping", gwpredicate, (Object)e);
                    }
                } else {
                    try {
                        switch (gwpredicate.getCond()) {
                            case OR: {
                                builder.or(this.toPredicate((SRARoutePredicate)gwpredicate, gwpredicate.isNegate()));
                                break;
                            }
                            default: {
                                builder.and(this.toPredicate((SRARoutePredicate)gwpredicate, gwpredicate.isNegate()));
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Could not translate {}, skipping", gwpredicate, (Object)e);
                    }
                }
            });
        }
        if (!gwroute.getFilters().isEmpty()) {
            builder.filters((Collection)gwroute.getFilters().stream().map(gwfilter -> {
                try {
                    return this.toFilter(gwroute, (SRARouteFilter)gwfilter);
                }
                catch (Exception e) {
                    LOG.error("Could not translate {}, skipping", gwfilter, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Route.AsyncBuilder> fetch() {
        Object object = this;
        synchronized (object) {
            if (this.client == null) {
                try {
                    this.client = new SyncopeClientFactoryBean().setAddress(this.serviceOps.get(NetworkService.Type.CORE).getAddress()).setUseCompression(this.useGZIPCompression).create((AuthenticationHandler)new AnonymousAuthenticationHandler(this.anonymousUser, this.anonymousKey));
                }
                catch (Exception e) {
                    LOG.error("Could not init SyncopeClient", (Throwable)e);
                    return List.of();
                }
            }
        }
        object = this.routeTOs;
        synchronized (object) {
            this.routeTOs.clear();
            this.routeTOs.addAll(((SRARouteService)this.client.getService(SRARouteService.class)).list());
        }
        return this.routeTOs.stream().map(this::toRoute).collect(Collectors.toList());
    }

    public List<SRARouteTO> getRouteTOs() {
        return this.routeTOs;
    }
}

