/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.opensearch;

import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AuditEventDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.opensearch.dao.OpenSearchAnySearchDAO;
import org.apache.syncope.core.persistence.opensearch.dao.OpenSearchAuditEventDAO;
import org.apache.syncope.core.persistence.opensearch.dao.OpenSearchRealmSearchDAO;
import org.apache.syncope.ext.opensearch.client.OpenSearchIndexManager;
import org.apache.syncope.ext.opensearch.client.OpenSearchProperties;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
public class OpenSearchPersistenceContext {
    @ConditionalOnMissingBean(name={"openSearchAnySearchDAO"})
    @Bean
    public AnySearchDAO anySearchDAO(RealmSearchDAO realmSearchDAO, @Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, OpenSearchClient client, OpenSearchProperties props) {
        return new OpenSearchAnySearchDAO(realmSearchDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, client, props.getIndexMaxResultWindow());
    }

    @ConditionalOnMissingBean(name={"openSearchRealmSearchDAO"})
    @Bean
    public RealmSearchDAO realmSearchDAO(@Lazy RealmDAO realmDAO, OpenSearchClient client, OpenSearchProperties props) {
        return new OpenSearchRealmSearchDAO(realmDAO, client, props.getIndexMaxResultWindow());
    }

    @ConditionalOnMissingBean(name={"openSearchAuditEventDAO"})
    @Bean
    public AuditEventDAO auditEventDAO(OpenSearchIndexManager indexManager, OpenSearchClient client, OpenSearchProperties props) {
        return new OpenSearchAuditEventDAO(indexManager, client, props.getIndexMaxResultWindow());
    }
}

