/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.TupleKey;
import org.apache.syncope.ext.openfga.client.model.TupleOperation;

@JsonPropertyOrder(value={"tuple_key", "operation", "timestamp"})
public class TupleChange {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    @Nonnull
    private TupleKey tupleKey;
    public static final String JSON_PROPERTY_OPERATION = "operation";
    @Nonnull
    private TupleOperation operation = TupleOperation.TUPLE_OPERATION_WRITE;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    @Nonnull
    private OffsetDateTime timestamp;

    public TupleChange tupleKey(@Nonnull TupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTupleKey(@Nonnull TupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public TupleChange operation(@Nonnull TupleOperation operation) {
        this.operation = operation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TupleOperation getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperation(@Nonnull TupleOperation operation) {
        this.operation = operation;
    }

    public TupleChange timestamp(@Nonnull OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestamp(@Nonnull OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleChange tupleChange = (TupleChange)o;
        return Objects.equals(this.tupleKey, tupleChange.tupleKey) && Objects.equals((Object)this.operation, (Object)tupleChange.operation) && Objects.equals(this.timestamp, tupleChange.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.operation, this.timestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TupleChange {\n");
        sb.append("    tupleKey: ").append(this.toIndentedString(this.tupleKey)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTupleKey() != null) {
            joiner.add(this.getTupleKey().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE_KEY + suffix));
        }
        if (this.getOperation() != null) {
            joiner.add(String.format("%soperation%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString((Object)this.getOperation()))));
        }
        if (this.getTimestamp() != null) {
            joiner.add(String.format("%stimestamp%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getTimestamp()))));
        }
        return joiner.toString();
    }
}

